/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.languages.cpp.library.preferences;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.Activator;

public class MonitoringPreferencesUtil {
    protected static IPreferenceStore preferenceStore = null;
    private static final Pattern IP_PATTERN = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");

    public static void initPreferenceStore() {
        if (preferenceStore == null) {
            preferenceStore = Activator.getDefault().getPreferenceStore();
        }
    }

    public static String getIpAddress() {
        MonitoringPreferencesUtil.initPreferenceStore();
        String ip = Platform.getPreferencesService().getString("org.eclipse.papyrus.designer.monitoring.sm", "papyrusMonitorIpAddress", "127.0.0.1", null);
        if (ip == null || !MonitoringPreferencesUtil.validate(ip)) {
            ip = "127.0.0.1";
        }
        return ip;
    }

    public static int getPort() {
        MonitoringPreferencesUtil.initPreferenceStore();
        int port = Platform.getPreferencesService().getInt("org.eclipse.papyrus.designer.monitoring.sm", "papyrusMonitorPort", 4445, null);
        if (port <= 0) {
            port = 4445;
        }
        return port;
    }

    public static boolean getEnabled() {
        MonitoringPreferencesUtil.initPreferenceStore();
        return Platform.getPreferencesService().getBoolean("org.eclipse.papyrus.designer.monitoring.sm", "papyrusMonitorEnabled", false, null);
    }

    private static boolean validate(String ip) {
        return IP_PATTERN.matcher(ip).matches();
    }
}

