/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type;

import java.util.List;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.TypedNode;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.AnnotationExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.internal.Utils;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.Type;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.visitor.GenericVisitor;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.visitor.VoidVisitor;

public final class ReferenceType
extends Type
implements TypedNode {
    private Type type;
    private int arrayCount;
    private List<List<AnnotationExpr>> arraysAnnotations;

    public ReferenceType() {
    }

    public ReferenceType(Type type) {
        this.setType(type);
    }

    public ReferenceType(Type type, int arrayCount) {
        this.setType(type);
        this.setArrayCount(arrayCount);
    }

    public ReferenceType(int beginLine, int beginColumn, int endLine, int endColumn, Type type, int arrayCount) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setType(type);
        this.setArrayCount(arrayCount);
    }

    public ReferenceType(int beginLine, int beginColumn, int endLine, int endColumn, Type type, int arrayCount, List<AnnotationExpr> annotations, List<List<AnnotationExpr>> arraysAnnotations) {
        super(beginLine, beginColumn, endLine, endColumn, annotations);
        this.setType(type);
        this.setArrayCount(arrayCount);
        this.arraysAnnotations = arraysAnnotations;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public int getArrayCount() {
        return this.arrayCount;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public void setArrayCount(int arrayCount) {
        this.arrayCount = arrayCount;
    }

    @Override
    public void setType(Type type) {
        this.type = type;
        this.setAsParentNodeOf(this.type);
    }

    public List<List<AnnotationExpr>> getArraysAnnotations() {
        this.arraysAnnotations = Utils.ensureNotNull(this.arraysAnnotations);
        return this.arraysAnnotations;
    }

    public void setArraysAnnotations(List<List<AnnotationExpr>> arraysAnnotations) {
        this.arraysAnnotations = arraysAnnotations;
    }
}

