/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.jdt.texteditor.editor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.papyrus.designer.languages.java.jdt.texteditor.Activator;
import org.eclipse.papyrus.designer.languages.java.jdt.texteditor.sync.ObtainIJavaElement;
import org.eclipse.papyrus.designer.languages.java.jdt.texteditor.sync.SyncJDTtoModel;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.lifecycleevents.DoSaveEvent;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ILifeCycleEventsProvider;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ISaveEventListener;
import org.eclipse.papyrus.infra.ui.services.EditorLifecycleEventListener;
import org.eclipse.papyrus.infra.ui.services.EditorLifecycleManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.NamedElement;

public class SyncJDTEditor
extends CompilationUnitEditor {
    protected ILifeCycleEventsProvider lifeCycleEvents;
    protected ISaveEventListener preSaveEvent;
    protected FocusListener focusListener;
    protected SyncJDTtoModel syncJava;
    protected Composite syncBar;
    public static final RGB ORANGE = new RGB(240, 150, 100);
    public static final RGB GREEN = new RGB(150, 230, 100);

    public void setEditorData(ServicesRegistry registry, SyncJDTtoModel syncJava) {
        try {
            this.syncJava = syncJava;
            this.lifeCycleEvents = (ILifeCycleEventsProvider)registry.getService(ILifeCycleEventsProvider.class);
            this.syncBar.setBackground(new Color((Device)Display.getDefault(), GREEN));
            this.preSaveEvent = new ISaveEventListener(){

                public void doSaveAs(DoSaveEvent event) {
                }

                public void doSave(DoSaveEvent event) {
                    ITypeRoot root = SyncJDTEditor.this.getInputJavaElement();
                    SyncJDTEditor.this.syncJava.syncJDTtoModel(root);
                }
            };
            this.lifeCycleEvents.addAboutToDoSaveListener(this.preSaveEvent);
            EditorLifecycleManager editorlifeCycle = (EditorLifecycleManager)registry.getService(EditorLifecycleManager.class);
            EditorLifecycleEventListener closeListener = new EditorLifecycleEventListener(){

                public void postInit(IMultiDiagramEditor editor) {
                }

                public void postDisplay(IMultiDiagramEditor editor) {
                }

                public void beforeClose(IMultiDiagramEditor editor) {
                    SyncJDTEditor.this.syncJava = null;
                    SyncJDTEditor.this.syncBar.setBackground(new Color((Device)Display.getDefault(), ORANGE));
                }
            };
            editorlifeCycle.addEditorLifecycleEventsListener(closeListener);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public ISourceViewer createJavaSourceViewer(Composite editorComposite, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean isOverviewRulerVisible, int styles, IPreferenceStore store) {
        Composite parent = editorComposite.getParent();
        this.syncBar = new Composite(parent, 0);
        GridData barGD = new GridData();
        barGD.heightHint = 5;
        barGD.horizontalAlignment = 4;
        this.syncBar.setLayoutData((Object)barGD);
        ISourceViewer viewer = super.createJavaSourceViewer(editorComposite, ruler, overviewRuler, isOverviewRulerVisible, styles, store);
        GridData editorGD = new GridData();
        editorGD.horizontalAlignment = 4;
        editorGD.verticalAlignment = 4;
        editorGD.grabExcessHorizontalSpace = true;
        editorGD.grabExcessVerticalSpace = true;
        this.syncBar.setBackground(new Color((Device)Display.getDefault(), ORANGE));
        parent.pack();
        this.focusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (SyncJDTEditor.this.isDirty() && SyncJDTEditor.this.syncJava != null) {
                    SyncJDTEditor.this.doSave((IProgressMonitor)new NullProgressMonitor());
                    ITypeRoot root = SyncJDTEditor.this.getInputJavaElement();
                    SyncJDTEditor.this.syncJava.syncJDTtoModel(root);
                }
            }

            public void focusGained(FocusEvent e) {
            }
        };
        viewer.getTextWidget().addFocusListener(this.focusListener);
        return viewer;
    }

    public void gotoElement(NamedElement element) {
        ITypeRoot inputJE = this.getInputJavaElement();
        if (inputJE instanceof ICompilationUnit) {
            ICompilationUnit icu = (ICompilationUnit)inputJE;
            IJavaElement icElement = ObtainIJavaElement.getIJavaElement(this.syncJava.getCodeGen(), (IParent)icu, element);
            if (icElement instanceof ISourceReference) {
                try {
                    ISourceRange range = ((ISourceReference)icElement).getSourceRange();
                    ISourceViewer viewer = this.getSourceViewer();
                    viewer.revealRange(range.getOffset(), 1);
                    viewer.setSelectedRange(range.getOffset(), range.getLength());
                    return;
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
    }

    public void dispose() {
        StyledText st = this.getSourceViewer().getTextWidget();
        if (st != null && this.focusListener != null) {
            st.removeFocusListener(this.focusListener);
        }
        if (this.lifeCycleEvents != null) {
            this.lifeCycleEvents.removeAboutToDoSaveListener(this.preSaveEvent);
        }
    }
}

