/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.modellibs.core.mappingrules;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.components.FCM.Port;
import org.eclipse.papyrus.designer.components.FCM.PortKind;
import org.eclipse.papyrus.designer.components.fcm.profile.ITemplateMappingRule;
import org.eclipse.papyrus.designer.components.modellibs.core.Activator;
import org.eclipse.papyrus.designer.components.modellibs.core.Messages;
import org.eclipse.papyrus.designer.components.transformation.component.filters.FixTemplateSync;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.templates.TemplateInstantiation;
import org.eclipse.papyrus.designer.transformation.core.templates.TemplateUtils;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class TemplatePort
implements ITemplateMappingRule {
    public Type calcDerivedType(Port p, boolean update) {
        return null;
    }

    public PortKind getBoundType(Port p) {
        org.eclipse.uml2.uml.Port port = p.getBase_Port();
        Type type = p.getType();
        if (!(type instanceof Classifier)) {
            return null;
        }
        if (p.getKind() == null) {
            return null;
        }
        Class extendedPort = p.getKind().getBase_Class();
        TemplateSignature signature = TemplateUtils.getSignature((TemplateableElement)extendedPort.getNearestPackage());
        Package pkgTemplate = signature.getNearestPackage();
        if (pkgTemplate != null) {
            EList path = TemplateUtils.relativePathWithMerge((Element)extendedPort, (Namespace)pkgTemplate);
            String name = String.valueOf(pkgTemplate.getName()) + "_" + type.getName();
            Package model = PackageUtil.getRootPackage((Element)port);
            Package pkg = model.getNestedPackage(name);
            if (pkg == null) {
                model = PackageUtil.getRootPackage((Element)port);
                pkg = model.getNestedPackage(name);
            }
            if (pkg != null) {
                for (Namespace pathElem : path) {
                    if ((pkg = pkg.getNestedPackage(pathElem.getName())) != null) continue;
                    return null;
                }
                PackageableElement boundClass = pkg.getPackagedElement(extendedPort.getName());
                if (boundClass != null) {
                    return (PortKind)UMLUtil.getStereotypeApplication((Element)boundClass, PortKind.class);
                }
            }
        }
        return null;
    }

    public void updateBinding(Port p) {
        org.eclipse.uml2.uml.Port port = p.getBase_Port();
        Type type = p.getType();
        if (!(type instanceof Classifier)) {
            return;
        }
        Class extendedPort = p.getKind().getBase_Class();
        TemplateSignature signature = TemplateUtils.getSignature((TemplateableElement)extendedPort.getNearestPackage());
        if (signature != null) {
            Package model = PackageUtil.getRootPackage((Element)port);
            try {
                TemplateBinding binding = TemplateUtils.fixedBinding((Package)model, (TemplateableElement)extendedPort, (Classifier)((Classifier)type));
                LazyCopier copier = new LazyCopier(model, model, LazyCopier.CopyExtResources.NONE, true);
                TemplateInstantiation ti = new TemplateInstantiation(binding);
                if (copier.postCopyListeners.contains((Object)FixTemplateSync.getInstance())) {
                    copier.postCopyListeners.remove((Object)FixTemplateSync.getInstance());
                }
                ti.bindElement((Element)extendedPort);
            }
            catch (TransformationException e) {
                Activator.log.error(Messages.TemplatePort_CANT_CREATE_TEMPLATE_BINDING, (Throwable)e);
            }
        }
    }

    public boolean needsUpdate(Port p) {
        org.eclipse.uml2.uml.Port port = p.getBase_Port();
        Type type = port.getType();
        if (!(type instanceof Classifier)) {
            return false;
        }
        if (p.getKind() == null) {
            return false;
        }
        Class extendedPort = p.getKind().getBase_Class();
        TemplateSignature signature = TemplateUtils.getSignature((TemplateableElement)extendedPort.getNearestPackage());
        Package pkgTemplate = signature.getNearestPackage();
        if (pkgTemplate != null) {
            EList path = TemplateUtils.relativePathWithMerge((Element)extendedPort, (Namespace)pkgTemplate);
            String name = String.valueOf(pkgTemplate.getName()) + "_" + type.getName();
            Package model = PackageUtil.getRootPackage((Element)port);
            Package pkg = model.getNestedPackage(name);
            if (pkg == null) {
                model = PackageUtil.getRootPackage((Element)port);
                pkg = model.getNestedPackage(name);
            }
            if (pkg != null) {
                for (Namespace pathElem : path) {
                    if ((pkg = pkg.getNestedPackage(pathElem.getName())) != null) continue;
                    return true;
                }
                PackageableElement boundClass = pkg.getPackagedElement(extendedPort.getName());
                if (boundClass != null && UMLUtil.getStereotypeApplication((Element)boundClass, PortKind.class) != null) {
                    return false;
                }
            }
        }
        return true;
    }
}

