/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.ucm.core.menu;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.papyrus.designer.ucm.core.Messages;
import org.eclipse.papyrus.designer.ucm.core.menu.EnhancedPopupMenu;
import org.eclipse.papyrus.designer.ucm.core.provider.UCMLabelProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.uml2.uml.Type;

public class MenuHelper {
    public static final String CREATE_NEW_TYPE = "Create new type";

    public static List<Object> createMenuItems(IStaticContentProvider cp, String title, boolean allowNew) {
        ArrayList<Object> menuItems = new ArrayList<Object>();
        menuItems.add(new EnhancedPopupMenu.Disabled(title));
        menuItems.add(new EnhancedPopupMenu.Separator());
        if (allowNew) {
            menuItems.add(CREATE_NEW_TYPE);
        }
        if (cp.getElements().length > 0) {
            if (cp.getElements().length < 5) {
                if (cp.getElements()[0] instanceof Type) {
                    menuItems.add(new EnhancedPopupMenu.Disabled(Messages.MenuHelper_ExistingTypes));
                }
                Object[] objectArray = cp.getElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    menuItems.add(element);
                    ++n2;
                }
            } else {
                menuItems.add(new EnhancedPopupMenu.SubSelect(Messages.MenuHelper_SelectExistingTypes, (IStructuredContentProvider)cp));
            }
        }
        return menuItems;
    }

    public static EnhancedPopupMenu createPopupMenu(IStaticContentProvider cp, String title, boolean allowNew) {
        return new EnhancedPopupMenu(MenuHelper.createMenuItems(cp, title, allowNew), (ILabelProvider)new UCMLabelProvider());
    }
}

