/*****************************************************************************
 * Copyright (c) 2016 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  CEA LIST - Initial API and implementation
 *
 *****************************************************************************/

package org.eclipse.papyrus.designer.transformation.base.preferences;

/**
 * Constant definitions for plug-in preferences
 */
public class PapyrusDesignerPreferenceConstants {

	/**
	 * For attributes, the default "aggregation kind" value is "none". When this option is set
	 * it will be treated as composite
	 */
	public static final String P_TREAT_NONE_AS_COMPOSITE = "treatNoneAsComposite"; //$NON-NLS-1$

	public static final String P_ALL_ATTRIBUTES_ARE_CONFIG_ATTRIBUTES = "allAttributesAreConfigAttributes"; //$NON-NLS-1$

	public static final String P_SHOW_PROV_REQ_AS_PORT_ICONS = "showProvReqAsPortIcons"; //$NON-NLS-1$

	public static final String P_CODE_GEN_PREFIX = "codeGenPrefix"; //$NON-NLS-1$

}
