/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse.reverse;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.IStructureDeclaration;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Array;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Const;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.External;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Friend;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Inline;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Mutable;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ref;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Variadic;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Virtual;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Volatile;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ReverseUtils {
    private static ReverseUtils instance;

    public static ReverseUtils getInstance() {
        ReverseUtils _xblockexpression = null;
        if (instance == null) {
            ReverseUtils _reverseUtils;
            instance = _reverseUtils = new ReverseUtils();
        }
        _xblockexpression = instance;
        return _xblockexpression;
    }

    public void analyzeDeclaration(List<IASTDeclarator> declarators, Type type, TypedElement typedElement, String langID) {
        for (IASTDeclarator declarator : declarators) {
            this.analyzeDeclaration(declarator, type, typedElement, langID);
        }
    }

    public void analyzeDeclaration(IASTDeclarator declarator, Type type, final TypedElement typedElement, String langID) {
        try {
            IASTPointerOperator[] _pointerOperators;
            boolean _tripleNotEquals;
            Object _function;
            int _isApplied;
            if (declarator instanceof ICPPASTArrayDeclarator) {
                boolean _greaterThan;
                ICPPASTArrayDeclarator arrayDeclarator = (ICPPASTArrayDeclarator)declarator;
                IASTArrayModifier[] arrays = arrayDeclarator.getArrayModifiers();
                IASTArrayModifier[] _converted_arrays = arrays;
                int _size = ((List)Conversions.doWrapArray((Object)_converted_arrays)).size();
                boolean bl = _greaterThan = _size > 0;
                if (_greaterThan) {
                    _isApplied = StereotypeUtil.isApplied((Element)typedElement, Array.class);
                    if (_isApplied != 0) {
                        StereotypeUtil.unapply((Element)typedElement, Array.class);
                    }
                    this.applyStereotype((Element)typedElement, true, StereotypeType.ARRAY, "");
                    IASTArrayModifier[] _converted_arrays_1 = arrays;
                    _function = new Consumer<IASTArrayModifier>(){

                        @Override
                        public void accept(IASTArrayModifier it) {
                            IASTExpression expr = it.getConstantExpression();
                            if (expr != null) {
                                String definition = ((Array)UMLUtil.getStereotypeApplication((Element)typedElement, Array.class)).getDefinition();
                                Array _stereotypeApplication = (Array)UMLUtil.getStereotypeApplication((Element)typedElement, Array.class);
                                String _string = expr.toString();
                                String _plus = String.valueOf(definition) + "[" + _string;
                                String _plus_1 = String.valueOf(_plus) + "]";
                                _stereotypeApplication.setDefinition(_plus_1);
                            }
                        }
                    };
                    ((List)Conversions.doWrapArray((Object)_converted_arrays_1)).forEach(_function);
                }
            }
            boolean bl = _tripleNotEquals = (_pointerOperators = declarator.getPointerOperators()) != null;
            if (_tripleNotEquals) {
                String value_3;
                boolean _isApplied_5;
                IASTPointerOperator[] _pointerOperators_1;
                boolean _isApplied_1 = StereotypeUtil.isApplied((Element)typedElement, Ptr.class);
                if (_isApplied_1) {
                    Ptr _stereotypeApplication = (Ptr)UMLUtil.getStereotypeApplication((Element)typedElement, Ptr.class);
                    _stereotypeApplication.setDeclaration("");
                }
                _function = _pointerOperators_1 = declarator.getPointerOperators();
                int _converted_arrays_1 = _pointerOperators_1.length;
                _isApplied = 0;
                while (_isApplied < _converted_arrays_1) {
                    IASTPointerOperator pointerOperator = _function[_isApplied];
                    if (pointerOperator instanceof ICPPASTReferenceOperator) {
                        boolean _not;
                        ICPPASTReferenceOperator reference = (ICPPASTReferenceOperator)pointerOperator;
                        boolean _isApplied_2 = StereotypeUtil.isApplied((Element)typedElement, Ref.class);
                        boolean bl2 = _not = !_isApplied_2;
                        if (_not) {
                            this.applyStereotype((Element)typedElement, true, StereotypeType.REFERENCE, reference.getSyntax().toString());
                        } else {
                            String value = ((Ref)UMLUtil.getStereotypeApplication((Element)typedElement, Ref.class)).getDeclaration();
                            Ref _stereotypeApplication_1 = (Ref)UMLUtil.getStereotypeApplication((Element)typedElement, Ref.class);
                            String _string = reference.getSyntax().toString();
                            String _plus = String.valueOf(value) + _string;
                            _stereotypeApplication_1.setDeclaration(_plus);
                        }
                    } else if (pointerOperator instanceof IASTPointerOperator) {
                        boolean _not_1;
                        IASTPointerOperator pointer = pointerOperator;
                        boolean _isApplied_3 = StereotypeUtil.isApplied((Element)typedElement, Ptr.class);
                        boolean bl3 = _not_1 = !_isApplied_3;
                        if (_not_1) {
                            this.applyStereotype((Element)typedElement, true, StereotypeType.POINTER, pointer.getSyntax().toString());
                        } else {
                            String value_1 = ((Ptr)UMLUtil.getStereotypeApplication((Element)typedElement, Ptr.class)).getDeclaration();
                            Ptr _stereotypeApplication_2 = (Ptr)UMLUtil.getStereotypeApplication((Element)typedElement, Ptr.class);
                            String _string_1 = pointer.getSyntax().toString();
                            String _plus_1 = String.valueOf(value_1) + _string_1;
                            _stereotypeApplication_2.setDeclaration(_plus_1);
                        }
                    }
                    ++_isApplied;
                }
                boolean _isApplied_4 = StereotypeUtil.isApplied((Element)typedElement, Ptr.class);
                if (_isApplied_4) {
                    boolean _equals;
                    Pattern pattern;
                    Matcher matcher;
                    boolean _find;
                    String value_2 = ((Ptr)UMLUtil.getStereotypeApplication((Element)typedElement, Ptr.class)).getDeclaration();
                    if (value_2 == null) {
                        value_2 = "*";
                    }
                    if (_find = (matcher = (pattern = Pattern.compile("(\\*)([\\s]*)(const)")).matcher(declarator.getRawSignature())).find()) {
                        String _value = value_2;
                        value_2 = String.valueOf(_value) + " const";
                        Ptr _stereotypeApplication_3 = (Ptr)UMLUtil.getStereotypeApplication((Element)typedElement, Ptr.class);
                        _stereotypeApplication_3.setDeclaration(value_2);
                    }
                    if (_equals = value_2.trim().equals("*")) {
                        Ptr _stereotypeApplication_4 = (Ptr)UMLUtil.getStereotypeApplication((Element)typedElement, Ptr.class);
                        _stereotypeApplication_4.setDeclaration(null);
                    }
                }
                if ((_isApplied_5 = StereotypeUtil.isApplied((Element)typedElement, Ref.class)) && (value_3 = ((Ref)UMLUtil.getStereotypeApplication((Element)typedElement, Ref.class)).getDeclaration()) != null && value_3.trim().equals("&")) {
                    Ref _stereotypeApplication_5 = (Ref)UMLUtil.getStereotypeApplication((Element)typedElement, Ref.class);
                    _stereotypeApplication_5.setDeclaration(null);
                }
            }
            IASTInitializer initilizer = declarator.getInitializer();
            Functions.Function1<ValueSpecification, Boolean> _function_1 = new Functions.Function1<ValueSpecification, Boolean>(){

                public Boolean apply(ValueSpecification it) {
                    return it.getName().equals("defaultValue");
                }
            };
            ValueSpecification valueExisting = (ValueSpecification)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)typedElement.getOwnedElements(), ValueSpecification.class), (Functions.Function1)_function_1));
            if (valueExisting != null) {
                valueExisting.destroy();
            }
            if (initilizer != null) {
                IASTEqualsInitializer equalsInitialiser;
                IASTInitializerClause clause;
                ValueSpecification vs = null;
                if (typedElement instanceof Property) {
                    vs = ((Property)typedElement).createDefaultValue("defaultValue", ((Property)typedElement).getType(), UMLPackage.Literals.OPAQUE_EXPRESSION);
                } else if (typedElement instanceof Parameter) {
                    vs = ((Parameter)typedElement).createDefaultValue("default", ((Parameter)typedElement).getType(), UMLPackage.Literals.OPAQUE_EXPRESSION);
                }
                if (vs == null) {
                    return;
                }
                OpaqueExpression oe = (OpaqueExpression)vs;
                oe.getLanguages().add((Object)langID);
                if (initilizer instanceof IASTEqualsInitializer && (clause = (equalsInitialiser = (IASTEqualsInitializer)initilizer).getInitializerClause()) != null) {
                    oe.getBodies().add((Object)clause.getRawSignature());
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void applyStereotype(Element element, boolean isApply, StereotypeType stType, String additional) {
        if (!isApply) {
            return;
        }
        if (stType != null) {
            switch (stType) {
                case CONST: {
                    StereotypeUtil.apply((Element)element, Const.class);
                    break;
                }
                case VOLATILE: {
                    StereotypeUtil.apply((Element)element, Volatile.class);
                    break;
                }
                case ARRAY: {
                    StereotypeUtil.apply((Element)element, Array.class);
                    Array _stereotypeApplication = (Array)UMLUtil.getStereotypeApplication((Element)element, Array.class);
                    _stereotypeApplication.setDefinition(additional);
                    break;
                }
                case POINTER: {
                    StereotypeUtil.apply((Element)element, Ptr.class);
                    Ptr _stereotypeApplication_1 = (Ptr)UMLUtil.getStereotypeApplication((Element)element, Ptr.class);
                    _stereotypeApplication_1.setDeclaration(additional);
                    break;
                }
                case REFERENCE: {
                    StereotypeUtil.apply((Element)element, Ref.class);
                    Ref _stereotypeApplication_2 = (Ref)UMLUtil.getStereotypeApplication((Element)element, Ref.class);
                    _stereotypeApplication_2.setDeclaration(additional);
                    break;
                }
                case EXTERNAL: {
                    StereotypeUtil.apply((Element)element, External.class);
                    break;
                }
                case FRIENDLINE: {
                    StereotypeUtil.apply((Element)element, Friend.class);
                    break;
                }
                case VIRTUAL: {
                    StereotypeUtil.apply((Element)element, Virtual.class);
                    break;
                }
                case INLINE: {
                    StereotypeUtil.apply((Element)element, Inline.class);
                    break;
                }
                case CREATE: {
                    StereotypeUtil.apply((Element)element, (String)"StandardProfile::Create");
                    break;
                }
                case DESTROY: {
                    StereotypeUtil.apply((Element)element, (String)"StandardProfile::Destroy");
                    break;
                }
                case MUTABLE: {
                    StereotypeUtil.apply((Element)element, Mutable.class);
                    break;
                }
                case VARIADIC: {
                    StereotypeUtil.apply((Element)element, Variadic.class);
                    break;
                }
            }
        }
    }

    public String getCppTypeName(IASTDeclSpecifier declarator) {
        String parameterTypeName;
        block5: {
            parameterTypeName = "";
            try {
                IToken token = declarator.getSyntax();
                while (token != null) {
                    boolean _equals_2;
                    boolean _equals_1;
                    String tokenStr = token.toString();
                    boolean _equals = tokenStr.equals("*");
                    if (!(_equals || (_equals_1 = tokenStr.equals("&")) || (_equals_2 = tokenStr.equals("const")))) {
                        boolean _greaterThan;
                        int _length = parameterTypeName.length();
                        boolean bl = _greaterThan = _length > 0;
                        if (_greaterThan) {
                            String _parameterTypeName = parameterTypeName;
                            parameterTypeName = String.valueOf(_parameterTypeName) + " ";
                        }
                        String _parameterTypeName_1 = parameterTypeName;
                        parameterTypeName = String.valueOf(_parameterTypeName_1) + tokenStr;
                    }
                    token = token.getNext();
                }
            }
            catch (Throwable _t) {
                if (_t instanceof ExpansionOverlapsBoundaryException) break block5;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return parameterTypeName;
    }

    public static String getCppTypeName(String name) {
        String trimName = name.trim();
        trimName = trimName.replace("*", "");
        trimName = trimName.replace("&", "");
        trimName = trimName.replace("[", "");
        trimName = trimName.replace("]", "");
        trimName = trimName.replace("const ", "");
        trimName = trimName.replace(" const", "");
        trimName = trimName.replace("volatile", "");
        trimName = trimName.replace(" volatile", "");
        trimName = trimName.trim();
        return trimName;
    }

    public List<ICElement> getAllIStructures(IParent parent, boolean allIncludes, boolean lookNestedTypes, ICProject project) {
        try {
            UniqueEList ret = new UniqueEList();
            ICElement[] childrend = parent.getChildren();
            int i = 0;
            while (i < childrend.length) {
                ICElement child = childrend[i];
                boolean _matched = false;
                if (child instanceof IStructure) {
                    _matched = true;
                    ret.add((IStructure)child);
                    if (lookNestedTypes) {
                        ret.addAll(this.getAllIStructures((IParent)((IStructure)child), allIncludes, lookNestedTypes, project));
                    }
                }
                if (!_matched && child instanceof IEnumeration) {
                    _matched = true;
                    ret.add((IEnumeration)child);
                }
                if (!_matched && child instanceof IParent) {
                    _matched = true;
                    ret.addAll(this.getAllIStructures((IParent)child, allIncludes, lookNestedTypes, project));
                }
                if (!_matched && child instanceof IInclude) {
                    ITranslationUnit unit;
                    _matched = true;
                    if (allIncludes && (unit = this.getTranslationUnitFromInclude((IInclude)child, project)) != null) {
                        ret.addAll(this.getAllIStructures((IParent)unit, allIncludes, lookNestedTypes, project));
                    }
                }
                if (!_matched && child instanceof ITypeDef) {
                    _matched = true;
                    ret.add(child);
                }
                if (!_matched && child instanceof IStructureDeclaration) {
                    _matched = true;
                    ret.add(child);
                }
                ++i;
            }
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ITranslationUnit getTranslationUnitFromInclude(IInclude include, ICProject project) {
        boolean _not;
        boolean _contains = include.getFullFileName().contains(project.getElementName());
        boolean bl = _not = !_contains;
        if (_not) {
            return null;
        }
        ITranslationUnit ret = null;
        String fileIncludePath = (String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)include.getFullFileName().split(project.getElementName()))));
        IFile file = project.getProject().getFile(fileIncludePath);
        if (file != null) {
            ITranslationUnit unit = CoreModelUtil.findTranslationUnit((IFile)file);
            if (unit == null) {
                unit = CoreModel.getDefault().createTranslationUnitFrom(project, file.getLocation());
            }
            ret = unit;
        }
        return ret;
    }

    public ITranslationUnit getTranslationUnitFromElement(ICElement element) {
        ICElement owner = element.getParent();
        while (owner != null && !(owner instanceof ITranslationUnit)) {
            owner = owner.getParent();
        }
        return (ITranslationUnit)owner;
    }

    public boolean isSatisfyNamespace(List<String> iUsings, ICElement istructure) {
        if (!(istructure.getParent() instanceof INamespace) && !(istructure.getParent() instanceof IStructure)) {
            return true;
        }
        final StringBuilder namespaces = new StringBuilder();
        ICElement owner = istructure.getParent();
        namespaces.append(owner.getElementName());
        while (owner.getParent() instanceof INamespace || owner.getParent() instanceof IStructure) {
            ICElement _parent = owner.getParent();
            String _elementName = ((INamespace)_parent).getElementName();
            String _plus = String.valueOf(_elementName) + "::";
            namespaces.insert(0, _plus);
            owner = owner.getParent();
        }
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                return it.equals(namespaces.toString()) || it.contains(namespaces.toString().trim());
            }
        };
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter(iUsings, (Functions.Function1)_function));
        return !_isEmpty;
    }

    public List<String> getContextNamespaces(ICElement element) {
        UniqueEList ret = new UniqueEList();
        ICElement owner = element.getParent();
        while (owner != null) {
            if (owner instanceof INamespace || owner instanceof IStructure || owner instanceof ICContainer) {
                boolean _greaterThan;
                ret.add(owner.getElementName());
                UniqueEList _converted_ret = ret;
                int _length = ((Object[])Conversions.unwrapArray((Object)_converted_ret, Object.class)).length;
                boolean bl = _greaterThan = _length > 1;
                if (_greaterThan) {
                    String n = (String)IterableExtensions.head((Iterable)ret);
                    UniqueEList _converted_ret_1 = ret;
                    int len = ((Object[])Conversions.unwrapArray((Object)_converted_ret_1, Object.class)).length;
                    int i = 1;
                    while (i < len) {
                        boolean _not;
                        boolean _contains = ((String)ret.get(i)).contains("::");
                        boolean bl2 = _not = !_contains;
                        if (_not) {
                            String _plus_1;
                            String _get = (String)ret.get(i);
                            String _plus = String.valueOf(_get) + "::";
                            n = _plus_1 = String.valueOf(_plus) + n;
                        }
                        ++i;
                    }
                    ret.add(n);
                }
            }
            owner = owner.getParent();
        }
        return ret;
    }

    public Package getNearestPackage(Element element) {
        return element.getNearestPackage();
    }

    public void unapplyAllStereotypes(final Element element) {
        EList stereotypeAppList = element.getStereotypeApplications();
        Consumer<EObject> _function = new Consumer<EObject>(){

            @Override
            public void accept(EObject it) {
                Stereotype stereotype = UMLUtil.getStereotype((EObject)it);
                element.unapplyStereotype(stereotype);
            }
        };
        stereotypeAppList.forEach((Consumer)_function);
    }

    public static enum StereotypeType {
        CONST,
        VOLATILE,
        ARRAY,
        POINTER,
        REFERENCE,
        EXTERNAL,
        FRIENDLINE,
        VIRTUAL,
        INLINE,
        CREATE,
        DESTROY,
        MUTABLE,
        VARIADIC;

    }
}

