/**
 * Copyright (c) 2014 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen.xtend;

import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppOperations;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Inline;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * @author Önder GÜRCAN (onder.gurcan@cea.fr)
 */
@SuppressWarnings("all")
public class CppClassOperationsImplementation {
  public static CharSequence CppClassOperationsImplementation(final Classifier clazz, final boolean inline) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<Operation, Boolean> _function = new Function1<Operation, Boolean>() {
        @Override
        public Boolean apply(final Operation it) {
          return Boolean.valueOf(((!(GenUtils.hasStereotype(it, NoCodeGen.class) || it.isAbstract())) && (GenUtils.hasStereotype(it, Inline.class) == inline)));
        }
      };
      Iterable<Operation> _filter = IterableExtensions.<Operation>filter(CppOperations.getOwnedOperations(clazz), _function);
      boolean _hasElements = false;
      for(final Operation ownedOperation : _filter) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate("\n", "");
        }
        CharSequence _CppOperationImplementation = CppOperations.CppOperationImplementation(ownedOperation);
        _builder.append(_CppOperationImplementation);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      final Function1<Operation, Boolean> _function_1 = new Function1<Operation, Boolean>() {
        @Override
        public Boolean apply(final Operation it) {
          return Boolean.valueOf(((!(GenUtils.hasStereotype(it, NoCodeGen.class) || it.isAbstract())) && (GenUtils.hasStereotype(it, Inline.class) == inline)));
        }
      };
      Iterable<Operation> _filter_1 = IterableExtensions.<Operation>filter(CppOperations.getNestedOperations(clazz), _function_1);
      boolean _hasElements_1 = false;
      for(final Operation nestedOperation : _filter_1) {
        if (!_hasElements_1) {
          _hasElements_1 = true;
        } else {
          _builder.appendImmediate("\n", "");
        }
        CharSequence _CppOperationImplementation_1 = CppOperations.CppOperationImplementation(nestedOperation);
        _builder.append(_CppOperationImplementation_1);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      final Function1<NamedElement, Boolean> _function_2 = new Function1<NamedElement, Boolean>() {
        @Override
        public Boolean apply(final NamedElement it) {
          return Boolean.valueOf(((it instanceof OpaqueBehavior) && (GenUtils.hasStereotype(((OpaqueBehavior) it), Inline.class) == inline)));
        }
      };
      Iterable<NamedElement> _filter_2 = IterableExtensions.<NamedElement>filter(clazz.getOwnedMembers(), _function_2);
      for(final NamedElement b : _filter_2) {
        final OpaqueBehavior ob = ((OpaqueBehavior) b);
        _builder.newLineIfNotEmpty();
        {
          BehavioralFeature _specification = ob.getSpecification();
          boolean _tripleEquals = (_specification == null);
          if (_tripleEquals) {
            _builder.append("// opaque behavior without specification");
            _builder.newLine();
            CharSequence _CppBehaviorImplementation = CppOperations.CppBehaviorImplementation(((OpaqueBehavior) b));
            _builder.append(_CppBehaviorImplementation);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }
}
