/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.codegen.ui;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.GeneratorSelectionDialog;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.LanguageCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.Messages;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.GeneratorHint;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.Language;
import org.eclipse.papyrus.designer.languages.common.profile.CommonProfileResource;
import org.eclipse.papyrus.designer.transformation.base.utils.ApplyProfile;
import org.eclipse.papyrus.designer.transformation.base.utils.CommandSupport;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ChooseGenerator {
    public static final String LANGUAGES_PKG = "languages";

    public static ILangCodegen choose(Pattern languagePattern, PackageableElement pe) {
        List eligibleGenerators = LanguageCodegen.getEligibleGeneratorList((Pattern)languagePattern, (Element)pe);
        if (eligibleGenerators.size() == 0) {
            eligibleGenerators = LanguageCodegen.getCodegenList((Pattern)languagePattern);
        }
        if (eligibleGenerators.size() == 1) {
            return (ILangCodegen)eligibleGenerators.get(0);
        }
        Shell shell = Display.getCurrent().getActiveShell();
        if (eligibleGenerators.size() > 1) {
            GeneratorSelectionDialog dialog = new GeneratorSelectionDialog(shell, eligibleGenerators);
            if (dialog.open() == 0) {
                ILangCodegen codeGen = (ILangCodegen)dialog.getResult()[0];
                Boolean storeResult = (Boolean)dialog.getResult()[1];
                if (storeResult.booleanValue()) {
                    ChooseGenerator.storeGeneratorID(pe, LanguageCodegen.getLanguage((ILangCodegen)codeGen), LanguageCodegen.getID((ILangCodegen)codeGen));
                }
                return codeGen;
            }
        } else {
            String pattern = languagePattern.pattern().replace("\\", "");
            MessageDialog.openError((Shell)shell, (String)Messages.LanguageCodegen_NoGeneratorsFound, (String)String.format(Messages.LanguageCodegen_NoGeneratorsFoundLong, pattern));
        }
        return null;
    }

    public static void storeGeneratorID(PackageableElement pe, String languageName, final String generatorID) {
        final Package root = PackageUtil.getRootPackage((Element)pe);
        CommandSupport.exec((TransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)pe), (Command)new ApplyProfile(root, CommonProfileResource.PROFILE_PATH_URI));
        NamedElement languageNE = ElementUtils.getQualifiedElementFromRS((Element)pe, (String)("languages::" + languageName));
        if (languageNE == null) {
            PackageUtil.loadPackage((URI)CommonProfileResource.LANGUAGES_PATH_URI, (ResourceSet)pe.eResource().getResourceSet());
            languageNE = ElementUtils.getQualifiedElementFromRS((Element)pe, (String)("languages::" + languageName));
        }
        final Language language = languageNE != null ? (Language)UMLUtil.getStereotypeApplication((Element)languageNE, Language.class) : null;
        CommandSupport.exec((EObject)pe, (String)Messages.ChooseGenerator_CHOOSE_GENERATOR, (Runnable)new Runnable(){

            @Override
            public void run() {
                GeneratorHint hint = (GeneratorHint)StereotypeUtil.applyApp((Element)root, GeneratorHint.class);
                hint.setLanguage(language);
                hint.setGeneratorID(generatorID);
            }
        });
    }
}

