/*******************************************************************************
 * Copyright (c) 2006 - 2012 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     CEA LIST - initial API and implementation
 *******************************************************************************/

package org.eclipse.papyrus.designer.languages.c.codegen.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.designer.languages.c.codegen.Activator;

/**
 * Utility class that returns the preference values
 * 
 * @author ansgar
 * 
 */
public class CCodeGenUtils {

	protected static IPreferenceStore preferenceStore = null;

	public static String getHeaderSuffix() {
		initPreferenceStore();
		return preferenceStore.getString(CCodeGenConstants.P_HEADER_SUFFIX);
	}

	public static String getBodySuffix() {
		initPreferenceStore();
		return preferenceStore.getString(CCodeGenConstants.P_IMPLEM_SUFFIX);
	}

	public static String getOutInoutOp() {
		initPreferenceStore();
		return preferenceStore.getString(CCodeGenConstants.P_OUT_INOUT_OP);
	}

	public static String getCommentHeader() {
		initPreferenceStore();
		return preferenceStore.getString(CCodeGenConstants.P_COMMENT_HEADER);
	}

	public static boolean getFormatCode() {
		initPreferenceStore();
		return preferenceStore.getBoolean(CCodeGenConstants.P_FORMAT_CODE);
	}

	public static void initPreferenceStore() {
		if(preferenceStore == null) {
			preferenceStore = Activator.getDefault().getPreferenceStore();
		}
	}

}
