/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.modellibs.core.embeddingrules;

import java.util.ArrayList;
import org.eclipse.papyrus.designer.components.FCM.Connector;
import org.eclipse.papyrus.designer.components.FCM.Port;
import org.eclipse.papyrus.designer.components.FCM.profile.ConnectorTypeUtil;
import org.eclipse.papyrus.designer.components.FCM.profile.FCMUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

public class AccordCall
extends ConnectorTypeUtil {
    private static final String CONNECTOR = "connector";
    private static final String RTU = "rtu";
    private static final String SERVER = "server";
    private static final String CLIENT = "client";
    private ConnectableElement clientRole = null;
    private ConnectableElement serverRole = null;
    private ConnectableElement rtuRole = null;
    private ConnectableElement connectorRole = null;

    public FCMUtil.RoleBindingTable getRoleBindings(Connector connector) {
        super.getRoleBindings(connector);
        this.clientRole = this.bindingTable.getRoleKeyByName(CLIENT);
        this.serverRole = this.bindingTable.getRoleKeyByName(SERVER);
        this.rtuRole = this.bindingTable.getRoleKeyByName(RTU);
        this.connectorRole = this.bindingTable.getRoleKeyByName(CONNECTOR);
        for (ConnectorEnd end : connector.getBase_Connector().getEnds()) {
            if (!(end.getRole() instanceof org.eclipse.uml2.uml.Port)) continue;
            org.eclipse.uml2.uml.Port port = (org.eclipse.uml2.uml.Port)end.getRole();
            Property part = end.getPartWithPort();
            if (!StereotypeUtil.isApplied((Element)port, Port.class)) continue;
            Port fcmPort = (Port)UMLUtil.getStereotypeApplication((Element)port, Port.class);
            if (fcmPort.getKind().getBase_Class().getName().equals("UseInterfaceWithRtf")) {
                ArrayList<Object> clientActors = new ArrayList<Object>();
                clientActors.add(port);
                clientActors.add(part);
                this.bindingTable.addEntry(this.clientRole, clientActors);
                continue;
            }
            if (!fcmPort.getKind().getBase_Class().getName().equals("ProvideInterface")) continue;
            ArrayList<Object> serverActors = new ArrayList<Object>();
            serverActors.add(port);
            serverActors.add(part);
            this.bindingTable.addEntry(this.serverRole, serverActors);
            port = ((Class)part.getType()).getOwnedPort(RTU, null);
            if (port == null) {
                if (((Class)part.getType()).getInheritedMember(RTU) != null && ((Class)part.getType()).getInheritedMember(RTU) instanceof org.eclipse.uml2.uml.Port) {
                    port = (org.eclipse.uml2.uml.Port)((Class)part.getType()).getInheritedMember(RTU);
                } else {
                    System.out.println(String.format("Could not find a port rtu on part %s : %s", part.getName(), part.getType()));
                }
            }
            if (port == null) continue;
            ArrayList<Object> rtuActors = new ArrayList<Object>();
            rtuActors.add(port);
            rtuActors.add(part);
            this.bindingTable.addEntry(this.rtuRole, rtuActors);
        }
        ArrayList<org.eclipse.uml2.uml.Connector> connectorActors = new ArrayList<org.eclipse.uml2.uml.Connector>();
        connectorActors.add(connector.getBase_Connector());
        this.bindingTable.addEntry(this.connectorRole, connectorActors);
        return this.bindingTable;
    }
}

