/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine;

import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Array;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Typedef;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.CDefinitions;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.PThreadTypes;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.SM2ClassesTransformationCore;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.SMCodeGeneratorConstants;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.TimeEventTransformation;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.TransformationUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ConcurrencyGenerator {
    @Extension
    protected CDefinitions cdefs;
    private SM2ClassesTransformationCore core;
    private PThreadTypes ptTypes;
    public Type threadStructType;
    private Class superContext;
    private Package targetPack;

    public ConcurrencyGenerator(SM2ClassesTransformationCore core) {
        Package _targetPacket;
        this.core = core;
        this.superContext = core.superContext;
        this.targetPack = _targetPacket = core.getTargetPacket();
        this.ptTypes = core.ptTypes;
        this.cdefs = core.cdefs;
    }

    public void createThreadBasedParallelism() {
        boolean _greaterThan_7;
        boolean _greaterThan_6;
        boolean _greaterThan_5;
        int _size_4;
        boolean _greaterThan_4;
        int _size_3;
        boolean _greaterThan_3;
        int _size_2;
        boolean _greaterThan_2;
        int _size_1;
        boolean _greaterThan_1;
        boolean _greaterThan;
        Type _threadStructType;
        this.core.appendIncludeHeader("#include \"time.h\"");
        this.core.appendIncludeHeader("#include \"pthread.h\"");
        Type _pthread = this.ptTypes.getPthread();
        Property threads = this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.THREADS, _pthread);
        StereotypeUtil.apply((Element)threads, Array.class);
        Array _stereotypeApplication = (Array)UMLUtil.getStereotypeApplication((Element)threads, Array.class);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("[");
        _builder.append(SMCodeGeneratorConstants.STATE_MAX, "");
        _builder.append("]");
        _stereotypeApplication.setDefinition(_builder.toString());
        Property flags = this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.FLAGS_ACTIVITY, this.core.boolType);
        StereotypeUtil.apply((Element)flags, Array.class);
        Array _stereotypeApplication_1 = (Array)UMLUtil.getStereotypeApplication((Element)flags, Array.class);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("[");
        _builder_1.append(SMCodeGeneratorConstants.STATE_MAX, "");
        _builder_1.append("]");
        _stereotypeApplication_1.setDefinition(_builder_1.toString());
        Type _pthreadCond = this.ptTypes.getPthreadCond();
        Property conds = this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.CONDITIONS, _pthreadCond);
        StereotypeUtil.apply((Element)conds, Array.class);
        Array _stereotypeApplication_2 = (Array)UMLUtil.getStereotypeApplication((Element)conds, Array.class);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("[");
        _builder_2.append(SMCodeGeneratorConstants.STATE_MAX, "");
        _builder_2.append("]");
        _stereotypeApplication_2.setDefinition(_builder_2.toString());
        Type _pthreadMutex = this.ptTypes.getPthreadMutex();
        Property mutexes = this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.MUTEXES, _pthreadMutex);
        StereotypeUtil.apply((Element)mutexes, Array.class);
        Array _stereotypeApplication_3 = (Array)UMLUtil.getStereotypeApplication((Element)mutexes, Array.class);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("[");
        _builder_3.append(SMCodeGeneratorConstants.STATE_MAX, "");
        _builder_3.append("]");
        _stereotypeApplication_3.setDefinition(_builder_3.toString());
        this.threadStructType = _threadStructType = this.core.getThreadStructType();
        Property threadStructs = this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.THREAD_STRUCTS, this.threadStructType);
        StereotypeUtil.apply((Element)threadStructs, Array.class);
        Array _stereotypeApplication_4 = (Array)UMLUtil.getStereotypeApplication((Element)threadStructs, Array.class);
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append("[");
        _builder_4.append(SMCodeGeneratorConstants.STATE_MAX, "");
        _builder_4.append("]");
        _stereotypeApplication_4.setDefinition(_builder_4.toString());
        Operation threadFuncWrapper = this.superContext.createOwnedOperation(SMCodeGeneratorConstants.THREAD_FUNC_WRAPPER, null, null);
        threadFuncWrapper.setIsStatic(true);
        Parameter inParam = threadFuncWrapper.createOwnedParameter("data", this.core.voidType);
        StereotypeUtil.apply((Element)inParam, Ptr.class);
        Parameter outParam = threadFuncWrapper.createOwnedParameter("ret", this.core.voidType);
        StereotypeUtil.apply((Element)outParam, Ptr.class);
        outParam.setDirection(ParameterDirectionKind.RETURN_LITERAL);
        StringConcatenation _builder_5 = new StringConcatenation();
        _builder_5.append(SMCodeGeneratorConstants.STRUCT_FOR_THREAD, "");
        _builder_5.append("* cptr = (");
        _builder_5.append(SMCodeGeneratorConstants.STRUCT_FOR_THREAD, "");
        _builder_5.append("*)data;");
        _builder_5.newLineIfNotEmpty();
        String _name = this.superContext.getName();
        _builder_5.append(_name, "");
        _builder_5.append("* ptr = (");
        String _name_1 = this.superContext.getName();
        _builder_5.append(_name_1, "");
        _builder_5.append("*) cptr->ptr;");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("switch(cptr->func_type) {");
        _builder_5.newLine();
        int _size = this.core.doActivityList.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder_5.append("\t");
            _builder_5.append("case ");
            _builder_5.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "\t");
            _builder_5.append(":");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("\t");
            _builder_5.append("\t");
            _builder_5.append("ptr->");
            _builder_5.append(SMCodeGeneratorConstants.DO_CALL_ACTIVITY, "\t\t");
            _builder_5.append("(cptr->id);");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("\t");
            _builder_5.append("\t");
            _builder_5.append("break;\t");
            _builder_5.newLine();
        }
        boolean bl2 = _greaterThan_1 = (_size_1 = this.core.timeEvents.size()) > 0;
        if (_greaterThan_1) {
            _builder_5.append("\t");
            _builder_5.append("case ");
            _builder_5.append(SMCodeGeneratorConstants.THREAD_FUNC_TIMEEVENT_TYPE, "\t");
            _builder_5.append(":");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("\t");
            _builder_5.append("\t");
            _builder_5.append("ptr->");
            _builder_5.append(SMCodeGeneratorConstants.TIME_EVENT_LISTEN_FUNCTION, "\t\t");
            _builder_5.append("(");
            String _TE_INDEX = this.cdefs.TE_INDEX();
            _builder_5.append(_TE_INDEX, "\t\t");
            _builder_5.append("(cptr->id), cptr->duration);");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("\t");
            _builder_5.append("\t");
            _builder_5.append("break;");
            _builder_5.newLine();
        }
        boolean bl3 = _greaterThan_2 = (_size_2 = this.core.orthogonalRegions.size()) > 0;
        if (_greaterThan_2) {
            _builder_5.append("\t");
            _builder_5.append("case ");
            _builder_5.append(SMCodeGeneratorConstants.THREAD_FUNC_ENTER_REGION_TYPE, "\t");
            _builder_5.append(":");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("\t");
            _builder_5.append("\t");
            _builder_5.append("ptr->regionCall(cptr->id, cptr->enter_mode);");
            _builder_5.newLine();
            _builder_5.append("\t");
            _builder_5.append("\t");
            _builder_5.append("break;");
            _builder_5.newLine();
            _builder_5.append("\t");
            _builder_5.append("case ");
            _builder_5.append(SMCodeGeneratorConstants.THREAD_FUNC_EXIT_REGION_TYPE, "\t");
            _builder_5.append(":");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("\t");
            _builder_5.append("\t");
            _builder_5.append("ptr->exitRegionCall(cptr->id);");
            _builder_5.newLine();
            _builder_5.append("\t");
            _builder_5.append("\t");
            _builder_5.append("break;");
            _builder_5.newLine();
        }
        boolean bl4 = _greaterThan_3 = (_size_3 = this.core.parallelTransitions.size()) > 0;
        if (_greaterThan_3) {
            _builder_5.append("\t");
            _builder_5.append("case ");
            _builder_5.append(SMCodeGeneratorConstants.THREAD_FUNC_TRANSITION_TYPE, "\t");
            _builder_5.append(":");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("\t");
            _builder_5.append("\t");
            _builder_5.append("ptr->transitionCall(cptr->id);");
            _builder_5.newLine();
            _builder_5.append("\t");
            _builder_5.append("\t");
            _builder_5.append("break;");
            _builder_5.newLine();
        }
        boolean bl5 = _greaterThan_4 = (_size_4 = this.core.changeEvents.size()) > 0;
        if (_greaterThan_4) {
            _builder_5.append("\t");
            _builder_5.append("case ");
            _builder_5.append(SMCodeGeneratorConstants.THREAD_FUNC_CHANGEEVENT_TYPE, "\t");
            _builder_5.append(":");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("\t");
            _builder_5.append("\t");
            _builder_5.append("ptr->");
            _builder_5.append(SMCodeGeneratorConstants.CHANGE_EVENT_LISTEN_FUNCTION, "\t\t");
            _builder_5.append("(cptr->id);");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("\t");
            _builder_5.append("\t");
            _builder_5.append("break;");
            _builder_5.newLine();
        }
        _builder_5.append("\t\t");
        _builder_5.append("case ");
        _builder_5.append(SMCodeGeneratorConstants.THREAD_FUNC_STATE_MACHINE_TYPE, "\t\t");
        _builder_5.append(":");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("\t\t\t");
        _builder_5.append("ptr->");
        _builder_5.append(SMCodeGeneratorConstants.EVENT_DISPATCH, "\t\t\t");
        _builder_5.append("();");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("\t\t\t");
        _builder_5.append("break;");
        _builder_5.newLine();
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("return NULL;");
        this.core.createOpaqueBehavior(this.superContext, threadFuncWrapper, _builder_5.toString());
        Classifier _createNestedClassifier = this.superContext.createNestedClassifier(SMCodeGeneratorConstants.FPT_POINTER_FOR_TABLE, UMLPackage.Literals.PRIMITIVE_TYPE);
        this.core.fptr = _createNestedClassifier;
        StereotypeUtil.apply((Element)this.core.fptr, Typedef.class);
        Typedef _stereotypeApplication_5 = (Typedef)UMLUtil.getStereotypeApplication((Element)this.core.fptr, Typedef.class);
        StringConcatenation _builder_6 = new StringConcatenation();
        _builder_6.append("void (");
        String _name_2 = this.superContext.getName();
        _builder_6.append(_name_2, "");
        _builder_6.append("::*typeName)()");
        _stereotypeApplication_5.setDefinition(_builder_6.toString());
        Property doActivityTable = this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.DO_ACTIVITY_TABLE, this.core.fptr);
        StereotypeUtil.apply((Element)doActivityTable, Array.class);
        Array _stereotypeApplication_6 = (Array)UMLUtil.getStereotypeApplication((Element)doActivityTable, Array.class);
        StringConcatenation _builder_7 = new StringConcatenation();
        _builder_7.append("[");
        _builder_7.append(SMCodeGeneratorConstants.STATE_MAX, "");
        _builder_7.append("]");
        _stereotypeApplication_6.setDefinition(_builder_7.toString());
        Operation doCallActivity = this.superContext.createOwnedOperation(SMCodeGeneratorConstants.DO_CALL_ACTIVITY, null, null);
        doCallActivity.createOwnedParameter("id", this.core.intType);
        StringConcatenation _builder_8 = new StringConcatenation();
        _builder_8.append(SMCodeGeneratorConstants.FLAGS_ACTIVITY, "");
        _builder_8.append("[id] = false;");
        _builder_8.newLineIfNotEmpty();
        _builder_8.append("while(true) {");
        _builder_8.newLine();
        _builder_8.append("\t");
        _builder_8.append("pthread_mutex_lock(&");
        _builder_8.append(SMCodeGeneratorConstants.MUTEXES, "\t");
        _builder_8.append("[id]);");
        _builder_8.newLineIfNotEmpty();
        _builder_8.append("\t");
        _builder_8.append("while(!flags[id]) {");
        _builder_8.newLine();
        _builder_8.append("\t\t");
        _builder_8.append("pthread_cond_wait(&");
        _builder_8.append(SMCodeGeneratorConstants.CONDITIONS, "\t\t");
        _builder_8.append("[id], &");
        _builder_8.append(SMCodeGeneratorConstants.MUTEXES, "\t\t");
        _builder_8.append("[id]);");
        _builder_8.newLineIfNotEmpty();
        _builder_8.append("\t");
        _builder_8.append("}");
        _builder_8.newLine();
        _builder_8.append("\t");
        _builder_8.append("(this->*");
        _builder_8.append(SMCodeGeneratorConstants.DO_ACTIVITY_TABLE, "\t");
        _builder_8.append("[id])();");
        _builder_8.newLineIfNotEmpty();
        _builder_8.append("\t");
        _builder_8.append("bool commitEvent = false;");
        _builder_8.newLine();
        _builder_8.append("\t");
        _builder_8.append("if (flags[id]) {");
        _builder_8.newLine();
        _builder_8.append("\t\t");
        _builder_8.append("commitEvent = true;");
        _builder_8.newLine();
        _builder_8.append("\t\t");
        _builder_8.append("flags[id] = false;");
        _builder_8.newLine();
        _builder_8.append("\t");
        _builder_8.append("}");
        _builder_8.newLine();
        _builder_8.append("\t");
        _builder_8.append("pthread_cond_signal(&");
        _builder_8.append(SMCodeGeneratorConstants.CONDITIONS, "\t");
        _builder_8.append("[id]);");
        _builder_8.newLineIfNotEmpty();
        _builder_8.append("\t");
        _builder_8.append("pthread_mutex_unlock(&");
        _builder_8.append(SMCodeGeneratorConstants.MUTEXES, "\t");
        _builder_8.append("[id]);");
        _builder_8.newLineIfNotEmpty();
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                boolean _hasTriggerlessTransition;
                boolean _and = false;
                boolean _isComposite = it.isComposite();
                boolean _not = !_isComposite;
                _and = !_not ? false : (_hasTriggerlessTransition = TransformationUtil.hasTriggerlessTransition(it));
                return _and;
            }
        };
        Iterable _filter = IterableExtensions.filter(this.core.states, (Functions.Function1)_function);
        int _size_5 = IterableExtensions.size((Iterable)_filter);
        boolean bl6 = _greaterThan_5 = _size_5 > 0;
        if (_greaterThan_5) {
            _builder_8.append("\t");
            _builder_8.append("if (commitEvent) {");
            _builder_8.newLine();
            _builder_8.append("\t");
            _builder_8.append("\t");
            _builder_8.append("if(");
            Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

                public Boolean apply(State it) {
                    boolean _hasTriggerlessTransition;
                    boolean _and = false;
                    boolean _isComposite = it.isComposite();
                    boolean _not = !_isComposite;
                    _and = !_not ? false : (_hasTriggerlessTransition = TransformationUtil.hasTriggerlessTransition(it));
                    return _and;
                }
            };
            Iterable _filter_1 = IterableExtensions.filter(this.core.states, (Functions.Function1)_function_1);
            boolean _hasElements = false;
            for (State s : _filter_1) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder_8.appendImmediate((Object)" || ", "\t\t");
                }
                _builder_8.append("id == ");
                String _name_3 = s.getName();
                String _upperCase = _name_3.toUpperCase();
                _builder_8.append(_upperCase, "\t\t");
                _builder_8.append("_ID");
            }
            _builder_8.append(") {");
            _builder_8.newLineIfNotEmpty();
            _builder_8.append("\t");
            _builder_8.append("\t\t");
            _builder_8.append("//processCompletionEvent();");
            _builder_8.newLine();
            _builder_8.append("\t");
            _builder_8.append("\t\t");
            _builder_8.append(SMCodeGeneratorConstants.EVENT_QUEUE, "\t\t\t");
            _builder_8.append(".push(statemachine::PRIORITY_1, NULL, COMPLETIONEVENT_ID, statemachine::COMPLETION_EVENT, id);");
            _builder_8.newLineIfNotEmpty();
            _builder_8.append("\t");
            _builder_8.append("\t");
            _builder_8.append("}");
            _builder_8.newLine();
            _builder_8.append("\t");
            _builder_8.append("}");
            _builder_8.newLine();
        }
        _builder_8.append("}");
        this.core.createOpaqueBehavior(this.superContext, doCallActivity, _builder_8.toString());
        Operation setFlag = this.superContext.createOwnedOperation(SMCodeGeneratorConstants.SET_FLAG, null, null);
        setFlag.createOwnedParameter("id", this.core.intType);
        setFlag.createOwnedParameter("func_type", this.core.charType);
        setFlag.createOwnedParameter("value", this.core.boolType);
        StringConcatenation _builder_9 = new StringConcatenation();
        _builder_9.append("//value = true => start activity");
        _builder_9.newLine();
        _builder_9.append("//value = false => stop activity");
        _builder_9.newLine();
        int _size_6 = this.core.timeEvents.size();
        boolean bl7 = _greaterThan_6 = _size_6 > 0;
        if (_greaterThan_6) {
            _builder_9.append("if (func_type == ");
            _builder_9.append(SMCodeGeneratorConstants.THREAD_FUNC_TIMEEVENT_TYPE, "");
            _builder_9.append(") {");
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("\t");
            _builder_9.append("pthread_mutex_lock(&");
            _builder_9.append(SMCodeGeneratorConstants.MUTEXES_TIME_EVENT, "\t");
            _builder_9.append("[");
            String _TE_INDEX_1 = this.cdefs.TE_INDEX();
            _builder_9.append(_TE_INDEX_1, "\t");
            _builder_9.append("(id)]);");
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("\t");
            _builder_9.append(SMCodeGeneratorConstants.FLAGS_TIME_EVENT, "\t");
            _builder_9.append("[");
            String _TE_INDEX_2 = this.cdefs.TE_INDEX();
            _builder_9.append(_TE_INDEX_2, "\t");
            _builder_9.append("(id)] = value;");
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("\t");
            _builder_9.append("pthread_cond_signal(&");
            _builder_9.append(SMCodeGeneratorConstants.CONDITIONS_TIME_EVENT, "\t");
            _builder_9.append("[");
            String _TE_INDEX_3 = this.cdefs.TE_INDEX();
            _builder_9.append(_TE_INDEX_3, "\t");
            _builder_9.append("(id)]);");
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("\t");
            _builder_9.append("pthread_mutex_unlock(&");
            _builder_9.append(SMCodeGeneratorConstants.MUTEXES_TIME_EVENT, "\t");
            _builder_9.append("[");
            String _TE_INDEX_4 = this.cdefs.TE_INDEX();
            _builder_9.append(_TE_INDEX_4, "\t");
            _builder_9.append("(id)]);");
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("\t");
            _builder_9.append("return;");
            _builder_9.newLine();
            _builder_9.append("}");
            _builder_9.newLine();
        }
        _builder_9.append("if (func_type == ");
        _builder_9.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "");
        _builder_9.append(") {");
        _builder_9.newLineIfNotEmpty();
        int _size_7 = this.core.doActivityList.size();
        boolean bl8 = _greaterThan_7 = _size_7 > 0;
        if (_greaterThan_7) {
            boolean _greaterThan_8;
            _builder_9.append("\t");
            _builder_9.append("if (");
            _builder_9.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
            _builder_9.append("[id].doActivity != &");
            String _name_4 = this.superContext.getName();
            _builder_9.append(_name_4, "\t");
            _builder_9.append("::doActivity_dft) {");
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("\t");
            _builder_9.append("\t");
            _builder_9.append("//state has doActivity => if value = true => should");
            _builder_9.newLine();
            _builder_9.append("\t");
            _builder_9.append("\t");
            _builder_9.append("pthread_mutex_lock(&");
            _builder_9.append(SMCodeGeneratorConstants.MUTEXES, "\t\t");
            _builder_9.append("[id]);");
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("\t");
            _builder_9.append("\t");
            _builder_9.append("if (value) {");
            _builder_9.newLine();
            _builder_9.append("\t");
            _builder_9.append("\t\t");
            _builder_9.append(SMCodeGeneratorConstants.FLAGS_ACTIVITY, "\t\t\t");
            _builder_9.append("[id] = true;");
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("\t");
            _builder_9.append("\t");
            _builder_9.append("} else {");
            _builder_9.newLine();
            _builder_9.append("\t");
            _builder_9.append("\t\t");
            _builder_9.append("//wait until doActivity exit");
            _builder_9.newLine();
            _builder_9.append("\t");
            _builder_9.append("\t\t");
            _builder_9.append("while(");
            _builder_9.append(SMCodeGeneratorConstants.FLAGS_ACTIVITY, "\t\t\t");
            _builder_9.append("[id]) {");
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("\t");
            _builder_9.append("\t\t\t");
            _builder_9.append("pthread_cond_wait(&");
            _builder_9.append(SMCodeGeneratorConstants.CONDITIONS, "\t\t\t\t");
            _builder_9.append("[id], &");
            _builder_9.append(SMCodeGeneratorConstants.MUTEXES, "\t\t\t\t");
            _builder_9.append("[id]);");
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("\t");
            _builder_9.append("\t\t");
            _builder_9.append("}");
            _builder_9.newLine();
            _builder_9.append("\t");
            _builder_9.append("\t");
            _builder_9.append("}");
            _builder_9.newLine();
            _builder_9.append("\t");
            _builder_9.append("\t");
            _builder_9.append("pthread_cond_signal(&");
            _builder_9.append(SMCodeGeneratorConstants.CONDITIONS, "\t\t");
            _builder_9.append("[id]);");
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("\t");
            _builder_9.append("\t");
            _builder_9.append("pthread_mutex_unlock(&");
            _builder_9.append(SMCodeGeneratorConstants.MUTEXES, "\t\t");
            _builder_9.append("[id]);");
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("\t");
            _builder_9.append("} else {");
            _builder_9.newLine();
            Functions.Function1<State, Boolean> _function_2 = new Functions.Function1<State, Boolean>(){

                public Boolean apply(State it) {
                    boolean _hasTriggerlessTransition;
                    boolean _and = false;
                    boolean _isComposite = it.isComposite();
                    boolean _not = !_isComposite;
                    _and = !_not ? false : (_hasTriggerlessTransition = TransformationUtil.hasTriggerlessTransition(it));
                    return _and;
                }
            };
            Iterable _filter_2 = IterableExtensions.filter(this.core.states, (Functions.Function1)_function_2);
            int _size_8 = IterableExtensions.size((Iterable)_filter_2);
            boolean bl9 = _greaterThan_8 = _size_8 > 0;
            if (_greaterThan_8) {
                _builder_9.append("\t");
                _builder_9.append("\t");
                _builder_9.append("//push completion event");
                _builder_9.newLine();
                _builder_9.append("\t");
                _builder_9.append("\t");
                _builder_9.append("if (value) {");
                _builder_9.newLine();
                _builder_9.append("\t");
                _builder_9.append("\t");
                _builder_9.append("\t");
                _builder_9.append("if(");
                Functions.Function1<State, Boolean> _function_3 = new Functions.Function1<State, Boolean>(){

                    public Boolean apply(State it) {
                        boolean _hasTriggerlessTransition;
                        boolean _and = false;
                        boolean _isComposite = it.isComposite();
                        boolean _not = !_isComposite;
                        _and = !_not ? false : (_hasTriggerlessTransition = TransformationUtil.hasTriggerlessTransition(it));
                        return _and;
                    }
                };
                Iterable _filter_3 = IterableExtensions.filter(this.core.states, (Functions.Function1)_function_3);
                boolean _hasElements_1 = false;
                for (State s_1 : _filter_3) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder_9.appendImmediate((Object)" || ", "\t\t\t");
                    }
                    _builder_9.append("id == ");
                    String _name_5 = s_1.getName();
                    String _upperCase_1 = _name_5.toUpperCase();
                    _builder_9.append(_upperCase_1, "\t\t\t");
                    _builder_9.append("_ID");
                }
                _builder_9.append(") {");
                _builder_9.newLineIfNotEmpty();
                _builder_9.append("\t");
                _builder_9.append("\t");
                _builder_9.append("\t\t");
                _builder_9.append(SMCodeGeneratorConstants.EVENT_QUEUE, "\t\t\t\t");
                _builder_9.append(".push(statemachine::PRIORITY_1, NULL, COMPLETIONEVENT_ID, statemachine::COMPLETION_EVENT, id);");
                _builder_9.newLineIfNotEmpty();
                _builder_9.append("\t");
                _builder_9.append("\t");
                _builder_9.append("\t");
                _builder_9.append("}");
                _builder_9.newLine();
                _builder_9.append("\t");
                _builder_9.append("\t");
                _builder_9.append("}");
                _builder_9.newLine();
            }
            _builder_9.append("\t");
            _builder_9.append("}");
            _builder_9.newLine();
            _builder_9.append("\t");
            _builder_9.append("return;");
            _builder_9.newLine();
        } else {
            boolean _greaterThan_9;
            Functions.Function1<State, Boolean> _function_4 = new Functions.Function1<State, Boolean>(){

                public Boolean apply(State it) {
                    boolean _hasTriggerlessTransition;
                    boolean _and = false;
                    boolean _isComposite = it.isComposite();
                    boolean _not = !_isComposite;
                    _and = !_not ? false : (_hasTriggerlessTransition = TransformationUtil.hasTriggerlessTransition(it));
                    return _and;
                }
            };
            Iterable _filter_4 = IterableExtensions.filter(this.core.states, (Functions.Function1)_function_4);
            int _size_9 = IterableExtensions.size((Iterable)_filter_4);
            boolean bl10 = _greaterThan_9 = _size_9 > 0;
            if (_greaterThan_9) {
                _builder_9.append("\t");
                _builder_9.append("//push completion event");
                _builder_9.newLine();
                _builder_9.append("\t");
                _builder_9.append("\t");
                _builder_9.append("if (value) {");
                _builder_9.newLine();
                _builder_9.append("\t");
                _builder_9.append("\t\t");
                _builder_9.append("if(");
                Functions.Function1<State, Boolean> _function_5 = new Functions.Function1<State, Boolean>(){

                    public Boolean apply(State it) {
                        boolean _hasTriggerlessTransition;
                        boolean _and = false;
                        boolean _isComposite = it.isComposite();
                        boolean _not = !_isComposite;
                        _and = !_not ? false : (_hasTriggerlessTransition = TransformationUtil.hasTriggerlessTransition(it));
                        return _and;
                    }
                };
                Iterable _filter_5 = IterableExtensions.filter(this.core.states, (Functions.Function1)_function_5);
                boolean _hasElements_2 = false;
                for (State s_2 : _filter_5) {
                    if (!_hasElements_2) {
                        _hasElements_2 = true;
                    } else {
                        _builder_9.appendImmediate((Object)" || ", "\t\t\t");
                    }
                    _builder_9.append("id == ");
                    String _name_6 = s_2.getName();
                    String _upperCase_2 = _name_6.toUpperCase();
                    _builder_9.append(_upperCase_2, "\t\t\t");
                    _builder_9.append("_ID");
                }
                _builder_9.append(") {");
                _builder_9.newLineIfNotEmpty();
                _builder_9.append("\t");
                _builder_9.append("\t\t\t");
                _builder_9.append(SMCodeGeneratorConstants.EVENT_QUEUE, "\t\t\t\t");
                _builder_9.append(".push(statemachine::PRIORITY_1, NULL, COMPLETIONEVENT_ID, statemachine::COMPLETION_EVENT, id);");
                _builder_9.newLineIfNotEmpty();
                _builder_9.append("\t");
                _builder_9.append("\t\t");
                _builder_9.append("}");
                _builder_9.newLine();
                _builder_9.append("\t");
                _builder_9.append("\t\t");
                _builder_9.append("return;");
                _builder_9.newLine();
                _builder_9.append("\t");
                _builder_9.append("\t");
                _builder_9.append("} ");
                _builder_9.newLine();
            }
        }
        _builder_9.append("}");
        _builder_9.newLine();
        this.core.createOpaqueBehavior(this.superContext, setFlag, _builder_9.toString());
        TimeEventTransformation _timeEventTransformation = new TimeEventTransformation(this.core);
        _timeEventTransformation.createTimeEvents();
        this.createRegionParallel();
    }

    public void createRegionParallel() {
        boolean _isEmpty = this.core.orthogonalRegions.isEmpty();
        if (_isEmpty) {
            return;
        }
        Classifier regionFptr = this.superContext.createNestedClassifier(SMCodeGeneratorConstants.REGION_FUNCTION_PTR, UMLPackage.Literals.PRIMITIVE_TYPE);
        StereotypeUtil.apply((Element)regionFptr, Typedef.class);
        Typedef _stereotypeApplication = (Typedef)UMLUtil.getStereotypeApplication((Element)regionFptr, Typedef.class);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void (");
        String _name = this.superContext.getName();
        _builder.append(_name, "");
        _builder.append("::*typeName)(char enter_mode)");
        _stereotypeApplication.setDefinition(_builder.toString());
        Property regionTable = this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.REGION_TABLE, (Type)regionFptr);
        StereotypeUtil.apply((Element)regionTable, Array.class);
        Array _stereotypeApplication_1 = (Array)UMLUtil.getStereotypeApplication((Element)regionTable, Array.class);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("[");
        int _size = this.core.orthogonalRegions.size();
        _builder_1.append((Object)_size, "");
        _builder_1.append("]");
        _stereotypeApplication_1.setDefinition(_builder_1.toString());
        Operation regionCallOp = this.superContext.createOwnedOperation("regionCall", null, null);
        regionCallOp.createOwnedParameter("id", this.core.intType);
        regionCallOp.createOwnedParameter("enter_mode", this.core.charType);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("(this->*");
        _builder_2.append(SMCodeGeneratorConstants.REGION_TABLE, "");
        _builder_2.append("[id])(enter_mode);");
        this.core.createOpaqueBehavior(this.superContext, regionCallOp, _builder_2.toString());
        Property regionExitTable = this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.REGION_TABLE_EXIT, this.core.fptr);
        StereotypeUtil.apply((Element)regionExitTable, Array.class);
        Array _stereotypeApplication_2 = (Array)UMLUtil.getStereotypeApplication((Element)regionExitTable, Array.class);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("[");
        int _size_1 = this.core.orthogonalRegions.size();
        _builder_3.append((Object)_size_1, "");
        _builder_3.append("]");
        _stereotypeApplication_2.setDefinition(_builder_3.toString());
        Operation regionCallExitOp = this.superContext.createOwnedOperation("exitRegionCall", null, null);
        regionCallExitOp.createOwnedParameter("id", this.core.charType);
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append("(this->*");
        _builder_4.append(SMCodeGeneratorConstants.REGION_TABLE_EXIT, "");
        _builder_4.append("[id])();");
        this.core.createOpaqueBehavior(this.superContext, regionCallExitOp, _builder_4.toString());
    }

    public void createConcurrencyForTransitions() {
        boolean _isEmpty = this.core.parallelTransitions.isEmpty();
        if (_isEmpty) {
            return;
        }
        int i = 0;
        while (i < this.core.parallelTransitions.size()) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("#define ");
            Transition _get = this.core.parallelTransitions.get(i);
            String _parallelTransitionId = this.parallelTransitionId(_get);
            _builder.append(_parallelTransitionId, "");
            _builder.append(" (");
            _builder.append((Object)i, "");
            _builder.append(")");
            this.core.appendIncludeHeader(_builder.toString());
            Transition _get_1 = this.core.parallelTransitions.get(i);
            String _parallelTransitionMethodName = this.parallelTransitionMethodName(_get_1);
            Operation op = this.superContext.createOwnedOperation(_parallelTransitionMethodName, null, null);
            StringConcatenation _builder_1 = new StringConcatenation();
            Transition _get_2 = this.core.parallelTransitions.get(i);
            String _transitionEffect = TransformationUtil.getTransitionEffect(_get_2);
            _builder_1.append(_transitionEffect, "");
            this.core.createOpaqueBehavior(this.superContext, op, _builder_1.toString());
            ++i;
        }
        Property transitionTable = this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.PARALLEL_TRANSITION_TABLE, this.core.fptr);
        StereotypeUtil.apply((Element)transitionTable, Array.class);
        Array _stereotypeApplication = (Array)UMLUtil.getStereotypeApplication((Element)transitionTable, Array.class);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("[");
        int _size = this.core.parallelTransitions.size();
        _builder.append((Object)_size, "");
        _builder.append("]");
        _stereotypeApplication.setDefinition(_builder.toString());
        Operation transitionCallOp = this.superContext.createOwnedOperation("transitionCall", null, null);
        transitionCallOp.createOwnedParameter("id", this.core.intType);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("(this->*");
        _builder_1.append(SMCodeGeneratorConstants.PARALLEL_TRANSITION_TABLE, "");
        _builder_1.append("[id])();");
        this.core.createOpaqueBehavior(this.superContext, transitionCallOp, _builder_1.toString());
    }

    public String parallelTransitionMethodName(Transition t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("paralleTransition");
        int _indexOf = this.core.parallelTransitions.indexOf(t);
        _builder.append((Object)_indexOf, "");
        return _builder.toString();
    }

    public String parallelTransitionId(Transition t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("PARALLEL_TRANSITION_ID_");
        int _indexOf = this.core.parallelTransitions.indexOf(t);
        _builder.append((Object)_indexOf, "");
        return _builder.toString();
    }

    public String generateForkCall(Region r, boolean isEnter, String enteringMode) {
        StringConcatenation _builder = new StringConcatenation();
        State _state = r.getState();
        String _name = _state.getName();
        _builder.append(_name, "");
        _builder.append("_");
        String _name_1 = r.getName();
        _builder.append(_name_1, "");
        _builder.append("_enter_thread");
        String paramThreadName = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        State _state_1 = r.getState();
        String _name_2 = _state_1.getName();
        _builder_1.append(_name_2, "");
        _builder_1.append("_");
        String _name_3 = r.getName();
        _builder_1.append(_name_3, "");
        _builder_1.append("_enter_thread_struct");
        String threadStructParam = _builder_1.toString();
        if (!isEnter) {
            StringConcatenation _builder_2 = new StringConcatenation();
            State _state_2 = r.getState();
            String _name_4 = _state_2.getName();
            _builder_2.append(_name_4, "");
            _builder_2.append("_");
            String _name_5 = r.getName();
            _builder_2.append(_name_5, "");
            _builder_2.append("_exit_thread");
            paramThreadName = _builder_2.toString();
            StringConcatenation _builder_3 = new StringConcatenation();
            State _state_3 = r.getState();
            String _name_6 = _state_3.getName();
            _builder_3.append(_name_6, "");
            _builder_3.append("_");
            String _name_7 = r.getName();
            _builder_3.append(_name_7, "");
            _builder_3.append("_exit_thread_struct");
            threadStructParam = _builder_3.toString();
        }
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append("pthread_t ");
        _builder_4.append(paramThreadName, "");
        _builder_4.append(";");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append(SMCodeGeneratorConstants.STRUCT_FOR_THREAD, "");
        _builder_4.append(" ");
        _builder_4.append(threadStructParam, "");
        _builder_4.append("(this, ");
        String _regionMacroId = this.core.getRegionMacroId(r);
        _builder_4.append(_regionMacroId, "");
        _builder_4.append(", ");
        _builder_4.append(enteringMode, "");
        _builder_4.append(", ");
        if (isEnter) {
            _builder_4.append(SMCodeGeneratorConstants.THREAD_FUNC_ENTER_REGION_TYPE, "");
        } else {
            _builder_4.append(SMCodeGeneratorConstants.THREAD_FUNC_EXIT_REGION_TYPE, "");
        }
        _builder_4.append(", 0);");
        _builder_4.newLineIfNotEmpty();
        String _name_8 = this.superContext.getName();
        _builder_4.append(_name_8, "");
        _builder_4.append("_THREAD_CREATE(");
        _builder_4.append(paramThreadName, "");
        _builder_4.append(", ");
        _builder_4.append(threadStructParam, "");
        _builder_4.append(")");
        String ret = _builder_4.toString();
        return ret;
    }

    public String generateJoinCall(Region r, boolean isEnter) {
        StringConcatenation _builder = new StringConcatenation();
        State _state = r.getState();
        String _name = _state.getName();
        _builder.append(_name, "");
        _builder.append("_");
        String _name_1 = r.getName();
        _builder.append(_name_1, "");
        _builder.append("_enter_thread");
        String paramThreadName = _builder.toString();
        if (!isEnter) {
            StringConcatenation _builder_1 = new StringConcatenation();
            State _state_1 = r.getState();
            String _name_2 = _state_1.getName();
            _builder_1.append(_name_2, "");
            _builder_1.append("_");
            String _name_3 = r.getName();
            _builder_1.append(_name_3, "");
            _builder_1.append("_exit_thread");
            paramThreadName = _builder_1.toString();
        }
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append(SMCodeGeneratorConstants.JOIN_NAME, "");
        _builder_2.append("(");
        _builder_2.append(paramThreadName, "");
        _builder_2.append(", NULL);");
        return _builder_2.toString();
    }
}

