/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.oclany;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractUnaryOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.SetValue;

public class OclElementOclModelTypesOperation
extends AbstractUnaryOperation {
    public static final @NonNull OclElementOclModelTypesOperation INSTANCE = new OclElementOclModelTypesOperation();

    @Override
    public @NonNull SetValue evaluate(@NonNull Executor executor, @NonNull TypeId returnTypeId, @Nullable Object sourceVal) {
        if (sourceVal instanceof InvalidValueException) {
            throw (InvalidValueException)sourceVal;
        }
        IdResolver.IdResolverExtension idResolver = (IdResolver.IdResolverExtension)executor.getIdResolver();
        Type sourceType = idResolver.getDynamicTypeOf(sourceVal);
        if (sourceVal == null) {
            throw new InvalidValueException(PivotMessages.NullNavigation, "source value", "oclModelTypes");
        }
        Iterable<@NonNull Class> modelClasses = idResolver.getModelClassesOf(sourceVal);
        if (modelClasses == null) {
            throw new InvalidValueException(PivotMessages.IncompatibleModelType, sourceType);
        }
        return idResolver.createSetOfAll((CollectionTypeId)returnTypeId, modelClasses);
    }

    @Override
    public @Nullable Type resolveReturnType(@NonNull EnvironmentFactory environmentFactory, @NonNull CallExp callExp, @Nullable Type returnType) {
        return environmentFactory.getStandardLibrary().getSetType();
    }
}

