/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.scoping;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Enumeration;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.Feature;
import org.eclipse.ocl.pivot.Library;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Precedence;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.State;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.internal.PrimitiveCompletePackageImpl;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.complete.CompleteInheritanceImpl;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.CompletePackageInternal;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.scoping.Attribution;
import org.eclipse.ocl.pivot.internal.scoping.NullAttribution;
import org.eclipse.ocl.pivot.internal.scoping.PivotScopeView;
import org.eclipse.ocl.pivot.internal.scoping.ScopeFilter;
import org.eclipse.ocl.pivot.internal.scoping.ScopeView;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.IllegalLibraryException;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.FeatureFilter;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.ParserContext;
import org.eclipse.ocl.pivot.utilities.PivotUtil;

public class EnvironmentView {
    private static final Logger logger = Logger.getLogger(EnvironmentView.class);
    private static @NonNull LinkedHashMap<@NonNull java.lang.Class<?>, @NonNull List<@NonNull Comparator<@NonNull Object>>> disambiguatorMap = new LinkedHashMap();
    private final @Nullable ParserContext parserContext;
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    protected final @NonNull EStructuralFeature reference;
    private EClassifier requiredType;
    private boolean isQualified = false;
    private boolean isQualifier = false;
    protected final @Nullable String name;
    private final @NonNull Map<@NonNull String, Object> contentsByName = new HashMap<String, Object>();
    private int contentsSize = 0;
    private List<@NonNull ScopeFilter> matchers = null;

    static {
        EnvironmentView.addDisambiguator(Object.class, new ImplicitDisambiguator());
        EnvironmentView.addDisambiguator(Feature.class, new MetamodelMergeDisambiguator());
        EnvironmentView.addDisambiguator(Operation.class, new OperationDisambiguator());
        EnvironmentView.addDisambiguator(Package.class, new MergedPackageDisambiguator());
        EnvironmentView.addDisambiguator(Property.class, new PropertyDisambiguator());
    }

    public static synchronized <T> void addDisambiguator(java.lang.Class<T> targetClass, @NonNull Comparator<T> disambiguator) {
        assert (targetClass != null);
        List<@NonNull Comparator<@NonNull Object>> disambiguators = disambiguatorMap.get(targetClass);
        if (disambiguators == null) {
            disambiguators = new ArrayList<Comparator<Object>>();
            disambiguatorMap.put(targetClass, disambiguators);
        }
        Comparator<@NonNull T> castDisambiguator = disambiguator;
        disambiguators.add(castDisambiguator);
    }

    public static @NonNull Iterable<@NonNull java.lang.Class<?>> getDisambiguatorKeys() {
        return disambiguatorMap.keySet();
    }

    public static @Nullable List<@NonNull Comparator<@NonNull Object>> getDisambiguators(@NonNull java.lang.Class<?> key) {
        return disambiguatorMap.get(key);
    }

    public EnvironmentView(@NonNull ParserContext parserContext, @NonNull EStructuralFeature reference, @Nullable String name) {
        this.parserContext = parserContext;
        this.environmentFactory = (EnvironmentFactoryInternal)parserContext.getEnvironmentFactory();
        this.reference = reference;
        this.requiredType = reference.getEType();
        this.name = name;
    }

    @Deprecated
    public EnvironmentView(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull EStructuralFeature reference, @Nullable String name) {
        this.parserContext = null;
        this.environmentFactory = environmentFactory;
        this.reference = reference;
        this.requiredType = reference.getEType();
        this.name = name;
    }

    public boolean accepts(EClass eClass) {
        assert (eClass != null);
        return this.name == null || PivotUtil.conformsTo(this.requiredType, (EClassifier)eClass) || this.requiredType != null && PivotUtil.conformsTo((EClassifier)eClass, this.requiredType);
    }

    public void addAllElements(@NonNull Class asClass, @NonNull ScopeView scopeView) {
        Attribution attribution = this.getAttribution(asClass);
        attribution.computeLookup(asClass, this, scopeView);
        Class asUnspecializedClass = PivotUtil.getUnspecializedTemplateableElement(asClass);
        Package asPackage = asUnspecializedClass.getOwningPackage();
        if (asPackage != null) {
            attribution = this.getAttribution(asPackage);
            attribution.computeLookup(asPackage, this, scopeView);
        }
        if ((asPackage = asUnspecializedClass.getOwningPackage()) != null) {
            attribution = this.getAttribution(asPackage);
            attribution.computeLookup(asPackage, this, scopeView);
        }
    }

    public void addAllEnumerationLiterals(Enumeration pivot) {
        block4: {
            if (!this.accepts(PivotPackage.Literals.ENUMERATION_LITERAL)) break block4;
            String name2 = this.name;
            if (name2 != null) {
                for (EnumerationLiteral literal : pivot.getOwnedLiterals()) {
                    if (literal == null || !name2.equals(literal.getName())) continue;
                    this.addElement(name2, literal);
                }
            } else {
                for (EnumerationLiteral literal : pivot.getOwnedLiterals()) {
                    if (literal == null) continue;
                    this.addNamedElement(literal);
                }
            }
        }
    }

    public void addAllOperations(@NonNull Class type, @Nullable FeatureFilter featureFilter) {
        block5: {
            if (!this.accepts(PivotPackage.Literals.ITERATION) || this.requiredType == PivotPackage.Literals.NAMESPACE) break block5;
            assert (this.environmentFactory.getMetamodelManager().isTypeServeable(type));
            type = PivotUtil.getUnspecializedTemplateableElement(type);
            CompleteClassInternal completeClass = this.environmentFactory.getMetamodelManager().getCompleteClass(type);
            String name2 = this.name;
            if (name2 != null) {
                for (Operation operation : completeClass.getOperations(featureFilter, name2)) {
                    this.addElement(name2, operation);
                }
            } else {
                for (Operation operation : completeClass.getOperations(featureFilter)) {
                    this.addNamedElement(operation);
                }
            }
        }
    }

    public void addAllPackages(@NonNull CompletePackage parentCompletePackage) {
        if (this.accepts(PivotPackage.Literals.PACKAGE)) {
            String name2 = this.name;
            if (name2 != null) {
                CompletePackage completePackage = parentCompletePackage.getOwnedCompletePackage(name2);
                if (completePackage != null) {
                    this.addElement(name2, completePackage);
                }
            } else {
                for (CompletePackage completePackage : parentCompletePackage.getOwnedCompletePackages()) {
                    if (completePackage == null) continue;
                    this.addNamedElement(completePackage);
                }
            }
        }
    }

    public void addAllPackages(@NonNull Package pkge) {
        if (this.accepts(PivotPackage.Literals.PACKAGE)) {
            CompletePackage parentCompletePackage = this.environmentFactory.getMetamodelManager().getCompletePackage(pkge);
            String name2 = this.name;
            if (name2 != null) {
                CompletePackage completePackage = parentCompletePackage.getOwnedCompletePackage(name2);
                if (completePackage != null) {
                    this.addElement(name2, completePackage);
                }
            } else {
                for (CompletePackage completePackage : parentCompletePackage.getOwnedCompletePackages()) {
                    if (completePackage == null) continue;
                    this.addNamedElement(completePackage);
                }
            }
        }
    }

    public void addAllPackages(@NonNull Model root) {
        block4: {
            if (!this.accepts(PivotPackage.Literals.PACKAGE)) break block4;
            String name2 = this.name;
            if (name2 != null) {
                for (Package pkge : root.getOwnedPackages()) {
                    if (pkge == null || !name2.equals(pkge.getName())) continue;
                    this.addElement(name2, pkge);
                }
            } else {
                for (Package pkge : root.getOwnedPackages()) {
                    if (pkge == null) continue;
                    this.addNamedElement(this.environmentFactory.getMetamodelManager().getPrimaryPackage(pkge));
                }
            }
        }
    }

    public void addAllParameters(@NonNull Operation pivot) {
        block4: {
            if (!this.accepts(PivotPackage.Literals.PARAMETER)) break block4;
            String name2 = this.name;
            if (name2 != null) {
                for (Parameter parameter : pivot.getOwnedParameters()) {
                    if (!name2.equals(parameter.getName())) continue;
                    this.addElement(name2, parameter);
                }
            } else {
                for (Parameter parameter : pivot.getOwnedParameters()) {
                    if (parameter == null) continue;
                    this.addNamedElement(parameter);
                }
            }
        }
    }

    public void addAllPrecedences(@NonNull Library pivot) {
        block4: {
            if (!this.accepts(PivotPackage.Literals.PRECEDENCE)) break block4;
            String name2 = this.name;
            if (name2 != null) {
                for (Precedence precedence : pivot.getOwnedPrecedences()) {
                    if (!name2.equals(precedence.getName())) continue;
                    this.addElement(name2, precedence);
                }
            } else {
                for (Precedence precedence : pivot.getOwnedPrecedences()) {
                    if (precedence == null) continue;
                    this.addNamedElement(precedence);
                }
            }
        }
    }

    public void addAllProperties(@NonNull Class type, @Nullable FeatureFilter featureFilter) {
        block5: {
            if (!this.accepts(PivotPackage.Literals.PROPERTY) || this.requiredType == PivotPackage.Literals.NAMESPACE) break block5;
            assert (this.environmentFactory.getMetamodelManager().isTypeServeable(type));
            CompleteClassInternal completeClass = this.environmentFactory.getMetamodelManager().getCompleteClass(type);
            String name2 = this.name;
            if (name2 != null) {
                for (Property property : completeClass.getProperties(featureFilter, name2)) {
                    this.addNamedElement(property);
                }
            } else {
                for (Property property : completeClass.getProperties(featureFilter)) {
                    this.addNamedElement(property);
                }
            }
        }
    }

    public void addAllStates(@NonNull Type type) {
        block5: {
            if (!this.accepts(PivotPackage.Literals.STATE)) break block5;
            assert (this.environmentFactory.getMetamodelManager().isTypeServeable(type));
            CompleteClassInternal completeClass = this.environmentFactory.getCompleteModel().getCompleteClass(type);
            String name2 = this.name;
            if (name2 != null) {
                for (State state : completeClass.getStates(name2)) {
                    this.addNamedElement(state);
                }
            } else {
                for (State state : completeClass.getStates()) {
                    this.addNamedElement(state);
                }
            }
        }
    }

    public void addAllTemplateParameters(@NonNull TemplateableElement pivot) {
        block4: {
            TemplateSignature templateSignature;
            if (!this.accepts(PivotPackage.Literals.TYPE) || (templateSignature = pivot.getOwnedSignature()) == null) break block4;
            String name2 = this.name;
            List<TemplateParameter> templateParameters = templateSignature.getOwnedParameters();
            if (name2 != null) {
                for (TemplateParameter templateParameter : templateParameters) {
                    if (templateParameter == null || !name2.equals(templateParameter.getName())) continue;
                    this.addElement(name2, templateParameter);
                }
            } else {
                for (TemplateParameter templateParameter : templateParameters) {
                    if (templateParameter == null) continue;
                    this.addNamedElement(templateParameter);
                }
            }
        }
    }

    public void addAllTypes(@NonNull CompletePackage completePackage) {
        block2: {
            block3: {
                Class type;
                String name2;
                block4: {
                    if (!this.accepts(PivotPackage.Literals.CLASS)) break block2;
                    name2 = this.name;
                    if (name2 == null) break block3;
                    type = completePackage.getMemberType(name2);
                    if (type == null) break block4;
                    this.addNamedElement(type);
                    break block2;
                }
                completePackage = this.environmentFactory.getCompleteModel().getPrimitiveCompletePackage();
                type = completePackage.getMemberType(name2);
                if (type == null) break block2;
                this.addNamedElement(type);
                break block2;
            }
            for (CompleteClass completeClass : completePackage.getOwnedCompleteClasses()) {
                this.addNamedElement(completeClass.getPrimaryClass());
            }
            PrimitiveCompletePackageImpl primitiveCompletePackage = this.environmentFactory.getCompleteModel().getPrimitiveCompletePackage();
            for (CompleteClass completeClass : primitiveCompletePackage.getOwnedCompleteClasses()) {
                this.addNamedElement(completeClass.getPrimaryClass());
            }
        }
    }

    public void addAllTypes(@NonNull Package pkge) {
        block2: {
            CompletePackage completePackage;
            block3: {
                Class type;
                String name2;
                block4: {
                    if (!this.accepts(PivotPackage.Literals.CLASS)) break block2;
                    completePackage = this.environmentFactory.getMetamodelManager().getCompletePackage(pkge);
                    name2 = this.name;
                    if (name2 == null) break block3;
                    type = completePackage.getMemberType(name2);
                    if (type == null) break block4;
                    this.addNamedElement(type);
                    break block2;
                }
                completePackage = this.environmentFactory.getCompleteModel().getPrimitiveCompletePackage();
                type = completePackage.getMemberType(name2);
                if (type == null) break block2;
                this.addNamedElement(type);
                break block2;
            }
            for (CompleteClass completeClass : completePackage.getOwnedCompleteClasses()) {
                this.addNamedElement(completeClass.getPrimaryClass());
            }
            PrimitiveCompletePackageImpl primitiveCompletePackage = this.environmentFactory.getCompleteModel().getPrimitiveCompletePackage();
            for (CompleteClass completeClass : primitiveCompletePackage.getOwnedCompleteClasses()) {
                this.addNamedElement(completeClass.getPrimaryClass());
            }
        }
    }

    public void addElement(@Nullable String elementName, @Nullable Object element) {
        if (elementName == null || element == null) {
            return;
        }
        if (element instanceof EObject && !(element instanceof Variable) && ((EObject)element).eResource() == null) {
            EObject eObject = (EObject)element;
            while (true) {
                Object eContainer;
                if ((eContainer = eObject.eContainer()) == null) {
                    if (eObject instanceof CompleteEnvironment || eObject.eResource() != null) break;
                    logger.error((Object)("Orphan '" + element + "'"));
                    return;
                }
                eObject = eContainer;
            }
        }
        if (this.name != null && !this.name.equals(elementName)) {
            assert (!(element instanceof Property) && !(element instanceof Operation));
            return;
        }
        if (element instanceof CompletePackage) {
            element = ((CompletePackage)element).getPrimaryPackage();
        } else if (!(element instanceof Package) && element instanceof EObject) {
            element = this.environmentFactory.getMetamodelManager().getPrimaryElement((EObject)element);
        }
        if (element == null) {
            return;
        }
        if (this.name != null && this.matchers != null) {
            for (ScopeFilter filter : this.matchers) {
                if (filter.matches(this, element)) continue;
                return;
            }
        }
        if (element instanceof CompleteInheritanceImpl) {
            assert (false);
            element = ((CompleteInheritanceImpl)element).getCompleteClass().getPrimaryClass();
        }
        if (this.requiredType != null && this.name != null && !this.requiredType.isInstance(element)) {
            return;
        }
        Object value = this.contentsByName.get(elementName);
        if (value != element) {
            if (value == null) {
                this.contentsByName.put(elementName, element);
                ++this.contentsSize;
            } else {
                MyList values;
                if (value instanceof MyList) {
                    values = (MyList)value;
                } else {
                    values = new MyList();
                    values.add(value);
                    this.contentsByName.put(elementName, values);
                }
                if (!values.contains(element)) {
                    values.add(element);
                    ++this.contentsSize;
                }
            }
        }
    }

    public void addElement(@Nullable String elementName, @Nullable Element element) {
        this.addElement(elementName, (Object)element);
    }

    public void addElements(@NonNull Map<String, ?> elements) {
        String name2 = this.name;
        if (name2 != null) {
            Object element = elements.get(name2);
            if (element != null) {
                this.addElement(name2, element);
            }
        } else {
            for (String key : elements.keySet()) {
                Object element;
                if (key == null || (element = elements.get(key)) == null) continue;
                this.addElement(key, element);
            }
        }
    }

    public void addElements(@Nullable Iterable<? extends Object> elements) {
        if (elements != null) {
            for (Object object : elements) {
                Nameable namedElement;
                String elementName;
                if (!(object instanceof Nameable) || (elementName = (namedElement = (Nameable)object).getName()) == null) continue;
                this.addElement(elementName, namedElement);
            }
        }
    }

    public void addElementsOfScope(@Nullable Element asElement, @NonNull ScopeView scopeView) {
        if (asElement != null) {
            Attribution attribution = this.getAttribution(asElement);
            attribution.computeLookup(asElement, this, scopeView);
        }
    }

    public void addFilter(@NonNull ScopeFilter filter) {
        if (this.matchers == null) {
            this.matchers = new ArrayList<ScopeFilter>();
        }
        this.matchers.add(filter);
    }

    public void addImportedElement(@NonNull URI baseURI) {
        String name;
        if (PivotUtilInternal.isASURI(baseURI)) {
            baseURI = PivotUtilInternal.getNonASURI(baseURI);
        }
        if ((name = this.getName()) != null) {
            @NonNull URI uri = URI.createURI((String)name).resolve(baseURI);
            try {
                Element importedElement = this.environmentFactory.getMetamodelManager().loadResource(uri, null, null);
                if (importedElement != null) {
                    this.addElement(name, importedElement);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addLibContents(@NonNull Class libType, @NonNull ScopeView scopeView) {
        this.addElementsOfScope(libType, scopeView);
        for (Class superClass : libType.getSuperClasses()) {
            if (superClass == null) continue;
            this.addLibContents(superClass, scopeView);
        }
    }

    public void addNamedElement(Nameable namedElement) {
        if (namedElement == null) {
            return;
        }
        String elementName = namedElement.getName();
        if (elementName != null) {
            this.addElement(elementName, namedElement);
        }
    }

    public void addNamedElement(NamedElement namedElement) {
        this.addNamedElement((Nameable)namedElement);
    }

    public void addNamedElements(Iterable<? extends Nameable> namedElements) {
        for (Nameable nameable : namedElements) {
            if (nameable == null) continue;
            this.addNamedElement(nameable);
        }
    }

    public void addRootPackages() {
        CompleteModelInternal completeModel = this.environmentFactory.getCompleteModel();
        String name2 = this.name;
        if (name2 != null) {
            CompletePackageInternal completePackage;
            CompletePackage completePackage2 = completeModel.getOwnedCompletePackage(name2);
            if (completePackage2 != null) {
                this.addNamedElement(completePackage2);
            }
            if ((completePackage = completeModel.getCompletePackageByURI(name2)) != null) {
                this.addElement(name2, completePackage);
            }
        } else {
            for (CompletePackage completePackage : completeModel.getOwnedCompletePackages()) {
                if (completePackage == null) continue;
                this.addNamedElement(completePackage);
            }
            for (CompletePackage completePackage : completeModel.getAllCompletePackagesWithUris()) {
                String nsURI = completePackage.getURI();
                if (nsURI == null) continue;
                this.addElement(nsURI, completePackage);
            }
        }
    }

    public int computeLookups(@NonNull Element target, @Nullable Element child) {
        PivotScopeView pivotScopeView = this.parserContext != null ? new PivotScopeView(this.parserContext, target, child, false) : new PivotScopeView(this.environmentFactory, target, child, false);
        return this.computeLookups(pivotScopeView);
    }

    public int computeLookups(@NonNull ScopeView scopeView) {
        ScopeView aScope = scopeView;
        try {
            while (aScope != null && !this.hasFinalResult()) {
                EObject aTarget = aScope.getTarget();
                if (aTarget != null) {
                    Attribution attribution = aScope.getAttribution();
                    aScope = attribution.computeLookup(aTarget, this, aScope);
                    continue;
                }
                break;
            }
        }
        catch (IllegalLibraryException e) {
            throw e;
        }
        catch (Exception e) {
            EObject target = scopeView.getTarget();
            assert (target != null);
            target.eResource().getErrors().add((Object)new DiagnosticWrappedException("Lookup of '" + this.name + "' failed", e));
        }
        return this.resolveDuplicates();
    }

    public void computeQualifiedLookups(@NonNull Element target) {
        PivotScopeView parentScopeView = this.parserContext != null ? new PivotScopeView(this.parserContext, target, null, true) : new PivotScopeView(this.environmentFactory, target, null, true);
        this.addElementsOfScope(target, parentScopeView);
    }

    public @NonNull Attribution getAttribution(@NonNull EObject eObject) {
        if (this.parserContext != null) {
            return this.parserContext.getAttribution(eObject);
        }
        if (eObject.eIsProxy()) {
            logger.warn((Object)("getAttribution for proxy " + eObject));
            return NullAttribution.INSTANCE;
        }
        EClass eClass = eObject.eClass();
        assert (eClass != null);
        Attribution attribution = Attribution.REGISTRY.get(eClass);
        if (attribution == null) {
            EClass superClass = eClass;
            while (superClass.getESuperTypes().size() > 0) {
                attribution = Attribution.REGISTRY.get(superClass = (EClass)superClass.getESuperTypes().get(0));
                if (attribution != null) break;
            }
            if (attribution == null) {
                attribution = NullAttribution.INSTANCE;
            }
            Attribution.REGISTRY.put((EClassifier)eClass, attribution);
        }
        return attribution;
    }

    public @Nullable EObject getContent() {
        if (this.contentsSize == 0) {
            return null;
        }
        if (this.contentsSize != 1) {
            logger.warn((Object)("Unhandled ambiguous content for '" + this.name + "'"));
        }
        for (Map.Entry<String, Object> entry : this.contentsByName.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof MyList) {
                MyList values = (MyList)value;
                value = values.get(values.size() - 1);
            }
            if (!(value instanceof EObject)) continue;
            return (EObject)value;
        }
        return null;
    }

    public @NonNull Set<Map.Entry<@NonNull String, Object>> getEntries() {
        return this.contentsByName.entrySet();
    }

    public @NonNull EnvironmentFactoryInternal getEnvironmentFactory() {
        return this.environmentFactory;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public @NonNull EStructuralFeature getReference() {
        return this.reference;
    }

    public @Nullable EClassifier getRequiredType() {
        return this.requiredType;
    }

    public int getSize() {
        return this.contentsSize;
    }

    public @NonNull StandardLibraryInternal getStandardLibrary() {
        return this.environmentFactory.getStandardLibrary();
    }

    public boolean hasFinalResult() {
        if (this.contentsSize == 0) {
            return false;
        }
        if (this.getName() == null) {
            return false;
        }
        for (Object object : this.contentsByName.values()) {
            if (object instanceof Property && ((Property)object).isIsImplicit()) continue;
            return true;
        }
        return false;
    }

    public boolean isQualified() {
        return this.isQualified;
    }

    public boolean isQualifier() {
        return this.isQualifier;
    }

    public void removeFilter(@NonNull ScopeFilter filter) {
        if (this.matchers != null) {
            this.matchers.remove(filter);
        }
    }

    public int resolveDuplicates() {
        if (this.contentsSize > 1 && this.getName() != null) {
            int newSize = 0;
            for (Map.Entry<String, Object> entry : this.contentsByName.entrySet()) {
                Object listOrValue = entry.getValue();
                if (listOrValue instanceof MyList) {
                    MyList values = (MyList)listOrValue;
                    int i = 0;
                    while (i < values.size() - 1) {
                        boolean iRemoved = false;
                        @NonNull E iValue = values.get(i);
                        int j = i + 1;
                        while (j < values.size()) {
                            java.lang.Class<?> iClass = iValue.getClass();
                            @NonNull E jValue = values.get(j);
                            java.lang.Class<?> jClass = jValue.getClass();
                            int verdict = 0;
                            for (java.lang.Class<?> key : disambiguatorMap.keySet()) {
                                if (!key.isAssignableFrom(iClass) || !key.isAssignableFrom(jClass)) continue;
                                List<Comparator<Object>> comparators = disambiguatorMap.get(key);
                                assert (comparators != null);
                                for (Comparator<Object> comparator : comparators) {
                                    verdict = comparator instanceof Disambiguator ? ((Disambiguator)comparator).compare(this.environmentFactory, iValue, jValue) : comparator.compare(iValue, jValue);
                                    if (verdict != 0) break;
                                }
                                if (verdict != 0) break;
                            }
                            if (verdict == 0) {
                                ++j;
                                continue;
                            }
                            if (verdict < 0) {
                                values.remove(i);
                                iRemoved = true;
                                break;
                            }
                            values.remove(j);
                        }
                        if (iRemoved) continue;
                        ++i;
                    }
                    newSize += values.size();
                    continue;
                }
                ++newSize;
            }
            this.contentsSize = newSize;
        }
        return this.getSize();
    }

    public void setIsQualified(boolean isQualified) {
        this.isQualified = isQualified;
    }

    public void setIsQualifier(boolean isQualifier) {
        this.isQualifier = isQualifier;
    }

    public void setRequiredType(@Nullable EClassifier requiredType) {
        assert (requiredType == null || PivotUtil.conformsTo(this.reference.getEType(), requiredType));
        this.requiredType = requiredType;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.reference.getName());
        s.append(" : ");
        if (this.requiredType != null) {
            s.append(this.requiredType.getName());
        }
        if (this.isQualifier) {
            s.append(" (qualifier)");
        }
        s.append(" \"");
        if (this.name != null) {
            s.append(this.name);
        }
        s.append("\" {");
        String prefix = "";
        for (String contentName : this.contentsByName.keySet()) {
            s.append(prefix);
            s.append(contentName);
            Object content = this.contentsByName.get(contentName);
            if (content instanceof List) {
                s.append("*");
                s.append(((List)content).size());
            }
            prefix = ",";
        }
        s.append("}");
        return s.toString();
    }

    public static class DiagnosticWrappedException
    extends WrappedException
    implements Resource.Diagnostic {
        private static final long serialVersionUID = 1L;

        public DiagnosticWrappedException(String message, Exception exception) {
            super(message, exception);
        }

        public DiagnosticWrappedException(Exception exception) {
            super(exception);
        }

        public String getLocation() {
            return "unknown";
        }

        public int getColumn() {
            return 0;
        }

        public int getLine() {
            return 0;
        }
    }

    public static abstract class Disambiguator<T>
    implements Comparator<T> {
        @Override
        public int compare(T o1, T o2) {
            throw new UnsupportedOperationException();
        }

        public abstract int compare(@NonNull EnvironmentFactoryInternal var1, @NonNull T var2, @NonNull T var3);
    }

    private static final class ImplicitDisambiguator
    extends Disambiguator<Object> {
        private ImplicitDisambiguator() {
        }

        @Override
        public int compare(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Object match1, @NonNull Object match2) {
            boolean match2IsImplicit;
            boolean match1IsImplicit = match1 instanceof Property && ((Property)match1).isIsImplicit();
            boolean bl = match2IsImplicit = match2 instanceof Property && ((Property)match2).isIsImplicit();
            if (!match1IsImplicit) {
                return match2IsImplicit ? 1 : 0;
            }
            return match2IsImplicit ? 0 : -1;
        }
    }

    private static final class MergedPackageDisambiguator
    extends Disambiguator<Package> {
        private MergedPackageDisambiguator() {
        }

        @Override
        public int compare(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Package match1, @NonNull Package match2) {
            CompletePackageInternal completePackage2;
            CompleteModelInternal completeModel = environmentFactory.getCompleteModel();
            CompletePackageInternal completePackage1 = completeModel.getCompletePackage(match1);
            if (completePackage1 == (completePackage2 = completeModel.getCompletePackage(match2))) {
                return 1;
            }
            return 0;
        }
    }

    private static final class MetamodelMergeDisambiguator
    extends Disambiguator<Feature> {
        private MetamodelMergeDisambiguator() {
        }

        @Override
        public int compare(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Feature match1, @NonNull Feature match2) {
            CompletePackage s2;
            Package p1 = PivotUtil.getContainingPackage(match1);
            Package p2 = PivotUtil.getContainingPackage(match2);
            if (p1 == null) {
                return 0;
            }
            if (p2 == null) {
                return 0;
            }
            CompleteModelInternal completeModel = environmentFactory.getCompleteModel();
            CompletePackage s1 = completeModel.getCompletePackage(p1);
            if (s1 != (s2 = completeModel.getCompletePackage(p2))) {
                return 0;
            }
            int i1 = s1.getIndex(p1);
            int i2 = s2.getIndex(p2);
            return i2 - i1;
        }
    }

    private static final class MyList
    extends ArrayList<Object> {
        private MyList() {
        }
    }

    private static final class OperationDisambiguator
    extends Disambiguator<Operation> {
        private OperationDisambiguator() {
        }

        @Override
        public int compare(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Operation match1, @NonNull Operation match2) {
            if (this.isRedefinitionOf(match1, match2)) {
                return 1;
            }
            if (this.isRedefinitionOf(match2, match1)) {
                return -1;
            }
            return 0;
        }

        protected boolean isRedefinitionOf(@NonNull Operation operation1, @NonNull Operation operation2) {
            List<Operation> redefinedOperations = operation1.getRedefinedOperations();
            for (Operation redefinedOperation : redefinedOperations) {
                if (redefinedOperation == null) continue;
                if (redefinedOperation == operation2) {
                    return true;
                }
                if (!this.isRedefinitionOf(redefinedOperation, operation2)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class PropertyDisambiguator
    extends Disambiguator<Property> {
        private PropertyDisambiguator() {
        }

        @Override
        public int compare(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Property match1, @NonNull Property match2) {
            if (this.isRedefinitionOf(match1, match2)) {
                return 1;
            }
            if (this.isRedefinitionOf(match2, match1)) {
                return -1;
            }
            Property opposite1 = match1.getOpposite();
            if (opposite1 != null && "base_Class".equals(opposite1.getName())) {
                return -1;
            }
            Property opposite2 = match2.getOpposite();
            if (opposite2 != null && "base_Class".equals(opposite2.getName())) {
                return 1;
            }
            return 0;
        }

        protected boolean isRedefinitionOf(@NonNull Property property1, @NonNull Property property2) {
            List<Property> redefinedProperties = property1.getRedefinedProperties();
            for (Property redefinedProperty : redefinedProperties) {
                if (redefinedProperty == null) continue;
                if (redefinedProperty == property2) {
                    return true;
                }
                if (!this.isRedefinitionOf(redefinedProperty, property2)) continue;
                return true;
            }
            return false;
        }
    }
}

