/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ocl.examples.test.xtext.AbstractConsoleTests;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Transition;

public class UMLConsoleTests
extends AbstractConsoleTests {
    public void testConsole_Bug400090() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI testModelURI = UMLConsoleTests.getTestModelURI("models/uml/Bug400090.uml");
        Resource umlResource = resourceSet.getResource(testModelURI, true);
        Model model = (Model)umlResource.getContents().get(0);
        Class bookClass = (Class)model.getOwnedType("Book");
        InstanceSpecification bookInstance = (InstanceSpecification)model.getOwnedMember("TheBook");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)bookClass, "self", "Bug400090::Book\n");
        UMLConsoleTests.assertFalse((boolean)this.consolePage.isPopUpModelTypesUsageInformation());
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)bookInstance, "self.classifier", "Bug400090::Book\n");
        UMLConsoleTests.assertTrue((boolean)this.consolePage.isPopUpModelTypesUsageInformation());
        this.consolePage.resetPopUpModelTypesUsageInformation();
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)bookInstance, "self.price", "<b><error>Parsing failure\n</error></b><error>\n1:6: Unresolved Property 'UML::InstanceSpecification::price'\n</error>");
        UMLConsoleTests.assertFalse((boolean)this.consolePage.isPopUpModelTypesUsageInformation());
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)bookClass, "self", "Bug400090::Book\n");
        UMLConsoleTests.assertFalse((boolean)this.consolePage.isPopUpModelTypesUsageInformation());
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)bookInstance, "self.classifier", "Bug400090::Book\n");
        UMLConsoleTests.assertTrue((boolean)this.consolePage.isPopUpModelTypesUsageInformation());
        this.consolePage.resetPopUpModelTypesUsageInformation();
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)bookInstance, "self.oclAsModelType(Bug400090::Book).price", "7.5\n");
        UMLConsoleTests.assertFalse((boolean)this.consolePage.isPopUpModelTypesUsageInformation());
        this.consolePage.cancelValidation();
    }

    public void testConsole_Bug419556() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI testModelURI = UMLConsoleTests.getTestModelURI("models/uml/Bug419556.uml");
        Resource umlResource = resourceSet.getResource(testModelURI, true);
        Model model = (Model)umlResource.getContents().get(0);
        Class class1 = (Class)model.getOwnedType("Class1");
        Property attribute1 = class1.getOwnedAttribute("Attribute1", null);
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)class1, "self.extension_Stereotype3", "Class1$Stereotype3\n");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)attribute1, "self.extension_Stereotype1", "Attribute1$Stereotype1\n");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)attribute1, "self.extension_Stereotype2", "<error>null\n</error>");
        this.consolePage.cancelValidation();
    }

    public void testConsole_Bug437715() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI testModelURI = UMLConsoleTests.getTestModelURI("models/uml/Bug437715.uml");
        Resource umlResource = resourceSet.getResource(testModelURI, true);
        Model model = (Model)umlResource.getContents().get(0);
        Class class1 = (Class)model.getOwnedType("Class1");
        Class class2 = (Class)model.getOwnedType("Class2");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)class1, "self.extension_Stereotype1.stereotype2", "\u00abStereotype2\u00bbmodel::Class2\n");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)class2, "self.extension_Stereotype2.stereotype1", "\u00abStereotype1\u00bbmodel::Class1\n");
        this.consolePage.cancelValidation();
    }

    public void testConsole_Bug474085() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI testModelURI = UMLConsoleTests.getTestModelURI("models/uml/Bug474085.uml");
        Resource umlResource = resourceSet.getResource(testModelURI, true);
        Model model = (Model)umlResource.getContents().get(0);
        StateMachine sm = (StateMachine)model.getOwnedType("StateMachine0");
        Region region0a = sm.getRegion("Region0");
        Transition transition0a = region0a.getTransition("Transition0");
        Transition transition1a = region0a.getTransition("Transition1");
        Transition transition2a = region0a.getTransition("Transition2");
        State state0 = (State)region0a.getSubvertex("State0");
        Region region0b = state0.getRegion("Region0");
        Transition transition3b = region0b.getTransition("Transition3");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)transition3b, "self.extension_EnsureRole", "Transition3$EnsureRole\n");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)transition3b, "self.extension_EnsureRole.role", "'user=bob'\n'role=admin'\n");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)transition2a, "self.extension_EnsureRole.role", "'One'\n'Two'\n");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)transition1a, "self.extension_EnsureRole.role", "'One'\n");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)transition0a, "self.extension_EnsureRole.role", "");
        this.consolePage.cancelValidation();
    }

    public void testConsole_Bug507406() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI testModelURI = UMLConsoleTests.getTestModelURI("models/uml/Bug507406.uml");
        Resource umlResource = resourceSet.getResource(testModelURI, true);
        Model model = (Model)umlResource.getContents().get(0);
        Interaction interaction1 = (Interaction)model.getOwnedType("Interaction1");
        Message message = interaction1.getMessage("Message");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)message, "self", "RootElement::Interaction1::Message\n");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)message, "self.receiveEvent", "RootElement::Interaction1::MessageRecv\n");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)message, "self.receiveEvent.oclAsType(MessageOccurrenceSpecification).covered", "RootElement::Interaction1::Lifeline0\n");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)message, "self.receiveEvent.oclAsType(MessageOccurrenceSpecification).covered.extension_MyLifeline2", "Lifeline0$MyLifeline2\n");
        this.consolePage.cancelValidation();
    }

    public void testConsole_Bug512553() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI testModelURI = UMLConsoleTests.getTestModelURI("models/uml/Bug512553.uml");
        Resource umlResource = resourceSet.getResource(testModelURI, true);
        Model model = (Model)umlResource.getContents().get(0);
        Class person = (Class)model.getOwnedType("Person");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)person, "isLower('john')", "true\n");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)person, "Person::isLower('John')", "false\n");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)person, "test::Person::isLower('John')", "false\n");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)person, "test::Person::isLower('john')", "true\n");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)person, "test::Person.isLower('John')", "false\n");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)person, "test::Person.isLower('john')", "true\n");
        this.consolePage.cancelValidation();
    }

    public void testConsole_Bug516285() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI testModelURI = UMLConsoleTests.getTestModelURI("models/uml/Bug516285.uml");
        Resource umlResource = resourceSet.getResource(testModelURI, true);
        Model model = (Model)umlResource.getContents().get(0);
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)model, "allOwnedElements()->selectByKind(Property)", "RootElement::CustomerService::ServiceAgreement::serviceLevel\n");
        this.consolePage.cancelValidation();
    }

    public void testConsole_UML() throws Exception {
        this.doDelete("org.eclipse.ocl.examples.xtext.tests");
        OCL ocl = this.consolePage.getEditorOCL();
        EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
        ResourceSet resourceSet = ocl.getResourceSet();
        Resource umlResource = resourceSet.getResource(UMLConsoleTests.getTestModelURI("models/uml/InternationalizedClasses.uml"), true);
        Resource umlProfileResource = resourceSet.getResource(UMLConsoleTests.getTestModelURI("models/uml/Internationalized.profile.uml"), true);
        Package umlPackage = (Package)umlResource.getContents().get(0);
        org.eclipse.uml2.uml.Type umlEnglishClass = umlPackage.getOwnedType("EnglishClass");
        Profile umlProfile = (Profile)umlProfileResource.getContents().get(0);
        Stereotype umlInEnglishStereotype = umlProfile.getOwnedStereotype("InEnglish");
        Stereotype umlInFrenchStereotype = umlProfile.getOwnedStereotype("InFrench");
        Stereotype umlInGermanStereotype = umlProfile.getOwnedStereotype("InGerman");
        Type asEnglishClass = (Type)environmentFactory.getASOf(Type.class, (EObject)umlEnglishClass);
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)umlEnglishClass, "self.name", "'EnglishClass'\n");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)umlEnglishClass, "Stereotype.allInstances()->sortedBy(name)", "");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)umlInEnglishStereotype, "Stereotype.allInstances()->sortedBy(name)", "InternationalizedProfile::InEnglish\nInternationalizedProfile::InFrench\nInternationalizedProfile::InGerman\nInternationalizedProfile::Internationalized\n");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)umlEnglishClass, "Class.allInstances()->sortedBy(name)", "Model::EnglishClass\nModel::FrenchClass\nModel::GermanClass\nModel::LanguageClass\nModel::MultiLingualClass\nModel::PlainClass\n");
        UMLConsoleTests.assertConsoleResult(this.consolePage, (EObject)asEnglishClass, "ocl::Class.allInstances()->sortedBy(name)", "Model::EnglishClass\nEnglishClass$InEnglish\nModel::FrenchClass\nFrenchClass$InFrench\nModel::GermanClass\nGermanClass$InGerman\nModel::LanguageClass\nModel::MultiLingualClass\nMultiLingualClass$InEnglish\nMultiLingualClass$InFrench\nMultiLingualClass$InGerman\nModel::PlainClass\nString\n");
        this.consolePage.cancelValidation();
    }
}

