/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.AssociativityKind;
import org.eclipse.ocl.pivot.Library;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Precedence;
import org.eclipse.ocl.pivot.internal.manager.PrecedenceManager;

public class PrecedenceTests
extends XtextTestCase {
    protected @NonNull Precedence createPrecedence(Library library1, String name, AssociativityKind associativity) {
        Precedence precedence = PivotFactory.eINSTANCE.createPrecedence();
        precedence.setName(name);
        precedence.setAssociativity(associativity);
        library1.getOwnedPrecedences().add(precedence);
        return precedence;
    }

    public void testOkAssignPrecedences() {
        ArrayList<@NonNull Library> libraries = new ArrayList<Library>();
        Library library1 = PivotFactory.eINSTANCE.createLibrary();
        Precedence p1a = this.createPrecedence(library1, "A", AssociativityKind.LEFT);
        Precedence p1b = this.createPrecedence(library1, "B", AssociativityKind.LEFT);
        Precedence p1c = this.createPrecedence(library1, "D", AssociativityKind.LEFT);
        libraries.add(library1);
        Library library2 = PivotFactory.eINSTANCE.createLibrary();
        Precedence p2a = this.createPrecedence(library2, "B", AssociativityKind.LEFT);
        Precedence p2b = this.createPrecedence(library2, "C", AssociativityKind.LEFT);
        Precedence p2c = this.createPrecedence(library2, "D", AssociativityKind.LEFT);
        libraries.add(library2);
        PrecedenceManager precedenceManager = new PrecedenceManager();
        List errors = precedenceManager.compilePrecedences(libraries);
        PrecedenceTests.assertEquals((int)0, (int)precedenceManager.getOrder(p1a));
        PrecedenceTests.assertEquals((int)1, (int)precedenceManager.getOrder(p1b));
        PrecedenceTests.assertEquals((int)3, (int)precedenceManager.getOrder(p1c));
        PrecedenceTests.assertEquals((int)1, (int)precedenceManager.getOrder(p2a));
        PrecedenceTests.assertEquals((int)2, (int)precedenceManager.getOrder(p2b));
        PrecedenceTests.assertEquals((int)3, (int)precedenceManager.getOrder(p2c));
        PrecedenceTests.assertEquals((int)0, (int)errors.size());
    }

    public void testBadOrderingAssignPrecedences() {
        ArrayList<@NonNull Library> libraries = new ArrayList<Library>();
        Library library1 = PivotFactory.eINSTANCE.createLibrary();
        Precedence p1a = this.createPrecedence(library1, "A", AssociativityKind.LEFT);
        Precedence p1b = this.createPrecedence(library1, "B", AssociativityKind.LEFT);
        libraries.add(library1);
        Library library2 = PivotFactory.eINSTANCE.createLibrary();
        Precedence p2a = this.createPrecedence(library2, "B", AssociativityKind.LEFT);
        Precedence p2b = this.createPrecedence(library2, "A", AssociativityKind.LEFT);
        libraries.add(library2);
        PrecedenceManager precedenceManager = new PrecedenceManager();
        List errors = precedenceManager.compilePrecedences(libraries);
        PrecedenceTests.assertEquals((int)0, (int)precedenceManager.getOrder(p1a));
        PrecedenceTests.assertEquals((int)1, (int)precedenceManager.getOrder(p1b));
        PrecedenceTests.assertEquals((int)1, (int)precedenceManager.getOrder(p2a));
        PrecedenceTests.assertEquals((int)0, (int)precedenceManager.getOrder(p2b));
        PrecedenceTests.assertEquals((int)1, (int)errors.size());
    }

    public void testBadAssociativityAssignPrecedences() {
        ArrayList<@NonNull Library> libraries = new ArrayList<Library>();
        Library library1 = PivotFactory.eINSTANCE.createLibrary();
        Precedence p1a = this.createPrecedence(library1, "A", AssociativityKind.LEFT);
        libraries.add(library1);
        Library library2 = PivotFactory.eINSTANCE.createLibrary();
        Precedence p2a = this.createPrecedence(library2, "A", AssociativityKind.RIGHT);
        libraries.add(library2);
        PrecedenceManager precedenceManager = new PrecedenceManager();
        List errors = precedenceManager.compilePrecedences(libraries);
        PrecedenceTests.assertEquals((int)0, (int)precedenceManager.getOrder(p1a));
        PrecedenceTests.assertEquals((int)0, (int)precedenceManager.getOrder(p2a));
        PrecedenceTests.assertEquals((int)1, (int)errors.size());
    }

    public void testAmbiguousInternalAssignPrecedences() {
        ArrayList<@NonNull Library> libraries = new ArrayList<Library>();
        Library library1 = PivotFactory.eINSTANCE.createLibrary();
        Precedence p1a = this.createPrecedence(library1, "A", AssociativityKind.LEFT);
        Precedence p1b = this.createPrecedence(library1, "B", AssociativityKind.LEFT);
        Precedence p1c = this.createPrecedence(library1, "D", AssociativityKind.LEFT);
        libraries.add(library1);
        Library library2 = PivotFactory.eINSTANCE.createLibrary();
        Precedence p2a = this.createPrecedence(library2, "A", AssociativityKind.LEFT);
        Precedence p2b = this.createPrecedence(library2, "C", AssociativityKind.LEFT);
        Precedence p2c = this.createPrecedence(library2, "D", AssociativityKind.LEFT);
        libraries.add(library2);
        PrecedenceManager precedenceManager = new PrecedenceManager();
        List errors = precedenceManager.compilePrecedences(libraries);
        PrecedenceTests.assertEquals((int)0, (int)precedenceManager.getOrder(p1a));
        PrecedenceTests.assertEquals((int)2, (int)precedenceManager.getOrder(p1b));
        PrecedenceTests.assertEquals((int)3, (int)precedenceManager.getOrder(p1c));
        PrecedenceTests.assertEquals((int)0, (int)precedenceManager.getOrder(p2a));
        PrecedenceTests.assertEquals((int)1, (int)precedenceManager.getOrder(p2b));
        PrecedenceTests.assertEquals((int)3, (int)precedenceManager.getOrder(p2c));
        PrecedenceTests.assertEquals((int)1, (int)errors.size());
    }

    public void testAmbiguousTailAssignPrecedences() {
        ArrayList<@NonNull Library> libraries = new ArrayList<Library>();
        Library library1 = PivotFactory.eINSTANCE.createLibrary();
        Precedence p1a = this.createPrecedence(library1, "A", AssociativityKind.LEFT);
        Precedence p1b = this.createPrecedence(library1, "B", AssociativityKind.LEFT);
        libraries.add(library1);
        Library library2 = PivotFactory.eINSTANCE.createLibrary();
        Precedence p2a = this.createPrecedence(library2, "A", AssociativityKind.LEFT);
        Precedence p2b = this.createPrecedence(library2, "C", AssociativityKind.LEFT);
        libraries.add(library2);
        PrecedenceManager precedenceManager = new PrecedenceManager();
        List errors = precedenceManager.compilePrecedences(libraries);
        PrecedenceTests.assertEquals((int)0, (int)precedenceManager.getOrder(p1a));
        PrecedenceTests.assertEquals((int)2, (int)precedenceManager.getOrder(p1b));
        PrecedenceTests.assertEquals((int)0, (int)precedenceManager.getOrder(p2a));
        PrecedenceTests.assertEquals((int)1, (int)precedenceManager.getOrder(p2b));
        PrecedenceTests.assertEquals((int)1, (int)errors.size());
    }
}

