/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.elements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.build.elements.AbstractSerializationElement;
import org.eclipse.ocl.examples.xtext.build.elements.ListOfListOfSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.NullSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.SequenceSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.SerializationElement;
import org.eclipse.ocl.examples.xtext.build.elements.SerializationNode;
import org.eclipse.ocl.examples.xtext.serializer.DiagnosticStringBuilder;
import org.eclipse.ocl.examples.xtext.serializer.GrammarCardinality;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.CompoundElement;

public class ListOfSerializationNode
extends AbstractSerializationElement {
    private final @NonNull List<@NonNull SerializationNode> listOfNodes;

    public ListOfSerializationNode() {
        this.listOfNodes = new ArrayList<SerializationNode>();
    }

    public ListOfSerializationNode(@NonNull List<@NonNull SerializationNode> listOfNodes) {
        this.listOfNodes = listOfNodes;
    }

    @Override
    public @NonNull SerializationElement addConcatenation(@NonNull SerializationElement additionalSerializationElement) {
        if (additionalSerializationElement.isNull()) {
            return this;
        }
        if (additionalSerializationElement.isNode()) {
            this.appendNodeToList(this.listOfNodes, additionalSerializationElement.asNode());
            return this;
        }
        if (additionalSerializationElement.isList()) {
            this.listOfNodes.addAll(additionalSerializationElement.asList().getNodes());
            return this;
        }
        if (additionalSerializationElement.isListOfList()) {
            ArrayList<@NonNull List<@NonNull SerializationNode>> newListOfList = new ArrayList<List<SerializationNode>>();
            for (List<SerializationNode> additionalList : additionalSerializationElement.asListOfList().getLists()) {
                ArrayList<@NonNull SerializationNode> newList = new ArrayList<SerializationNode>(this.listOfNodes);
                newList.addAll(additionalList);
                newListOfList.add(newList);
            }
            return new ListOfListOfSerializationNode(newListOfList);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull ListOfSerializationNode asList() {
        return this;
    }

    @Override
    public @NonNull SerializationNode freezeAlternatives(@NonNull Alternatives alternatives) {
        throw new IllegalStateException();
    }

    @Override
    public @NonNull SerializationElement freezeSequences(@NonNull CompoundElement compoundElement, @NonNull GrammarCardinality grammarCardinality, boolean isRootAlternative) {
        int size = this.listOfNodes.size();
        if (size <= 0) {
            return NullSerializationNode.INSTANCE;
        }
        if (size > 1) {
            isRootAlternative = false;
        }
        return ListOfSerializationNode.createFrozenSequence(compoundElement, grammarCardinality, this.listOfNodes, isRootAlternative);
    }

    public @NonNull List<@NonNull SerializationNode> getNodes() {
        return this.listOfNodes;
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public boolean noUnassignedParserRuleCall() {
        for (SerializationNode serializationNode : this.listOfNodes) {
            if (serializationNode.noUnassignedParserRuleCall()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean onlyRootUnassignedSerializationRuleCall(boolean isRootAlternative) {
        if (this.listOfNodes.size() > 1) {
            isRootAlternative = false;
        }
        for (SerializationNode serializationNode : this.listOfNodes) {
            if (serializationNode.onlyRootUnassignedSerializationRuleCall(isRootAlternative)) continue;
            return false;
        }
        return true;
    }

    @Override
    public @NonNull SerializationElement setGrammarCardinality(@NonNull CompoundElement compoundElement, @NonNull GrammarCardinality grammarCardinality) {
        if (grammarCardinality.isOne()) {
            return this;
        }
        return new SequenceSerializationNode(compoundElement, grammarCardinality, this.getNodes());
    }

    @Override
    public void toString(@NonNull DiagnosticStringBuilder s, int depth) {
        s.append("{");
        if (this.listOfNodes.size() > 0) {
            for (SerializationNode serializationNode : this.listOfNodes) {
                s.appendIndentation(depth);
                s.append("+\t");
                serializationNode.toString(s, depth + 1);
            }
            s.appendIndentation(depth);
        }
        s.append("}");
    }
}

