/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.types.SetType;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.VisibilityKind;

public class BasicOCLTest
extends AbstractTestSuite {
    public void hide_test_createStandardLibrary() {
        Resource res = ((Classifier)this.ocl.getEnvironment().getOCLStandardLibrary().getOclAny()).eResource();
        URI oldURI = res.getURI();
        res.setURI(URI.createFileURI((String)"c:/temp/oclstdlib.uml"));
        try {
            try {
                res.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                BasicOCLTest.fail((String)e.getLocalizedMessage());
                res.setURI(oldURI);
            }
        }
        finally {
            res.setURI(oldURI);
        }
    }

    public void test_collectionsAndIteratorsAccess_222747() {
        SetType type = this.ocl.getEnvironment().getOCLFactory().createSetType((Object)((Classifier)this.ocl.getEnvironment().getOCLStandardLibrary().getOclInvalid()));
        HashSet iterators = new HashSet(type.oclIterators());
        HashSet operations = new HashSet(type.oclOperations());
        HashSet difference = new HashSet(operations);
        difference.removeAll(iterators);
        BasicOCLTest.assertEquals((int)difference.size(), (int)operations.size());
        BasicOCLTest.assertTrue((operations.size() > 0 ? 1 : 0) != 0);
        BasicOCLTest.assertTrue((iterators.size() > 0 ? 1 : 0) != 0);
    }

    public void testTrivialExpressions() {
        OCLExpression constraint = this.parseConstraint("package UML context Class inv: true endpackage");
        Object result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.TRUE, (Object)result);
        constraint = this.parseConstraint("package UML context Class inv: false endpackage");
        result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    public void testLogicalConnectives() {
        OCLExpression constraint = this.parseConstraint("package UML context Class inv: true and true endpackage");
        Object result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.TRUE, (Object)result);
        constraint = this.parseConstraint("package UML context Class inv: false or false endpackage");
        result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.FALSE, (Object)result);
        constraint = this.parseConstraint("package UML context Class inv: true and false endpackage");
        result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.FALSE, (Object)result);
        constraint = this.parseConstraint("package UML context Class inv: true or false endpackage");
        result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.TRUE, (Object)result);
        constraint = this.parseConstraint("package UML context Class inv: not true endpackage");
        result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.FALSE, (Object)result);
        constraint = this.parseConstraint("package UML context Class inv: true implies true endpackage");
        result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.TRUE, (Object)result);
        constraint = this.parseConstraint("package UML context Class inv: true implies false endpackage");
        result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.FALSE, (Object)result);
        constraint = this.parseConstraint("package UML context Class inv: false implies true endpackage");
        result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.TRUE, (Object)result);
        constraint = this.parseConstraint("package UML context Class inv: false implies false endpackage");
        result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    public void testSimpleAttributeExpressions() {
        Class eCls = umlf.createClass();
        eCls.setName("bar");
        OCLExpression constraint = this.parseConstraint("package UML context Class inv: self.name <> 'foo' endpackage");
        BasicOCLTest.assertTrue((boolean)this.check(constraint, eCls));
        eCls.setName("foo");
        BasicOCLTest.assertFalse((boolean)this.check(constraint, eCls));
    }

    public void testCollectionExpressions() {
        DataType eCls = umlf.createDataType();
        eCls.setName("bar");
        eCls.createOwnedAttribute("att1", null);
        eCls.createOwnedAttribute("att2", null);
        BasicOCLTest.assertEquals((int)eCls.getOwnedAttributes().size(), (int)2);
        OCLExpression constraint = this.parseConstraint("package UML context DataType inv: self.ownedAttribute->size() = 2 endpackage");
        BasicOCLTest.assertTrue((boolean)this.check(constraint, eCls));
        OCLExpression constraint2 = this.parseConstraint("package UML context DataType inv: Tuple{status:Boolean=self.ownedAttribute->size() = 2}.status endpackage");
        BasicOCLTest.assertTrue((boolean)this.check(constraint2, eCls));
        constraint = this.parseConstraint("package UML context DataType inv: self.ownedAttribute->forAll(a: Property | not a.isDerived) endpackage");
        BasicOCLTest.assertTrue((boolean)this.check(constraint, eCls));
    }

    public void testNonBooleansExpressions() {
        Enumeration eCls = umlf.createEnumeration();
        eCls.setName("bar");
        OCLExpression expr = this.parse("package UML context Enumeration inv: self.name endpackage ");
        Object result = this.evaluate(expr, eCls);
        BasicOCLTest.assertEquals((Object)"bar", (Object)result);
        expr = this.parse("package UML context Enumeration inv: self endpackage");
        result = this.evaluate(expr, eCls);
        BasicOCLTest.assertSame((Object)eCls, (Object)result);
    }

    public void testIfExpressions() {
        Class eCls = umlf.createClass();
        eCls.setName("bar");
        OCLExpression expr = this.parse("package UML context Class inv: if self.isAbstract then name = 'bar' else name <> 'bar' endif endpackage ");
        BasicOCLTest.assertFalse((boolean)this.check(expr, eCls));
        eCls.setIsAbstract(true);
        BasicOCLTest.assertTrue((boolean)this.check(expr, eCls));
        eCls.setName("foo");
        BasicOCLTest.assertFalse((boolean)this.check(expr, eCls));
    }

    public void testLetExpressions() {
        DataType eCls = umlf.createDataType();
        eCls.setName("foo");
        OCLExpression expr = this.parse("package UML context DataType inv: let feats : OrderedSet(Property) = self.ownedAttribute in   feats->isEmpty() implies name <> 'bar' endpackage ");
        BasicOCLTest.assertTrue((boolean)this.check(expr, eCls));
        eCls.setName("bar");
        BasicOCLTest.assertFalse((boolean)this.check(expr, eCls));
        eCls.createOwnedAttribute("att1", null);
        BasicOCLTest.assertTrue((boolean)this.check(expr, eCls));
        eCls.setName("foo");
        BasicOCLTest.assertTrue((boolean)this.check(expr, eCls));
    }

    public void test_dataTypeAsContext() {
        OCLExpression expr = this.parse("package PrimitiveTypes context \"String\" inv: self.toUpper() <> self.toLower() endpackage ");
        BasicOCLTest.assertTrue((boolean)this.check(expr, "anything"));
        BasicOCLTest.assertTrue((boolean)this.check(expr, "ANYTHING"));
        expr = this.parse("package PrimitiveTypes context \"String\" inv: self.toUpper() endpackage ");
        BasicOCLTest.assertEquals((Object)"ANYTHING", (Object)this.evaluate(expr, "anything"));
    }

    public void test_equals_primitives() {
        BasicOCLTest.assertTrue((boolean)this.check("1 = 1"));
        BasicOCLTest.assertTrue((boolean)this.check("1 = 1.0"));
        BasicOCLTest.assertTrue((boolean)this.check("1.0 = 1"));
        BasicOCLTest.assertTrue((boolean)this.check("1.0 = 1.0"));
        BasicOCLTest.assertTrue((boolean)this.check("'foo' = 'foo'"));
        BasicOCLTest.assertTrue((boolean)this.check("ocltest::Color::red = ocltest::Color::red"));
        BasicOCLTest.assertFalse((boolean)this.check("ocltest::Color::red = ocltest::Color::black"));
    }

    public void test_evaluationEnvironment_getType_178901() {
        EvaluationEnvironment evalEnv = this.ocl.getEvaluationEnvironment();
        BasicOCLTest.assertSame((Object)this.getMetametaclass("Package"), (Object)evalEnv.getType((Object)this.fruitPackage));
        BasicOCLTest.assertSame((Object)this.getMetametaclass("Class"), (Object)evalEnv.getType((Object)this.fruit));
        BasicOCLTest.assertSame((Object)this.getOCLStandardLibrary().getString(), (Object)evalEnv.getType((Object)"foo"));
        BasicOCLTest.assertSame((Object)this.getOCLStandardLibrary().getOclAny(), (Object)evalEnv.getType((Object)this));
    }

    public void test_oclIsKindOf() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Stereotype")));
        Stereotype stereo = umlf.createStereotype();
        try {
            BasicOCLTest.assertTrue((boolean)this.check(this.helper, stereo, "self.oclIsKindOf(Class)"));
            BasicOCLTest.assertTrue((boolean)this.check(this.helper, stereo, "self.oclIsKindOf(Stereotype)"));
            BasicOCLTest.assertFalse((boolean)this.check(this.helper, stereo, "self.oclIsKindOf(Connector)"));
        }
        catch (Exception e) {
            BasicOCLTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_oclIsTypeOf_196264() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Stereotype")));
        Stereotype stereo = umlf.createStereotype();
        try {
            BasicOCLTest.assertFalse((boolean)this.check(this.helper, stereo, "self.oclIsTypeOf(Class)"));
            BasicOCLTest.assertTrue((boolean)this.check(this.helper, stereo, "self.oclIsTypeOf(Stereotype)"));
            BasicOCLTest.assertFalse((boolean)this.check(this.helper, stereo, "self.oclIsTypeOf(Connector)"));
        }
        catch (Exception e) {
            BasicOCLTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_enumerationLiteralValue_198945() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("VisibilityKind")));
        try {
            BasicOCLTest.assertSame((Object)VisibilityKind.PROTECTED_LITERAL, (Object)this.evaluate(this.helper, VisibilityKind.PUBLIC_LITERAL, "VisibilityKind::protected"));
        }
        catch (ParserException e) {
            BasicOCLTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }
}

