/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.helper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationException;
import org.eclipse.ocl.pivot.evaluation.EvaluationHaltedException;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.helper.HelperUtil;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.ProblemAware;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.Query;
import org.eclipse.ocl.pivot.utilities.ValueUtil;

public class BasicQueryImpl
implements Query,
ProblemAware {
    private final @NonNull EnvironmentFactory environmentFactory;
    private final @NonNull ExpressionInOCL query;
    private final @NonNull OCLExpression expression;
    private ModelManager modelManager = null;
    private EvaluationEnvironment evaluationEnvironment = null;
    private Diagnostic evalProblems;
    private BasicDiagnostic batchEvalProblems;

    public BasicQueryImpl(@NonNull EnvironmentFactory environmentFactory, @NonNull ExpressionInOCL query) {
        this.environmentFactory = environmentFactory;
        this.query = query;
        this.expression = ClassUtil.nonNullState(query.getOwnedBody());
    }

    @Override
    public boolean checkBoxed(@Nullable Object boxedObject) {
        if (this.resultType() != this.environmentFactory.getStandardLibrary().getBooleanType()) {
            IllegalArgumentException error = new IllegalArgumentException(PivotMessagesInternal.BooleanQuery_ERROR_);
            HelperUtil.throwing(this.getClass(), "check", error);
            throw error;
        }
        Object result = this.evaluateBoxed(boxedObject);
        return result == ValueUtil.TRUE_VALUE;
    }

    @Override
    public boolean checkBoxed(@NonNull Iterable<?> boxedObjects) {
        if (this.resultType() != this.environmentFactory.getStandardLibrary().getBooleanType()) {
            IllegalArgumentException error = new IllegalArgumentException(PivotMessagesInternal.BooleanQuery_ERROR_);
            HelperUtil.throwing(this.getClass(), "check", error);
            throw error;
        }
        for (Object boxedObject : boxedObjects) {
            Object result = this.evaluateBoxed(boxedObject);
            if (result == ValueUtil.TRUE_VALUE) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean checkEcore(@Nullable Object ecoreObject) {
        if (this.resultType() != this.environmentFactory.getStandardLibrary().getBooleanType()) {
            IllegalArgumentException error = new IllegalArgumentException(PivotMessagesInternal.BooleanQuery_ERROR_);
            HelperUtil.throwing(this.getClass(), "check", error);
            throw error;
        }
        Object result = this.evaluateEcore(null, ecoreObject);
        return result == ValueUtil.TRUE_VALUE;
    }

    @Override
    public boolean checkEcore(@NonNull Iterable<?> ecoreObjects) {
        if (this.resultType() != this.environmentFactory.getStandardLibrary().getBooleanType()) {
            IllegalArgumentException error = new IllegalArgumentException(PivotMessagesInternal.BooleanQuery_ERROR_);
            HelperUtil.throwing(this.getClass(), "check", error);
            throw error;
        }
        for (Object ecoreObject : ecoreObjects) {
            Object result = this.evaluateEcore(null, ecoreObject);
            if (result == ValueUtil.TRUE_VALUE) continue;
            return false;
        }
        return true;
    }

    private void commitBatchEvaluateProblems() {
        this.evalProblems = this.batchEvalProblems;
        this.batchEvalProblems = null;
    }

    @Override
    public @Nullable Object evaluateBoxed(@Nullable Object boxedValue) {
        Object boxedResult;
        EvaluationEnvironment myEnv = this.getEvaluationEnvironment(this.environmentFactory.getIdResolver().unboxedValueOf(boxedValue));
        Variable contextVariable = ClassUtil.nonNullState(this.query.getOwnedContext());
        myEnv.add(contextVariable, boxedValue);
        EvaluationVisitor ev = this.environmentFactory.createEvaluationVisitor(myEnv);
        try {
            boxedResult = this.expression.accept(ev);
        }
        catch (EvaluationHaltedException e) {
            this.evalProblems = e.getDiagnostic();
            throw e;
        }
        return boxedResult;
    }

    @Override
    public @NonNull List<?> evaluateBoxed(@NonNull Iterable<?> boxedObjects) {
        ArrayList<Object> boxedResults = new ArrayList<Object>();
        try {
            for (Object boxedObject : boxedObjects) {
                boxedResults.add(this.evaluateBoxed(boxedObject));
                this.handleNextEvaluateProblems();
            }
        }
        finally {
            this.commitBatchEvaluateProblems();
        }
        return boxedResults;
    }

    @Override
    public @Nullable Object evaluateEcore(@Nullable Object ecoreObject) throws EvaluationException {
        return this.evaluateEcore(null, ecoreObject);
    }

    @Override
    public @Nullable Object evaluateEcore(@Nullable Class<?> instanceClass, @Nullable Object ecoreObject) throws EvaluationException {
        this.evalProblems = null;
        IdResolver idResolver = this.environmentFactory.getIdResolver();
        Object boxedValue = idResolver.boxedValueOf(ecoreObject);
        Object boxedResult = this.evaluateBoxed(boxedValue);
        return idResolver.ecoreValueOf(instanceClass, boxedResult);
    }

    @Override
    public @NonNull EList<?> evaluateEcore(@NonNull Iterable<?> ecoreObjects) throws EvaluationException {
        return this.evaluateEcore(null, ecoreObjects);
    }

    @Override
    public @NonNull EList<?> evaluateEcore(@Nullable Class<?> instanceClass, @NonNull Iterable<?> ecoreObjects) {
        BasicEList ecoreResults = new BasicEList();
        try {
            for (Object ecoreObject : ecoreObjects) {
                ecoreResults.add(this.evaluateEcore(instanceClass, ecoreObject));
                this.handleNextEvaluateProblems();
            }
        }
        finally {
            this.commitBatchEvaluateProblems();
        }
        return ecoreResults;
    }

    @Override
    public @Nullable Object evaluateUnboxed(@Nullable Object unboxedObject) throws EvaluationException {
        this.evalProblems = null;
        IdResolver idResolver = this.environmentFactory.getIdResolver();
        Object boxedValue = idResolver.boxedValueOf(unboxedObject);
        Object boxedResult = this.evaluateBoxed(boxedValue);
        return idResolver.unboxedValueOf(boxedResult);
    }

    @Override
    public @NonNull EvaluationEnvironment getEvaluationEnvironment(@Nullable Object unboxedObject) {
        EvaluationEnvironment evaluationEnvironment2 = this.evaluationEnvironment;
        if (evaluationEnvironment2 == null) {
            ModelManager modelManager2 = this.modelManager;
            if (modelManager2 == null) {
                this.modelManager = modelManager2 = this.environmentFactory.createModelManager(unboxedObject);
            }
            this.evaluationEnvironment = evaluationEnvironment2 = this.environmentFactory.createEvaluationEnvironment(this.query, modelManager2);
        }
        return evaluationEnvironment2;
    }

    @Override
    public @NonNull OCLExpression getExpression() {
        return this.expression;
    }

    @Override
    public @NonNull OCL getOCL() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Diagnostic getProblems() {
        return this.evalProblems;
    }

    private void handleNextEvaluateProblems() {
        Diagnostic nextEvalProblems = this.getProblems();
        if (nextEvalProblems != null) {
            if (this.batchEvalProblems == null) {
                BasicDiagnostic rootDiagnostic;
                this.batchEvalProblems = rootDiagnostic = new BasicDiagnostic(nextEvalProblems.getSeverity(), "org.eclipse.ocl.pivot", nextEvalProblems.getCode(), nextEvalProblems.getMessage(), null);
            }
            this.batchEvalProblems.add(nextEvalProblems);
        }
    }

    @Override
    public String queryText() {
        return this.expression.toString();
    }

    @Override
    public <T> @NonNull List<T> rejectEcore(@NonNull Iterable<T> ecoreObjects) {
        BasicEList result = new BasicEList();
        try {
            for (T ecoreObject : ecoreObjects) {
                if (!this.checkEcore(ecoreObject)) {
                    result.add(ecoreObject);
                }
                this.handleNextEvaluateProblems();
            }
        }
        finally {
            this.commitBatchEvaluateProblems();
        }
        return result;
    }

    @Override
    public Type resultType() {
        return this.expression.getType();
    }

    @Override
    public <T> @NonNull List<T> selectEcore(@NonNull Iterable<T> ecoreObjects) {
        BasicEList result = new BasicEList();
        try {
            for (T ecoreObject : ecoreObjects) {
                if (this.checkEcore(ecoreObject)) {
                    result.add(ecoreObject);
                }
                this.handleNextEvaluateProblems();
            }
        }
        finally {
            this.commitBatchEvaluateProblems();
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Query[");
        result.append(this.queryText());
        result.append(']');
        return result.toString();
    }
}

