/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.standalone;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.export.HTMLExporter;
import org.eclipse.ocl.examples.emf.validation.validity.export.TextExporter;
import org.eclipse.ocl.examples.standalone.HelpCommand;
import org.eclipse.ocl.examples.standalone.StandaloneApplication;
import org.eclipse.ocl.examples.standalone.StandaloneCommand;
import org.eclipse.ocl.examples.standalone.StandaloneCommandAnalyzer;
import org.eclipse.ocl.examples.standalone.validity.ValidateCommand;
import org.eclipse.ocl.examples.test.standalone.StandaloneTestCase;
import org.eclipse.ocl.examples.xtext.tests.TestCaseLogger;
import org.junit.Test;

public class StandaloneParserTests
extends StandaloneTestCase {
    private StandaloneCommandAnalyzer commandAnalyzer = new StandaloneCommandAnalyzer(new StandaloneApplication());

    protected static void assertCommandInvalid(@NonNull StandaloneCommand command, @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
    StandaloneCommand.CommandToken, List<String>> token2strings) {
        boolean status = command.check(token2strings);
        StandaloneParserTests.assertFalse((boolean)status);
    }

    protected static void assertCommandValid(@NonNull StandaloneCommand command, @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
    StandaloneCommand.CommandToken, List<String>> token2strings) {
        boolean status = command.check(token2strings);
        StandaloneParserTests.assertTrue((boolean)status);
    }

    protected List<String> normalize(List<String> strings) throws IOException {
        ArrayList<String> normalized = new ArrayList<String>(strings.size());
        for (String string : strings) {
            normalized.add(this.normalize(string));
        }
        return normalized;
    }

    protected String normalize(String string) throws IOException {
        try {
            return new File(string).getCanonicalPath();
        }
        catch (Exception e) {
            return string;
        }
    }

    protected <T extends StandaloneCommand> @NonNull T parseCommand(@NonNull Class<T> commandClass, @NonNull String @NonNull [] arguments) {
        StandaloneCommand command = this.commandAnalyzer.parse(arguments);
        assert (command != null);
        StandaloneParserTests.assertEquals(commandClass, command.getClass());
        return (T)command;
    }

    protected void parseInvalidArguments(@NonNull StandaloneCommand command, @NonNull String @NonNull [] arguments) {
        Map token2strings = command.parse(arguments);
        StandaloneParserTests.assertNull((Object)token2strings);
    }

    protected @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
    StandaloneCommand.CommandToken, List<String>> parseValidArguments(@NonNull StandaloneCommand command, @NonNull String @NonNull [] arguments) {
        Map token2strings = command.parse(arguments);
        StandaloneParserTests.assertNotNull((Object)token2strings);
        assert (token2strings != null);
        return token2strings;
    }

    @Test
    public void test_help() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"help"};
        HelpCommand command = this.parseCommand(HelpCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertEquals((int)0, (int)token2strings.size());
    }

    @Test
    public void test_help_extraText() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"help", "yy"};
            HelpCommand command = this.parseCommand(HelpCommand.class, arguments);
            this.parseInvalidArguments((StandaloneCommand)command, arguments);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("Bad help command"));
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void test_mandatoryArguments() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI)};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals(null, (Object)command.exporterToken.getExporter(token2strings));
        StandaloneParserTests.assertEquals((String)String.valueOf(this.inputModelURI), (String)command.modelToken.getModelFileName(token2strings));
        StandaloneParserTests.assertEquals(null, (Object)command.outputToken.getOutputFile(token2strings));
        StandaloneParserTests.assertEquals(this.normalize(Lists.newArrayList((Object[])new String[]{String.valueOf(this.inputOCLURI)})), this.normalize(command.rulesToken.getOCLFileNames(token2strings)));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_missingOutputArgument() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output"};
            ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
            this.parseInvalidArguments((StandaloneCommand)command, arguments);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("Missing argument for"));
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("-output"));
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void test_missingExporterArgument() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-exporter"};
            ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
            this.parseInvalidArguments((StandaloneCommand)command, arguments);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("Missing argument for"));
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("-exporter"));
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void test_missingUsingArgument() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-using"};
            ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
            this.parseInvalidArguments((StandaloneCommand)command, arguments);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("No argument for"));
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("-using"));
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void test_textExportedFile() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertTrue((boolean)(command.exporterToken.getExporter(token2strings) instanceof TextExporter));
        StandaloneParserTests.assertEquals((String)String.valueOf(this.inputModelURI), (String)command.modelToken.getModelFileName(token2strings));
        StandaloneParserTests.assertEquals((String)this.normalize(this.getTextLogFileName()), (String)this.normalize(command.outputToken.getOutputFile(token2strings).toString()));
        StandaloneParserTests.assertEquals(this.normalize(Lists.newArrayList((Object[])new String[]{String.valueOf(this.inputOCLURI)})), (Object)Lists.newArrayList((Object[])new String[]{this.normalize((String)command.rulesToken.getOCLFileNames(token2strings).get(0))}));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_htmlExportedFile() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getHTMLLogFileName(), "-exporter", "html"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertTrue((boolean)(command.exporterToken.getExporter(token2strings) instanceof HTMLExporter));
        StandaloneParserTests.assertEquals((String)String.valueOf(this.inputModelURI), (String)command.modelToken.getModelFileName(token2strings));
        StandaloneParserTests.assertEquals((String)this.normalize(this.getHTMLLogFileName()), (String)this.normalize(command.outputToken.getOutputFile(token2strings).toString()));
        StandaloneParserTests.assertEquals(this.normalize(Lists.newArrayList((Object[])new String[]{String.valueOf(this.inputOCLURI)})), this.normalize(command.rulesToken.getOCLFileNames(token2strings)));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_unknownExporter() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "anotherExporterAttribute"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandInvalid((StandaloneCommand)command, token2strings);
    }

    @Test
    public void test_nonExistentModel() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(StandaloneParserTests.getTestModelURI("models/nonExistent.ecore")), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text"};
            ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
            Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
            StandaloneParserTests.assertCommandInvalid((StandaloneCommand)command, token2strings);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("does not exist"));
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void test_nonExistentOclFile() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(StandaloneParserTests.getTestModelURI("models/nonExistent.ocl")), "-output", this.getTextLogFileName(), "-exporter", "text"};
            ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
            Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
            StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("does not exist"));
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("ignored"));
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void test_nonExistentOutputFolder() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", "nonExistentFolder/log.file", "-exporter", "text"};
            ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
            Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
            StandaloneParserTests.assertCommandInvalid((StandaloneCommand)command, token2strings);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneParserTests.assertTrue((boolean)logMessage.contains("does not exist"));
        }
        finally {
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void test_textOCLFiles() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.textInputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertTrue((boolean)(command.exporterToken.getExporter(token2strings) instanceof TextExporter));
        StandaloneParserTests.assertEquals((String)String.valueOf(this.inputModelURI), (String)command.modelToken.getModelFileName(token2strings));
        StandaloneParserTests.assertEquals((String)this.normalize(this.getTextLogFileName()), (String)this.normalize(command.outputToken.getOutputFile(token2strings).toString()));
        StandaloneParserTests.assertEquals(this.normalize(Lists.newArrayList((Object[])new String[]{String.valueOf(this.inputOCLURI), String.valueOf(this.inputOCLURI2)})), this.normalize(command.rulesToken.getOCLFileNames(token2strings)));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_usingAllLocators() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "all"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_usingOCLLocator() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "ocl"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_usingJavaLocator() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "java"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_usingUMLLocator() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "uml"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_usingOCLUMLLocators() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "ocl,uml"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_usingOCLJavaLocators() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "ocl,java"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_usingJavaUmlLocators() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "uml,java"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_usingOCLJavaUmlLocators() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "ocl,uml,java"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }
}

