/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import java.util.Iterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.tests.PivotTestSuite;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.pivot.AnyType;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.InheritanceFragment;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.SetType;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.library.RegisteredContribution;
import org.eclipse.ocl.pivot.internal.library.StandardLibraryContribution;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.junit.After;
import org.junit.Before;

public class InheritanceTests
extends PivotTestSuite {
    public InheritanceTests() {
        super(false);
    }

    @Override
    protected @NonNull TestOCL createOCL() {
        return new TestOCL(this.getTestFileSystem(), this.getTestPackageName(), this.getName(), (ProjectManager)(useCodeGen ? InheritanceTests.getProjectMap() : OCL.NO_PROJECTS));
    }

    public @NonNull String installLibraryClone() {
        final String libraryClone = "http://www.eclipse.org/ocl/2015/LibraryClone";
        OCLstdlib.Loader mutableLibrary = new OCLstdlib.Loader(){

            public @NonNull Resource getResource() {
                return OCLstdlib.create((String)(String.valueOf(libraryClone) + "oclas"));
            }
        };
        StandardLibraryContribution.REGISTRY.put(libraryClone, (RegisteredContribution)mutableLibrary);
        return libraryClone;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void test_Inheritance_Boolean() {
        TestOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        try {
            CompleteInheritance oclAnyInheritance = standardLibrary.getInheritance((Class)standardLibrary.getOclAnyType());
            PrimitiveType booleanType = standardLibrary.getBooleanType();
            CompleteInheritance booleanInheritance = standardLibrary.getInheritance((Class)booleanType);
            assert (booleanInheritance.getDepth() == 1);
            Iterator allSuperInheritances = booleanInheritance.getAllSuperFragments().iterator();
            assert (((InheritanceFragment)allSuperInheritances.next()).getBaseInheritance() == oclAnyInheritance);
            assert (((InheritanceFragment)allSuperInheritances.next()).getBaseInheritance() == booleanInheritance);
            assert (!allSuperInheritances.hasNext());
            Iterator depth0Inheritances = booleanInheritance.getSuperFragments(0).iterator();
            assert (((InheritanceFragment)depth0Inheritances.next()).getBaseInheritance() == oclAnyInheritance);
            assert (!depth0Inheritances.hasNext());
            Iterator depth1Inheritances = booleanInheritance.getSuperFragments(1).iterator();
            assert (((InheritanceFragment)depth1Inheritances.next()).getBaseInheritance() == booleanInheritance);
            assert (!depth1Inheritances.hasNext());
        }
        finally {
            ocl.dispose();
        }
    }

    public void test_Inheritance_OclAny() {
        TestOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        try {
            AnyType oclAnyType = standardLibrary.getOclAnyType();
            CompleteInheritance oclAnyInheritance = standardLibrary.getInheritance((Class)oclAnyType);
            assert (oclAnyInheritance.getDepth() == 0);
            Iterator allSuperInheritances = oclAnyInheritance.getAllSuperFragments().iterator();
            assert (((InheritanceFragment)allSuperInheritances.next()).getBaseInheritance() == oclAnyInheritance);
            assert (!allSuperInheritances.hasNext());
            Iterator depth0Inheritances = oclAnyInheritance.getSuperFragments(0).iterator();
            assert (((InheritanceFragment)depth0Inheritances.next()).getBaseInheritance() == oclAnyInheritance);
            assert (!depth0Inheritances.hasNext());
        }
        finally {
            ocl.dispose();
        }
    }

    public void test_Inheritance_Set() {
        TestOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        try {
            CompleteInheritance oclAnyInheritance = standardLibrary.getInheritance((Class)standardLibrary.getOclAnyType());
            SetType setType = standardLibrary.getSetType();
            CompleteInheritance setInheritance = standardLibrary.getInheritance((Class)setType);
            assert (setInheritance.getDepth() == 3);
            Iterator allSuperInheritances = setInheritance.getAllSuperFragments().iterator();
            assert (((InheritanceFragment)allSuperInheritances.next()).getBaseInheritance() == oclAnyInheritance);
            CompleteInheritance next = ((InheritanceFragment)allSuperInheritances.next()).getBaseInheritance();
            while (allSuperInheritances.hasNext()) {
                next = ((InheritanceFragment)allSuperInheritances.next()).getBaseInheritance();
            }
            assert (next == setInheritance);
            assert (!allSuperInheritances.hasNext());
            Iterator depth0Inheritances = setInheritance.getSuperFragments(0).iterator();
            assert (((InheritanceFragment)depth0Inheritances.next()).getBaseInheritance() == oclAnyInheritance);
            assert (!depth0Inheritances.hasNext());
            Iterator depth3Inheritances = setInheritance.getSuperFragments(3).iterator();
            assert (((InheritanceFragment)depth3Inheritances.next()).getBaseInheritance() == setInheritance);
            assert (!depth3Inheritances.hasNext());
        }
        finally {
            ocl.dispose();
        }
    }

    public void test_Inheritance_IfExp() {
        TestOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        try {
            CompleteInheritance oclAnyInheritance = standardLibrary.getInheritance((Class)standardLibrary.getOclAnyType());
            CompleteInheritance ifInheritance = standardLibrary.getInheritance((Class)ClassUtil.nonNullState((Object)standardLibrary.getASClass("IfExp")));
            Iterator allSuperInheritances = ifInheritance.getAllSuperFragments().iterator();
            assert (((InheritanceFragment)allSuperInheritances.next()).getBaseInheritance() == oclAnyInheritance);
            CompleteInheritance next = ((InheritanceFragment)allSuperInheritances.next()).getBaseInheritance();
            while (allSuperInheritances.hasNext()) {
                next = ((InheritanceFragment)allSuperInheritances.next()).getBaseInheritance();
            }
            assert (next == ifInheritance);
            assert (!allSuperInheritances.hasNext());
            Iterator depth0Inheritances = ifInheritance.getSuperFragments(0).iterator();
            assert (((InheritanceFragment)depth0Inheritances.next()).getBaseInheritance() == oclAnyInheritance);
            assert (!depth0Inheritances.hasNext());
            Iterator depthNInheritances = ifInheritance.getSuperFragments(ifInheritance.getDepth()).iterator();
            assert (((InheritanceFragment)depthNInheritances.next()).getBaseInheritance() == ifInheritance);
            assert (!depthNInheritances.hasNext());
            assert (oclAnyInheritance.isSuperInheritanceOf(ifInheritance));
            assert (!ifInheritance.isSuperInheritanceOf(oclAnyInheritance));
            CompleteInheritance oclExpressionInheritance = standardLibrary.getInheritance((Class)ClassUtil.nonNullState((Object)standardLibrary.getASClass("OCLExpression")));
            assert (oclExpressionInheritance.isSuperInheritanceOf(ifInheritance));
            assert (!ifInheritance.isSuperInheritanceOf(oclExpressionInheritance));
            CompleteInheritance loopExpInheritance = standardLibrary.getInheritance((Class)ClassUtil.nonNullState((Object)standardLibrary.getASClass("LoopExp")));
            assert (!ifInheritance.isSuperInheritanceOf(loopExpInheritance));
            assert (!loopExpInheritance.isSuperInheritanceOf(ifInheritance));
        }
        finally {
            ocl.dispose();
        }
    }

    public void test_Inheritance_UnlimitedNatural() {
        TestOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        try {
            CompleteInheritance oclAnyInheritance = standardLibrary.getInheritance((Class)standardLibrary.getOclAnyType());
            CompleteInheritance unlimitedNaturalTypeInheritance = standardLibrary.getInheritance((Class)standardLibrary.getUnlimitedNaturalType());
            InheritanceTests.assertEquals((int)2, (int)unlimitedNaturalTypeInheritance.getDepth());
            Iterator allSuperInheritances = unlimitedNaturalTypeInheritance.getAllSuperFragments().iterator();
            InheritanceTests.assertEquals((Object)oclAnyInheritance, (Object)((InheritanceFragment)allSuperInheritances.next()).getBaseInheritance());
            Iterator depth0Inheritances = unlimitedNaturalTypeInheritance.getSuperFragments(0).iterator();
            InheritanceTests.assertEquals((Object)oclAnyInheritance, (Object)((InheritanceFragment)depth0Inheritances.next()).getBaseInheritance());
            assert (!depth0Inheritances.hasNext());
            Iterator depth2Inheritances = unlimitedNaturalTypeInheritance.getSuperFragments(2).iterator();
            InheritanceTests.assertEquals((Object)unlimitedNaturalTypeInheritance, (Object)((InheritanceFragment)depth2Inheritances.next()).getBaseInheritance());
            assert (!depth2Inheritances.hasNext());
        }
        finally {
            ocl.dispose();
        }
    }

    public void test_Inheritance_Loop() {
        TestOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        standardLibrary.setDefaultStandardLibraryURI(this.installLibraryClone());
        try {
            CompleteInheritance integerTypeInheritance = standardLibrary.getInheritance((Class)standardLibrary.getIntegerType());
            InheritanceTests.assertEquals((int)3, (int)integerTypeInheritance.getDepth());
            try {
                try {
                    standardLibrary.getOclComparableType().getSuperClasses().add(standardLibrary.getIntegerType());
                    integerTypeInheritance.getDepth();
                    InheritanceTests.fail((String)"Missing IllegalStateException");
                }
                catch (IllegalStateException illegalStateException) {
                    standardLibrary.getOclComparableType().getSuperClasses().remove(standardLibrary.getIntegerType());
                }
            }
            finally {
                standardLibrary.getOclComparableType().getSuperClasses().remove(standardLibrary.getIntegerType());
            }
        }
        finally {
            ocl.dispose();
        }
    }

    public void test_Inheritance_Addition() {
        TestOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        standardLibrary.setDefaultStandardLibraryURI(this.installLibraryClone());
        try {
            CompleteInheritance integerTypeInheritance = standardLibrary.getInheritance((Class)standardLibrary.getIntegerType());
            InheritanceTests.assertEquals((int)3, (int)integerTypeInheritance.getDepth());
            try {
                standardLibrary.getRealType().getSuperClasses().add(standardLibrary.getStringType());
                InheritanceTests.assertEquals((int)3, (int)standardLibrary.getInheritance((Class)standardLibrary.getRealType()).getDepth());
                InheritanceTests.assertEquals((int)4, (int)integerTypeInheritance.getDepth());
            }
            finally {
                standardLibrary.getRealType().getSuperClasses().remove(standardLibrary.getStringType());
            }
        }
        finally {
            ocl.dispose();
        }
    }

    public void test_Inheritance_Removal() {
        TestOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        standardLibrary.setDefaultStandardLibraryURI(this.installLibraryClone());
        try {
            CompleteInheritance integerTypeInheritance = standardLibrary.getInheritance((Class)standardLibrary.getIntegerType());
            InheritanceTests.assertEquals((int)3, (int)integerTypeInheritance.getDepth());
            try {
                standardLibrary.getRealType().getSuperClasses().clear();
                standardLibrary.getRealType().getSuperClasses().add(standardLibrary.getOclAnyType());
                InheritanceTests.assertEquals((int)2, (int)integerTypeInheritance.getDepth());
                InheritanceTests.assertEquals((int)2, (int)standardLibrary.getInheritance((Class)standardLibrary.getIntegerType()).getDepth());
                InheritanceTests.assertEquals((int)1, (int)standardLibrary.getInheritance((Class)standardLibrary.getRealType()).getDepth());
            }
            finally {
                standardLibrary.getRealType().getSuperClasses().add(standardLibrary.getOclComparableType());
                standardLibrary.getRealType().getSuperClasses().add(standardLibrary.getOclSummableType());
            }
        }
        finally {
            ocl.dispose();
        }
    }
}

