/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.AbstractModelManager;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.utilities.PivotUtil;

public abstract class LazyModelManager
extends AbstractModelManager
implements ModelManager.ModelManagerExtension2 {
    private final @NonNull Map<@NonNull Type, @NonNull Set<@NonNull EObject>> type2instances = new HashMap<Type, Set<EObject>>();
    private final @NonNull Map<@NonNull Property, @NonNull Map<@NonNull Object, @NonNull Set<@NonNull Object>>> oppositeProperty2opposite2objects = new HashMap<Property, Map<Object, Set<Object>>>();
    private final @NonNull Collection<@NonNull EObject> roots;

    public LazyModelManager(EObject context) {
        context = EcoreUtil.getRootContainer((EObject)context);
        Resource eResource = context.eResource();
        this.roots = eResource != null ? eResource.getContents() : Collections.singleton(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull Set<@NonNull ? extends Object> get(@NonNull Class type) {
        Set<@NonNull EObject> result = this.type2instances.get(type);
        if (result == null) {
            Map<Type, Set<EObject>> map = this.type2instances;
            synchronized (map) {
                result = this.type2instances.get(type);
                if (result == null) {
                    result = new HashSet<EObject>();
                    this.type2instances.put(type, result);
                    TreeIterator iter = EcoreUtil.getAllContents(this.roots);
                    while (iter.hasNext()) {
                        EObject next = (EObject)iter.next();
                        if (next == null || !this.isInstance(type, next)) continue;
                        result.add(next);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull Iterable<@NonNull Object> getOpposite(@NonNull Property target2sourceProperty, @NonNull Object sourceObject) {
        Set<Object> objects;
        Map<@NonNull Object, @NonNull Set<@NonNull Object>> opposite2objects = this.oppositeProperty2opposite2objects.get(target2sourceProperty);
        if (opposite2objects == null) {
            Map<Property, Map<Object, Set<Object>>> map = this.oppositeProperty2opposite2objects;
            synchronized (map) {
                opposite2objects = this.oppositeProperty2opposite2objects.get(target2sourceProperty);
                if (opposite2objects == null) {
                    opposite2objects = new HashMap<Object, Set<Object>>();
                    this.oppositeProperty2opposite2objects.put(target2sourceProperty, opposite2objects);
                    Property source2targetProperty = target2sourceProperty.getOpposite();
                    if (source2targetProperty != null) {
                        Class targetClass = PivotUtil.getOwningClass(source2targetProperty);
                        EObject esProperty = source2targetProperty.getESObject();
                        EStructuralFeature eStructuralFeature = esProperty instanceof EStructuralFeature ? (EStructuralFeature)esProperty : null;
                        for (Object object : this.get(targetClass)) {
                            EStructuralFeature eFeature;
                            EClass eClass = this.eClass(object);
                            EStructuralFeature eStructuralFeature2 = eFeature = eStructuralFeature != null ? eStructuralFeature : eClass.getEStructuralFeature(source2targetProperty.getName());
                            assert (eFeature != null);
                            Object sourceCandidateOrCandidates = this.eGet(object, eFeature);
                            if (eFeature.isMany()) {
                                assert (sourceCandidateOrCandidates != null);
                                for (Object sourceCandidate : (List)sourceCandidateOrCandidates) {
                                    if (sourceCandidate == null) continue;
                                    Set<@NonNull Object> objects2 = opposite2objects.get(sourceCandidate);
                                    if (objects2 == null) {
                                        objects2 = new HashSet<Object>();
                                        opposite2objects.put(sourceCandidate, objects2);
                                    }
                                    objects2.add(object);
                                }
                                continue;
                            }
                            if (sourceCandidateOrCandidates == null) continue;
                            Set<@NonNull Object> objects3 = opposite2objects.get(sourceCandidateOrCandidates);
                            if (objects3 == null) {
                                objects3 = new HashSet<Object>();
                                opposite2objects.put(sourceCandidateOrCandidates, objects3);
                            }
                            objects3.add(object);
                        }
                    }
                }
            }
        }
        if ((objects = opposite2objects.get(sourceObject)) == null) {
            objects = Collections.emptySet();
        }
        return objects;
    }

    protected abstract boolean isInstance(@NonNull Type var1, @NonNull EObject var2);

    public String toString() {
        return this.type2instances.toString();
    }
}

