/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.kdm.source.extension.ui.adapters;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.omg.kdm.source.SourceRegion;
import org.eclipse.modisco.kdm.source.extension.ui.Activator;
import org.eclipse.modisco.kdm.source.extension.ui.interfaces.RevealingStrategy;
import org.eclipse.modisco.kdm.source.extension.ui.interfaces.SourceStrategy;
import org.eclipse.modisco.kdm.source.extension.ui.utils.Utils;

public class SourceAccessAdapter
extends AdapterImpl {
    private static final String DEBUG_ID = "org.eclipse.modisco.kdm.source.extension.ui/debug/SourceAccessAdapter/debug";
    static final boolean DEBUG = Activator.getDefault().isDebugging() && new Boolean(Platform.getDebugOption((String)"org.eclipse.modisco.kdm.source.extension.ui/debug/SourceAccessAdapter/debug")) != false;
    private SourceStrategy sourceStrategy = null;
    private RevealingStrategy revealingStrategy = null;
    private SourceRegion sourceRegion = null;

    public SourceAccessAdapter(SourceStrategy sourceStrategy, RevealingStrategy revealingStrategy, Notifier target) {
        this.sourceStrategy = sourceStrategy;
        this.revealingStrategy = revealingStrategy;
        this.target = target;
    }

    public boolean isAdapterForType(Object type) {
        return type.equals(SourceAccessAdapter.class);
    }

    public SourceStrategy getStrategySource() {
        if (DEBUG) {
            System.out.println("SourceAccessAdapter.getStrategySource()");
        }
        return this.sourceStrategy;
    }

    public RevealingStrategy getStrategyRevealing() {
        if (DEBUG) {
            System.out.println("SourceAccessAdapter.getStrategyRevealing()");
        }
        return this.revealingStrategy;
    }

    public SourceRegion getSourceRegion() {
        if (this.sourceRegion == null) {
            if (this.sourceStrategy != null) {
                return this.sourceStrategy.getASTNodeSourceRegion((EObject)this.target);
            }
            if (DEBUG) {
                System.out.println("No SourceStrategy found for this selection");
            }
        }
        return this.sourceRegion;
    }

    public void setSourceRegion(SourceRegion sourceRegion) {
        this.sourceRegion = sourceRegion;
    }

    public void revealInTextEditor() {
        if (DEBUG) {
            System.out.println("SourceAccessAdapter.showInTextEditor()");
        }
        if (this.revealingStrategy != null) {
            if (this.sourceRegion == null) {
                this.sourceRegion = this.getSourceRegion();
            }
            if (this.sourceRegion == null) {
                return;
            }
            IFile file = Utils.getIFileFromSourceRegion(this.sourceRegion);
            if (file != null) {
                if (file.exists()) {
                    this.revealingStrategy.revealInTextEditor(file, this.sourceRegion);
                } else {
                    MoDiscoLogger.logError((String)("The file: " + file.getName() + " could not be found. Please update your model"), (Plugin)Activator.getDefault());
                }
            }
        }
    }
}

