/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.common.core.internal.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmt.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.BuildPropertiesUtils;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginUtils {
    private PluginUtils() {
    }

    public static boolean isRegistered(IFile elementFile, String extensionPoint) {
        IFile file;
        IProject project = elementFile.getProject();
        String value = PluginUtils.getExtensionValue(project, extensionPoint, "file");
        return value != null && value.length() > 0 && (file = project.getFile(value)).exists() && elementFile.equals((Object)file);
    }

    public static String getExtensionValue(IProject project, String extensionPoint, String attributeName) {
        IPluginModelBase pluginModel = PluginRegistry.findModel((IProject)project);
        if (pluginModel != null) {
            IPluginExtension[] extensions;
            IPluginExtension[] iPluginExtensionArray = extensions = pluginModel.getExtensions().getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginExtension pluginExtension = iPluginExtensionArray[n2];
                if (extensionPoint.equals(pluginExtension.getPoint())) {
                    IPluginObject[] children;
                    IPluginObject[] iPluginObjectArray = children = pluginExtension.getChildren();
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPluginObject child = iPluginObjectArray[n4];
                        if (child instanceof IPluginElement) {
                            IPluginAttribute[] attributes;
                            IPluginElement pluginElement = (IPluginElement)child;
                            IPluginAttribute[] iPluginAttributeArray = attributes = pluginElement.getAttributes();
                            int n5 = attributes.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IPluginAttribute pluginAttribute = iPluginAttributeArray[n6];
                                if (attributeName.equalsIgnoreCase(pluginAttribute.getName())) {
                                    String value = pluginAttribute.getValue();
                                    return value;
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public static void register(IFile file, String extensionPointId, String elementName) {
        if (PluginUtils.isRegistered(file, extensionPointId)) {
            return;
        }
        IPath filePath = file.getFullPath().removeFirstSegments(1);
        IProject project = file.getProject();
        PluginUtils.registerInPluginXML(project, extensionPointId, elementName, new String[]{"file"}, new String[]{filePath.toString()});
    }

    public static void registerInPluginXML(IProject project, String extensionPointId, String elementName, String[] attributes, String[] values) {
        if (attributes.length != values.length) {
            throw new IllegalArgumentException("mismatching arrays");
        }
        IFile pluginXML = project.getFile("plugin.xml");
        if (pluginXML.exists()) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.parse(pluginXML.getLocation().toOSString());
                Element root = doc.getDocumentElement();
                Text whitespace = doc.createTextNode("   ");
                root.appendChild(whitespace);
                Element extensionNode = doc.createElement("extension");
                Attr pointAttr = doc.createAttribute("point");
                pointAttr.setValue(extensionPointId);
                extensionNode.getAttributes().setNamedItem(pointAttr);
                root.appendChild(extensionNode);
                Element elementNode = doc.createElement(elementName);
                int i = 0;
                while (i < attributes.length) {
                    Attr attr = doc.createAttribute(attributes[i]);
                    attr.setValue(values[i]);
                    elementNode.getAttributes().setNamedItem(attr);
                    ++i;
                }
                extensionNode.appendChild(elementNode);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                transformerFactory.setAttribute("indent-number", 3);
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                StreamResult result = new StreamResult(new StringWriter());
                DOMSource source = new DOMSource(doc);
                transformer.transform(source, result);
                String xmlString = result.getWriter().toString();
                byte[] byteArray = xmlString.getBytes("UTF-8");
                pluginXML.setContents((InputStream)new ByteArrayInputStream(byteArray), true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                MoDiscoLogger.logError(e, (Plugin)CommonModiscoActivator.getDefault());
            }
        } else {
            try {
                StringBuilder builder = new StringBuilder();
                builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                builder.append("<?eclipse version=\"3.4\"?>\n");
                builder.append("<plugin>\n");
                builder.append("   <extension point=\"").append(extensionPointId).append("\">\n");
                builder.append("      <").append(elementName);
                int i = 0;
                while (i < attributes.length) {
                    builder.append(" ");
                    builder.append(attributes[i]).append("=\"").append(values[i]).append("\"");
                    ++i;
                }
                builder.append("/>\n");
                builder.append("   </extension>\n");
                builder.append("</plugin>\n");
                byte[] byteArray = builder.toString().getBytes("UTF-8");
                pluginXML.create((InputStream)new ByteArrayInputStream(byteArray), true, (IProgressMonitor)new NullProgressMonitor());
                try {
                    BuildPropertiesUtils.addToBuild(pluginXML);
                }
                catch (Exception e) {
                    MoDiscoLogger.logError(e, "Error adding file " + pluginXML.getFullPath() + " to the build.properties", null);
                }
            }
            catch (Exception e) {
                MoDiscoLogger.logError(e, (Plugin)CommonModiscoActivator.getDefault());
            }
        }
    }

    public static void addRequiredBundles(IProject project, List<String> requiredBundles) {
        final ArrayList<String> missingRequiredBundles = new ArrayList<String>();
        missingRequiredBundles.addAll(requiredBundles);
        PluginUtils.modifyManifest(project, new ManifestModificationOperation(){

            public void modifyManifest(Manifest manifest) {
                try {
                    String requires = manifest.getMainAttributes().getValue("Require-Bundle");
                    if (requires != null) {
                        ManifestElement[] manifestElements;
                        ManifestElement[] manifestElementArray = manifestElements = ManifestElement.parseHeader((String)"Require-Bundle", (String)requires);
                        int n = manifestElements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ManifestElement manifestElement = manifestElementArray[n2];
                            missingRequiredBundles.remove(manifestElement.getValue());
                            ++n2;
                        }
                    }
                    StringBuilder newRequires = new StringBuilder();
                    if (requires != null) {
                        newRequires.append(requires);
                    }
                    int i = 0;
                    while (i < missingRequiredBundles.size()) {
                        String missingRequiredBundle = (String)missingRequiredBundles.get(i);
                        if (i != 0 || requires != null) {
                            newRequires.append(",");
                        }
                        newRequires.append(missingRequiredBundle);
                        ++i;
                    }
                    manifest.getMainAttributes().putValue("Require-Bundle", newRequires.toString());
                }
                catch (Exception e) {
                    MoDiscoLogger.logError(e, (Plugin)CommonModiscoActivator.getDefault());
                }
            }
        });
    }

    public static void makeSingleton(IProject project) {
        PluginUtils.modifyManifest(project, new ManifestModificationOperation(){

            public void modifyManifest(Manifest manifest) {
                String symbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                Pattern pattern = Pattern.compile(";\\s*singleton\\s*:=\\s*true");
                if (!pattern.matcher(symbolicName).find()) {
                    manifest.getMainAttributes().putValue("Bundle-SymbolicName", String.valueOf(symbolicName) + ";singleton:=true");
                }
            }
        });
    }

    public static void modifyManifest(IProject project, ManifestModificationOperation manifestModificationOperation) {
        IFile manifestResource = (IFile)project.findMember((IPath)new Path("/META-INF/MANIFEST.MF"));
        if (manifestResource == null) {
            throw new IllegalArgumentException("Project is not a plug-in project : couldn't setup Manifest.MF because it wasn't found.");
        }
        try {
            manifestResource.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            InputStream contents = manifestResource.getContents();
            Manifest manifest = new Manifest(contents);
            manifestModificationOperation.modifyManifest(manifest);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            manifest.write(outputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            manifestResource.setContents((InputStream)byteArrayInputStream, true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            MoDiscoLogger.logError(e, (Plugin)CommonModiscoActivator.getDefault());
        }
    }

    public static interface ManifestModificationOperation {
        public void modifyManifest(Manifest var1);
    }
}

