/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual;

import prefuse.Visualization;
import prefuse.data.Graph;
import prefuse.data.Table;
import prefuse.util.collections.IntIterator;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTable;
import prefuse.visual.VisualTupleSet;

public class VisualGraph
extends Graph
implements VisualTupleSet {
    private Visualization m_vis;
    private String m_group;

    public VisualGraph(VisualTable nodes, VisualTable edges, boolean directed, String nodeKey, String sourceKey, String targetKey) {
        super(nodes, edges, directed, nodeKey, sourceKey, targetKey);
    }

    protected void fireGraphEvent(Table t, int first, int last, int col, int type) {
        if (type == 0 && col == VisualItem.IDX_VALIDATED && t == this.getNodeTable()) {
            VisualTable nodes = (VisualTable)t;
            VisualTable edges = (VisualTable)this.getEdgeTable();
            int i = first;
            while (i <= last) {
                if (!nodes.isValidated(i)) {
                    if (i < 0) {
                        System.err.println("catch me - VisualGraph fireGraphEvent");
                    }
                    IntIterator erows = this.edgeRows(i);
                    while (erows.hasNext()) {
                        int erow = erows.nextInt();
                        edges.setValidated(erow, false);
                    }
                }
                ++i;
            }
        }
        super.fireGraphEvent(t, first, last, col, type);
    }

    public int getNodeIndex(int key) {
        if (this.m_nkey == null) {
            return ((VisualTable)this.getNodeTable()).getChildRow(key);
        }
        return super.getNodeIndex(key);
    }

    public Visualization getVisualization() {
        return this.m_vis;
    }

    public void setVisualization(Visualization vis) {
        this.m_vis = vis;
    }

    public String getGroup() {
        return this.m_group;
    }

    public void setGroup(String group) {
        this.m_group = group;
    }
}

