/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import prefuse.data.Table;
import prefuse.data.io.DataIOException;
import prefuse.data.io.TableReader;
import prefuse.util.io.IOLib;

public abstract class AbstractTableReader
implements TableReader {
    public Table readTable(String location) throws DataIOException {
        try {
            InputStream is = IOLib.streamFromString(location);
            if (is == null) {
                throw new DataIOException("Couldn't find " + location + ". Not a valid file, URL, or resource locator.");
            }
            return this.readTable(is);
        }
        catch (IOException e) {
            throw new DataIOException(e);
        }
    }

    public Table readTable(URL url) throws DataIOException {
        try {
            return this.readTable(url.openStream());
        }
        catch (IOException e) {
            throw new DataIOException(e);
        }
    }

    public Table readTable(File f) throws DataIOException {
        try {
            return this.readTable(new FileInputStream(f));
        }
        catch (FileNotFoundException e) {
            throw new DataIOException(e);
        }
    }
}

