/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Date;
import java.util.concurrent.CopyOnWriteArrayList;
import prefuse.data.DataTypeException;
import prefuse.data.column.Column;
import prefuse.data.event.ColumnListener;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;
import prefuse.data.parser.ObjectParser;
import prefuse.data.parser.ParserFactory;
import prefuse.util.TypeLib;

public abstract class AbstractColumn
implements Column {
    protected final Class m_columnType;
    protected DataParser m_parser;
    protected Object m_defaultValue;
    protected boolean m_readOnly;
    protected CopyOnWriteArrayList m_listeners;

    public AbstractColumn() {
        this(Object.class, null);
    }

    public AbstractColumn(Class columnType) {
        this(columnType, null);
    }

    public AbstractColumn(Class columnType, Object defaultValue) {
        this.m_columnType = columnType;
        DataParser p = ParserFactory.getDefaultFactory().getParser(columnType);
        this.m_parser = p == null ? new ObjectParser() : p;
        this.setDefaultValue(defaultValue);
        this.m_readOnly = false;
        this.m_listeners = new CopyOnWriteArrayList();
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
    }

    public boolean isCellEditable(int row) {
        return !this.m_readOnly;
    }

    public Class getColumnType() {
        return this.m_columnType;
    }

    public DataParser getParser() {
        return this.m_parser;
    }

    public void setParser(DataParser parser) {
        if (!this.m_columnType.isAssignableFrom(parser.getType())) {
            throw new IllegalArgumentException("Parser type (" + parser.getType().getName() + ") incompatible with" + " this column's data type (" + this.m_columnType.getName() + ")");
        }
        this.m_parser = parser;
    }

    public void addColumnListener(ColumnListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeColumnListener(ColumnListener listener) {
        this.m_listeners.remove(listener);
    }

    protected final void fireColumnEvent(int type, int start, int end) {
        Object[] lstnrs = this.m_listeners.toArray();
        int i = 0;
        while (i < lstnrs.length) {
            ((ColumnListener)lstnrs[i]).columnChanged(this, type, start, end);
            ++i;
        }
    }

    protected final void fireColumnEvent(int idx, int prev) {
        Object[] lstnrs = this.m_listeners.toArray();
        int i = 0;
        while (i < lstnrs.length) {
            ((ColumnListener)lstnrs[i]).columnChanged((Column)this, idx, prev);
            ++i;
        }
    }

    protected final void fireColumnEvent(int idx, long prev) {
        Object[] lstnrs = this.m_listeners.toArray();
        int i = 0;
        while (i < lstnrs.length) {
            ((ColumnListener)lstnrs[i]).columnChanged((Column)this, idx, prev);
            ++i;
        }
    }

    protected final void fireColumnEvent(int idx, float prev) {
        Object[] lstnrs = this.m_listeners.toArray();
        int i = 0;
        while (i < lstnrs.length) {
            ((ColumnListener)lstnrs[i]).columnChanged((Column)this, idx, prev);
            ++i;
        }
    }

    protected final void fireColumnEvent(int idx, double prev) {
        Object[] lstnrs = this.m_listeners.toArray();
        int i = 0;
        while (i < lstnrs.length) {
            ((ColumnListener)lstnrs[i]).columnChanged((Column)this, idx, prev);
            ++i;
        }
    }

    protected final void fireColumnEvent(int idx, boolean prev) {
        Object[] lstnrs = this.m_listeners.toArray();
        int i = 0;
        while (i < lstnrs.length) {
            ((ColumnListener)lstnrs[i]).columnChanged((Column)this, idx, prev);
            ++i;
        }
    }

    protected final void fireColumnEvent(int idx, Object prev) {
        Object[] lstnrs = this.m_listeners.toArray();
        int i = 0;
        while (i < lstnrs.length) {
            ((ColumnListener)lstnrs[i]).columnChanged((Column)this, idx, prev);
            ++i;
        }
    }

    public Object getDefaultValue() {
        return this.m_defaultValue;
    }

    public void setDefaultValue(Object dflt) {
        boolean prim = this.m_columnType.isPrimitive();
        if (dflt != null && (!prim && !this.m_columnType.isInstance(dflt) || prim && !TypeLib.isWrapperInstance(this.m_columnType, dflt))) {
            throw new IllegalArgumentException("Default value is not of type " + this.m_columnType.getName());
        }
        this.m_defaultValue = dflt;
    }

    public void revertToDefault(int row) {
        this.set(this.m_defaultValue, row);
    }

    public boolean canGet(Class type) {
        if (type == null) {
            return false;
        }
        if (this.m_columnType.isPrimitive()) {
            boolean primTypes;
            boolean bl = primTypes = type.isAssignableFrom(this.m_columnType) || TypeLib.isNumericType(this.m_columnType) && TypeLib.isNumericType(type);
            return primTypes || type.isAssignableFrom(TypeLib.getWrapperType(this.m_columnType)) || type.isAssignableFrom(String.class);
        }
        return type.isAssignableFrom(this.m_columnType);
    }

    public boolean canSet(Class type) {
        if (type == null) {
            return false;
        }
        if (this.m_columnType.isPrimitive()) {
            return this.m_columnType.isAssignableFrom(type) || TypeLib.getWrapperType(this.m_columnType).isAssignableFrom(type) || String.class.isAssignableFrom(type);
        }
        return this.m_columnType.isAssignableFrom(type);
    }

    public boolean canGetInt() {
        return this.canGet(Integer.TYPE);
    }

    public boolean canSetInt() {
        return this.canSet(Integer.TYPE);
    }

    public int getInt(int row) throws DataTypeException {
        if (this.canGetInt()) {
            return (Integer)this.get(row);
        }
        throw new DataTypeException(Integer.TYPE);
    }

    public void setInt(int val, int row) throws DataTypeException {
        if (!this.canSetInt()) {
            throw new DataTypeException(Integer.TYPE);
        }
        this.set(new Integer(val), row);
    }

    public boolean canGetLong() {
        return this.canGet(Long.TYPE);
    }

    public boolean canSetLong() {
        return this.canSet(Long.TYPE);
    }

    public long getLong(int row) throws DataTypeException {
        if (this.canGetLong()) {
            return (Long)this.get(row);
        }
        throw new DataTypeException(Long.TYPE);
    }

    public void setLong(long val, int row) throws DataTypeException {
        if (!this.canSetLong()) {
            throw new DataTypeException(Long.TYPE);
        }
        this.set(new Long(val), row);
    }

    public boolean canGetFloat() {
        return this.canGet(Float.TYPE);
    }

    public boolean canSetFloat() {
        return this.canSet(Float.TYPE);
    }

    public float getFloat(int row) throws DataTypeException {
        if (this.canGetFloat()) {
            return ((Float)this.get(row)).floatValue();
        }
        throw new DataTypeException(Float.TYPE);
    }

    public void setFloat(float val, int row) throws DataTypeException {
        if (!this.canSetFloat()) {
            throw new DataTypeException(Float.TYPE);
        }
        this.set(new Float(val), row);
    }

    public boolean canGetDouble() {
        return this.canGet(Double.TYPE);
    }

    public boolean canSetDouble() {
        return this.canSet(Double.TYPE);
    }

    public double getDouble(int row) throws DataTypeException {
        if (this.canGetDouble()) {
            return (Double)this.get(row);
        }
        throw new DataTypeException(Double.TYPE);
    }

    public void setDouble(double val, int row) throws DataTypeException {
        if (!this.canSetDouble()) {
            throw new DataTypeException(Double.TYPE);
        }
        this.set(new Double(val), row);
    }

    public boolean canGetBoolean() {
        return this.canGet(Boolean.TYPE);
    }

    public boolean canSetBoolean() {
        return this.canSet(Boolean.TYPE);
    }

    public boolean getBoolean(int row) throws DataTypeException {
        if (this.canGetBoolean()) {
            return (Boolean)this.get(row);
        }
        throw new DataTypeException(Boolean.TYPE);
    }

    public void setBoolean(boolean val, int row) throws DataTypeException {
        if (!this.canSetBoolean()) {
            throw new DataTypeException(Boolean.TYPE);
        }
        this.set(new Boolean(val), row);
    }

    public boolean canGetString() {
        return true;
    }

    public boolean canSetString() {
        return this.m_parser != null && !(this.m_parser instanceof ObjectParser);
    }

    public String getString(int row) throws DataTypeException {
        if (this.canGetString()) {
            return this.m_parser.format(this.get(row));
        }
        throw new DataTypeException(String.class);
    }

    public void setString(String val, int row) throws DataTypeException {
        try {
            this.set(this.m_parser.parse(val), row);
        }
        catch (DataParseException e) {
            throw new DataTypeException(e);
        }
    }

    public boolean canGetDate() {
        return this.canGet(Date.class);
    }

    public boolean canSetDate() {
        return this.canSet(Date.class);
    }

    public Date getDate(int row) throws DataTypeException {
        if (this.canGetDate()) {
            return (Date)this.get(row);
        }
        throw new DataTypeException(Date.class);
    }

    public void setDate(Date val, int row) throws DataTypeException {
        this.set(val, row);
    }
}

