/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.benchmark.ui.util;

import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererDescription;
import org.eclipse.modisco.infra.discovery.core.IDiscoveryManager;
import org.eclipse.modisco.infra.discovery.ui.Activator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class DiscovererSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "DiscovererSelectionDialogSettings";

    public DiscovererSelectionDialog(Shell shell, boolean multi) {
        super(shell, multi);
        this.setTitle("Select the discoverers");
        this.setSelectionHistory(new ResourceSelectionHistory());
    }

    public DiscovererSelectionDialog(Shell shell) {
        super(shell, true);
        this.setTitle("Select the discoverers");
        this.setSelectionHistory(new ResourceSelectionHistory());
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected IStatus validateItem(Object item) {
        if (((DiscovererDescription)item).getSourceType() == IProject.class) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredItemsSelectionDialog.ItemsFilter(this){

            public boolean matchItem(Object item) {
                return this.matches(((DiscovererDescription)item).getId());
            }

            public boolean isConsistentItem(Object item) {
                return true;
            }
        };
    }

    protected Comparator getItemsComparator() {
        return null;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        progressMonitor.beginTask("Searching", IDiscoveryManager.INSTANCE.getDiscoverers().size());
        Iterator iter = IDiscoveryManager.INSTANCE.getDiscoverers().iterator();
        while (iter.hasNext()) {
            contentProvider.add(iter.next(), itemsFilter);
            progressMonitor.worked(1);
        }
        progressMonitor.done();
    }

    public String getElementName(Object item) {
        return ((DiscovererDescription)item).getId();
    }

    private class ResourceSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private ResourceSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento memento) {
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
        }
    }
}

