/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.emf.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.typesystem.emf.ui.BuildJob;
import org.eclipse.xtend.typesystem.emf.ui.Messages;
import org.eclipse.xtend.typesystem.emf.ui.ProjectAnalyzer;
import org.eclipse.xtend.typesystem.emf.ui.internal.EmfToolsLog;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmfToolsPlugin
extends AbstractUIPlugin {
    private static EmfToolsPlugin plugin;
    private final Map<IJavaProject, ProjectAnalyzer> projectAnalyzerCache = new HashMap<IJavaProject, ProjectAnalyzer>();
    public static boolean trace;
    private final IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                if (event.getDelta() == null) {
                    return;
                }
                final HashSet changedProjects = new HashSet();
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if ((EmfToolsPlugin.this.isEcoreFile(delta.getResource()) || EmfToolsPlugin.this.isJarFile(delta.getResource())) && JavaCore.create((IProject)delta.getResource().getProject()).isOnClasspath(delta.getResource())) {
                            changedProjects.add(delta.getResource().getProject());
                        }
                        return true;
                    }
                });
                EmfToolsPlugin.this.analyzeAndRebuildProjects(changedProjects);
            }
            catch (CoreException e) {
                EmfToolsLog.logError(e);
            }
        }
    };
    private final IElementChangedListener classpathListener = new IElementChangedListener(){

        public void elementChanged(ElementChangedEvent event) {
            HashSet<IProject> projects = new HashSet<IProject>();
            this.collectChangedProjects(event.getDelta(), projects);
            EmfToolsPlugin.this.analyzeAndRebuildProjects(projects);
        }

        private void collectChangedProjects(IJavaElementDelta delta, Set<IProject> projects) {
            IJavaProject javaProject;
            if (((delta.getFlags() & 0x40) != 0 || (delta.getFlags() & 0x80) != 0 || (delta.getFlags() & 0x20000) != 0) && (javaProject = delta.getElement().getJavaProject()) != null) {
                projects.add(javaProject.getProject());
            }
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta d = iJavaElementDeltaArray[n2];
                this.collectChangedProjects(d, projects);
                ++n2;
            }
        }
    };

    static {
        trace = false;
        String value = Platform.getDebugOption((String)"org.eclipse.internal.xtend.emftools/trace");
        if (value != null && value.equals("true")) {
            trace = true;
        }
    }

    public ProjectAnalyzer getProjectAnalyzer(IProject p) {
        IJavaProject jp = JavaCore.create((IProject)p);
        if (jp == null || !jp.exists()) {
            return null;
        }
        ProjectAnalyzer analyzer = this.projectAnalyzerCache.get(jp);
        if (analyzer == null) {
            analyzer = new ProjectAnalyzer(jp);
            this.projectAnalyzerCache.put(jp, analyzer);
        }
        return analyzer;
    }

    public EmfToolsPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        new Job(Messages.EmfToolsPlugin_2){
            {
                this.setSystem(true);
                this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            }

            protected IStatus run(IProgressMonitor monitor) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject[] iProjectArray = workspace.getRoot().getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ProjectAnalyzer pa;
                    IProject p = iProjectArray[n2];
                    if (Activator.getExtXptModelManager().findProject((IResource)p) != null && (pa = EmfToolsPlugin.this.getProjectAnalyzer(p)) != null && pa.getState() != 2) {
                        pa.schedule();
                    }
                    ++n2;
                }
                workspace.addResourceChangeListener(EmfToolsPlugin.this.resourceListener);
                JavaCore.addElementChangedListener((IElementChangedListener)EmfToolsPlugin.this.classpathListener);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        JavaCore.removeElementChangedListener((IElementChangedListener)this.classpathListener);
        this.projectAnalyzerCache.clear();
    }

    public EPackage[] getMetamodelsForProject(IJavaProject project) {
        HashSet<String> visited = new HashSet<String>();
        return this.getMetamodelsForProjectInternal(project, visited);
    }

    private EPackage[] getMetamodelsForProjectInternal(IJavaProject project, Set<String> visited) {
        if (visited.contains(project.getProject().getName())) {
            return new EPackage[0];
        }
        visited.add(project.getProject().getName());
        ProjectAnalyzer projectAnalyzer = this.getProjectAnalyzer(project.getProject());
        if (projectAnalyzer == null) {
            return new EPackage[0];
        }
        try {
            Job.getJobManager().join((Object)"Xtend/Xpand Build", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (OperationCanceledException e) {
            EmfToolsLog.logError(e);
        }
        catch (InterruptedException e) {
            EmfToolsLog.logError(e);
        }
        HashMap<String, EPackage> packages = new HashMap<String, EPackage>(projectAnalyzer.getNamedEPackageMap());
        try {
            IProject[] iProjectArray = project.getProject().getReferencedProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                EPackage[] ps;
                IProject p = iProjectArray[n2];
                IJavaProject jp = JavaCore.create((IProject)p);
                EPackage[] ePackageArray = ps = this.getMetamodelsForProjectInternal(jp, visited);
                int n3 = ps.length;
                int n4 = 0;
                while (n4 < n3) {
                    EPackage package1 = ePackageArray[n4];
                    if (!packages.containsKey(package1.getNsURI())) {
                        packages.put(package1.getNsURI(), package1);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            EmfToolsLog.logError(e);
        }
        return packages.values().toArray(new EPackage[packages.values().size()]);
    }

    public static EmfToolsPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)EmfToolsPlugin.getId(), (String)path);
    }

    public static String getId() {
        return EmfToolsPlugin.getDefault().getBundle().getSymbolicName();
    }

    protected boolean isEcoreFile(IResource f) {
        return f instanceof IFile && !f.isDerived() && "ecore".equalsIgnoreCase(f.getFileExtension());
    }

    protected boolean isJarFile(IResource f) {
        return f instanceof IFile && !f.isDerived() && "jar".equalsIgnoreCase(f.getFileExtension());
    }

    private void collectReferencingExtXptProjects(IProject project, Map<String, IProject> referencingProjects, Set<String> visited) {
        if (visited.contains(project.getName())) {
            return;
        }
        visited.add(project.getName());
        IProject[] iProjectArray = project.getReferencingProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (Activator.getExtXptModelManager().findProject((IResource)p) != null) {
                referencingProjects.put(p.getName(), p);
            }
            this.collectReferencingExtXptProjects(p, referencingProjects, visited);
            ++n2;
        }
    }

    private void analyzeAndRebuildProjects(Set<IProject> projects) {
        HashMap<String, IProject> referencingProjects = new HashMap<String, IProject>();
        HashSet<String> visited = new HashSet<String>();
        for (IProject p : projects) {
            ProjectAnalyzer pa = this.getProjectAnalyzer(p);
            if (pa != null && pa.getState() != 2) {
                pa.schedule();
            }
            this.collectReferencingExtXptProjects(p, referencingProjects, visited);
        }
        ArrayList relevantProjects = new ArrayList(referencingProjects.values());
        relevantProjects.removeAll(projects);
        for (IProject refProject : relevantProjects) {
            new BuildJob(refProject).schedule();
        }
    }
}

