/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.xtend.middleend.LanguageContributor;

public class LanguageSetup
extends AbstractWorkflowComponent {
    private final List<String> _middleEndFactories = new ArrayList<String>();

    public void addLanguageContributor(String contributorClassName) {
        this._middleEndFactories.add(contributorClassName);
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        for (String _middleEndFactoryClassName : this._middleEndFactories) {
            try {
                Class<?> middleEndFactory = Class.forName(_middleEndFactoryClassName);
                LanguageContributor.INSTANCE.addLanguageContribution(middleEndFactory);
            }
            catch (ClassNotFoundException classNotFoundException) {
                issues.addError("The class " + _middleEndFactoryClassName + " has not been found");
            }
            catch (ClassCastException classCastException) {
                issues.addError("The class " + _middleEndFactoryClassName + " is not a language contributor");
            }
        }
    }

    public void checkConfiguration(Issues issues) {
        if (this._middleEndFactories.isEmpty()) {
            issues.addError("No LanguageContributors defined");
        }
    }
}

