/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.common;

public class QualifiedName {
    private final String _simpleName;
    private final String _nameSpace;

    public QualifiedName(String fullQualifiedName) {
        int sepPos = fullQualifiedName.lastIndexOf("::");
        if (sepPos > -1) {
            this._simpleName = fullQualifiedName.substring(sepPos + "::".length());
            this._nameSpace = fullQualifiedName.substring(0, sepPos);
        } else {
            this._simpleName = fullQualifiedName;
            this._nameSpace = null;
        }
    }

    public QualifiedName(String simpleName, String nameSpace) {
        this._simpleName = simpleName;
        this._nameSpace = nameSpace;
    }

    public String getSimpleName() {
        return this._simpleName;
    }

    public String getNameSpace() {
        return this._nameSpace;
    }

    public String getFullQualifiedName() {
        if (this._nameSpace != null) {
            return String.valueOf(this._nameSpace) + "::" + this._simpleName;
        }
        return this._simpleName;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this._nameSpace == null ? 0 : this._nameSpace.hashCode());
        result = 31 * result + (this._simpleName == null ? 0 : this._simpleName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QualifiedName other = (QualifiedName)obj;
        if (this._nameSpace == null ? other._nameSpace != null : !this._nameSpace.equals(other._nameSpace)) {
            return false;
        }
        return !(this._simpleName == null ? other._simpleName != null : !this._simpleName.equals(other._simpleName));
    }

    public String toString() {
        return this.getFullQualifiedName();
    }
}

