/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.emf;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.internal.xtend.type.baseimpl.OperationImpl;
import org.eclipse.internal.xtend.type.baseimpl.PropertyImpl;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.typesystem.AbstractTypeImpl;
import org.eclipse.xtend.typesystem.Feature;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EObjectType
extends AbstractTypeImpl {
    public EObjectType(TypeSystem ts) {
        super(ts, "emf::EObject");
    }

    public String getDocumentation() {
        return "base type for all ecore based metamodels (added by xtend's typesystem)";
    }

    public Feature[] getContributedFeatures() {
        return new Feature[]{new PropertyImpl((Type)this, "eContainer", (Type)this){

            public Object get(Object target) {
                return ((EObject)target).eContainer();
            }

            public void set(Object target, Object newValue) {
                throw new UnsupportedOperationException();
            }
        }, new PropertyImpl((Type)this, "eContents", this.getTypeSystem().getListType((Type)this)){

            public Object get(Object target) {
                return ((EObject)target).eContents();
            }

            public void set(Object target, Object newValue) {
                throw new UnsupportedOperationException();
            }
        }, new PropertyImpl((Type)this, "eRootContainer", (Type)this){

            public Object get(Object target) {
                return EcoreUtil.getRootContainer((EObject)((EObject)target));
            }

            public void set(Object target, Object newValue) {
                throw new UnsupportedOperationException();
            }
        }, new PropertyImpl((Type)this, "eAllContents", this.getTypeSystem().getSetType((Type)this)){

            public Object get(Object target) {
                HashSet allCont = new HashSet();
                TreeIterator iter = ((EObject)target).eAllContents();
                while (iter.hasNext()) {
                    allCont.add(iter.next());
                }
                return allCont;
            }

            public void set(Object target, Object newValue) {
                throw new UnsupportedOperationException();
            }
        }, new OperationImpl((Type)this, "toString", this.getTypeSystem().getSetType((Type)this), new Type[0]){

            protected Object evaluateInternal(Object target, Object[] params) {
                if (target instanceof DynamicEObjectImpl) {
                    return EObjectType.toString((EObject)target);
                }
                return target.toString();
            }
        }};
    }

    public boolean isInstance(Object o) {
        return o instanceof EObject;
    }

    public Object newInstance() {
        throw new UnsupportedOperationException("newInstance on " + this.getName());
    }

    public Set<Type> getSuperTypes() {
        return Collections.singleton(this.getTypeSystem().getObjectType());
    }

    public static StringBuffer toString(EObject x) {
        if (x == null) {
            return new StringBuffer("null");
        }
        StringBuffer buff = new StringBuffer(x.eClass().getEPackage().getName()).append("::").append(x.eClass().getName()).append("(");
        Iterator iter = x.eClass().getEAllStructuralFeatures().iterator();
        while (iter.hasNext()) {
            EStructuralFeature f = (EStructuralFeature)iter.next();
            if (f instanceof EAttribute) {
                buff.append(f.getName()).append("=").append(x.eGet(f));
            }
            if (f instanceof EReference) {
                Object o = x.eGet(f);
                if (((EReference)f).isContainment()) {
                    buff.append(f.getName()).append("=").append(EObjectType.toString(o));
                } else {
                    buff.append(f.getName()).append("=").append(EObjectType.shortString(o));
                }
            }
            if (!iter.hasNext()) continue;
            buff.append(",");
        }
        return buff.append(")");
    }

    private static StringBuffer toString(Object o) {
        if (o instanceof Collection) {
            StringBuffer buff = new StringBuffer("{");
            Iterator iter = ((Collection)o).iterator();
            while (iter.hasNext()) {
                Object x = iter.next();
                if (x instanceof EObject) {
                    buff.append(EObjectType.toString((EObject)x));
                } else {
                    buff.append("nonEMF:").append(x);
                }
                if (!iter.hasNext()) continue;
                buff.append(",");
            }
            buff.append("}");
            return buff;
        }
        if (o instanceof EObject) {
            return EObjectType.toString((EObject)o);
        }
        return new StringBuffer();
    }

    private static String shortString(Object o) {
        if (o instanceof Collection) {
            StringBuffer buff = new StringBuffer("{");
            for (Object x : (Collection)o) {
                if (!(x instanceof EObject)) continue;
                buff.append(EObjectType.shortString((EObject)x));
            }
            buff.append("}");
            return buff.toString();
        }
        if (o instanceof EObject) {
            return EObjectType.shortString((EObject)o);
        }
        return "";
    }

    public static String shortString(EObject x) {
        if (x == null) {
            return "null";
        }
        if (x.eClass().getEStructuralFeature("name") != null) {
            return x.eGet(x.eClass().getEStructuralFeature("name")) + " : " + x.eClass().getName();
        }
        return "unnamed : " + x.eClass().getName();
    }
}

