/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.ExecutionContextImpl;
import org.eclipse.xtend.expression.ExpressionFacade;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtend.typesystem.xsd.AbstractXMLWorkflowComponent;
import org.eclipse.xtend.typesystem.xsd.OawXMLResource;
import org.eclipse.xtend.typesystem.xsd.OptionsEntry;
import org.eclipse.xtend.typesystem.xsd.util.XSDLog;
import org.eclipse.xtend.typesystem.xsd.util.XSDUtil;

public class XMLWriter
extends AbstractXMLWorkflowComponent {
    private static final String COMPONENT_NAME = "XML Writer";
    protected Log log = XSDLog.getLog(((Object)((Object)this)).getClass());
    protected Map<String, Object> options = new HashMap<String, Object>();
    protected ExpressionWithVarname uriExpression;

    public void addOption(OptionsEntry entry) {
        this.options.put(entry.getKey(), entry.getValue());
    }

    public void checkConfiguration(Issues issues) {
        if (this.uri == null && this.uriExpression == null) {
            issues.addError((WorkflowComponent)this, "The output file name must be specified via 'uri' or 'uriExpression'.");
        }
        if (this.uri != null && this.uriExpression != null) {
            issues.addError((WorkflowComponent)this, "The output file name must be specified with either 'uri' or 'uriExpression', but not with both at the same time.");
        }
        if (this.uriExpression != null) {
            this.uriExpression.checkConfiguration(issues);
        }
        super.checkConfiguration(issues);
    }

    protected ExecutionContextImpl getExecutionContext(WorkflowContext ctx) {
        HashMap<String, Variable> vars = new HashMap<String, Variable>();
        String[] stringArray = ctx.getSlotNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            vars.put(s, new Variable(s, ctx.get(s)));
            ++n2;
        }
        ExecutionContextImpl ec = new ExecutionContextImpl(vars);
        for (MetaModel mm : this.getAllMetaModels()) {
            ec.registerMetaModel(mm);
        }
        return ec;
    }

    public String getLogMessage() {
        return "Writing " + (this.uri == null ? "XML files..." : this.uri.toString());
    }

    public void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        Object cnt = ctx.get(this.getModelSlot());
        if (cnt == null) {
            issues.addError((WorkflowComponent)this, "slot '" + this.getModelSlot() + "' is empty.");
            return;
        }
        if (cnt instanceof Collection) {
            if (this.uriExpression == null) {
                issues.addError((WorkflowComponent)this, "The value of slot '" + this.getModelSlot() + "' is a Collection, therefore the filename " + "must be specified using 'uriExpression'");
                return;
            }
            for (Object obj : (Collection)cnt) {
                this.save(ctx, obj, issues);
            }
        } else {
            this.save(ctx, cnt, issues);
        }
    }

    private void save(EObject obj, URI uri, Issues issues) {
        if (!(obj.eResource() instanceof OawXMLResource)) {
            if (obj.eResource() != null) {
                issues.addWarning((WorkflowComponent)this, "Overwriting resource for model in slot '" + this.getModelSlot() + "' for file '" + uri + "'");
            }
            OawXMLResource res = new OawXMLResource(uri, this.getMetaModel());
            res.getContents().add((Object)obj);
        } else {
            obj.eResource().setURI(uri);
        }
        try {
            if (this.uriExpression != null) {
                this.log.info((Object)("Writing " + uri));
            }
            obj.eResource().save(this.options);
        }
        catch (IOException e) {
            issues.addError((WorkflowComponent)this, "Error while saving XML file.", (Object)e);
        }
    }

    private void save(WorkflowContext ctx, Object obj, Issues issues) {
        if (!(obj instanceof EObject)) {
            issues.addError((WorkflowComponent)this, "slot '" + this.getModelSlot() + "' does not contain an EObject");
            return;
        }
        if (this.uriExpression != null) {
            ExecutionContextImpl ec = this.getExecutionContext(ctx);
            ec = ec.cloneWithVariable(new Variable(this.uriExpression.getVarName(), obj));
            ExpressionFacade ef = new ExpressionFacade((ExecutionContext)(ec = ec.cloneWithResource((Resource)new XMLWriterResource())));
            Object r = ef.evaluate(this.uriExpression.getExpression());
            if (!(r instanceof String)) {
                issues.addError((WorkflowComponent)this, "The expression '" + this.uriExpression + "' needs to return a string for value '" + obj + "'");
                return;
            }
            this.uri = r.toString();
        }
        this.save((EObject)obj, XSDUtil.strToURI(this.uri), issues);
    }

    public void setUriExpression(ExpressionWithVarname uriExpression) {
        this.uriExpression = uriExpression;
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public static class ExpressionWithVarname {
        private String expression;
        private Pattern EXT = Pattern.compile("([a-zA-Z0-9\\-_]+::)+");
        private ArrayList<String> extFiles = new ArrayList();
        private String varName;

        public ExpressionWithVarname() {
        }

        public ExpressionWithVarname(String varName, String expression) {
            this.varName = varName;
            this.expression = expression;
        }

        public void checkConfiguration(Issues issues) {
            if (this.varName == null || "".equals(this.varName)) {
                issues.addError("The uriExpression needs a varName");
            }
            if (this.expression == null || "".equals(this.expression)) {
                issues.addError("The uriExpression needs an expression");
            }
        }

        public String getExpression() {
            return this.expression;
        }

        public String getVarName() {
            return this.varName;
        }

        public void setExpression(String exp) {
            Matcher m = this.EXT.matcher(exp);
            while (m.find()) {
                String s = m.group(0);
                s = s.substring(0, s.length() - 2);
                this.extFiles.add(s);
            }
            this.expression = m.replaceAll("");
        }

        public void setVarName(String varName) {
            this.varName = varName;
        }
    }

    private class XMLWriterResource
    implements Resource {
        private String name = "noName";

        private XMLWriterResource() {
        }

        public String getFullyQualifiedName() {
            return this.name;
        }

        public String[] getImportedExtensions() {
            return XMLWriter.this.uriExpression.extFiles.toArray(new String[XMLWriter.this.uriExpression.extFiles.size()]);
        }

        public String[] getImportedNamespaces() {
            return new String[0];
        }

        public void setFullyQualifiedName(String fqn) {
            this.name = fqn;
        }
    }
}

