/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.uml2.profile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.internal.xtend.util.Cache;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.typesystem.AbstractTypeImpl;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtend.typesystem.Type;
import org.eclipse.xtend.typesystem.uml2.UML2MetaModelBase;
import org.eclipse.xtend.typesystem.uml2.UML2Util2;
import org.eclipse.xtend.typesystem.uml2.profile.EnumType;
import org.eclipse.xtend.typesystem.uml2.profile.MultipleStereotypeType;
import org.eclipse.xtend.typesystem.uml2.profile.StereotypeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileMetaModel
implements MetaModel {
    public Profile profile;
    private TypeSystem typeSystem;
    private InternaleProfileMetaModel internalProfileMetaModel;
    private boolean errorIfStereotypeMissing = true;
    private final Set<String> namespaces = new TreeSet<String>();
    private Map<String, Type> stereoTypes = null;

    public void setErrorIfStereotypeMissing(boolean errorIfStereotypeMissing) {
        this.errorIfStereotypeMissing = errorIfStereotypeMissing;
    }

    public ProfileMetaModel() {
    }

    public ProfileMetaModel(Profile profile) {
        assert (profile != null);
        this.profile = profile;
        this.init();
    }

    public void setProfile(String profile) {
        assert (profile != null);
        Profile p = UML2Util2.loadProfile(profile);
        if (p == null) {
            throw new ConfigurationException("Couldn't load profile from " + profile);
        }
        this.profile = p;
        this.init();
    }

    private void init() {
        if (this.stereoTypes != null || this.profile == null || this.typeSystem == null) {
            return;
        }
        this.internalProfileMetaModel = new InternaleProfileMetaModel();
        this.internalProfileMetaModel.setTypeSystem(this.typeSystem);
        this.stereoTypes = new HashMap<String, Type>();
        List<org.eclipse.uml2.uml.Type> sts = this.getAllOwnedTypes((Package)this.profile);
        for (org.eclipse.uml2.uml.Type o : sts) {
            AbstractTypeImpl t;
            String typeName;
            if (o instanceof Stereotype) {
                Stereotype st = (Stereotype)o;
                typeName = this.getFullName((org.eclipse.uml2.uml.Type)st);
                t = new StereotypeType(this.getTypeSystem(), typeName, st);
                this.stereoTypes.put(typeName, (Type)t);
                continue;
            }
            if (!(o instanceof Enumeration)) continue;
            Enumeration en = (Enumeration)o;
            typeName = this.getFullName((org.eclipse.uml2.uml.Type)en);
            t = new EnumType(this.getTypeSystem(), typeName, en);
            this.stereoTypes.put(typeName, (Type)t);
        }
        this.namespaces.add(ProfileMetaModel.normalizedName(this.profile.getName()));
    }

    private List<org.eclipse.uml2.uml.Type> getAllOwnedTypes(Package pck) {
        ArrayList<org.eclipse.uml2.uml.Type> result = new ArrayList<org.eclipse.uml2.uml.Type>();
        result.addAll((Collection<org.eclipse.uml2.uml.Type>)pck.getOwnedTypes());
        for (Package nested : pck.getNestedPackages()) {
            result.addAll(this.getAllOwnedTypes(nested));
        }
        return result;
    }

    private static String normalizedName(String name) {
        String[] fragments = name.split("::");
        StringBuffer result = new StringBuffer(name.length());
        result.append(fragments[0].replaceAll("\\W", "_"));
        int i = 1;
        while (i < fragments.length) {
            result.append("::");
            result.append(fragments[i].replaceAll("\\W", "_"));
            ++i;
        }
        return result.toString();
    }

    public String getFullName(org.eclipse.uml2.uml.Type type) {
        return ProfileMetaModel.normalizedName(type.getQualifiedName());
    }

    public Type getTypeForName(String typeName) {
        Type result = this.stereoTypes.get(typeName);
        if (result == null) {
            result = this.internalProfileMetaModel.getTypeForName(typeName);
        }
        return result;
    }

    public Type getType(Object obj) {
        if (obj instanceof Element) {
            Element element;
            EList stereotypes;
            if (obj instanceof EnumerationLiteral) {
                EnumerationLiteral el = (EnumerationLiteral)obj;
                String fqn = this.getFullName((org.eclipse.uml2.uml.Type)el.getEnumeration());
                Type enumType = this.getTypeSystem().getTypeForName(fqn);
                if (enumType != null) {
                    return enumType;
                }
            }
            if ((stereotypes = (element = (Element)obj).getAppliedStereotypes()).isEmpty()) {
                if (this.errorIfStereotypeMissing && !stereotypes.toString().equals("[]")) {
                    throw new RuntimeException("Stereotype could not be loaded! Possible hint: '" + stereotypes);
                }
                return this.internalProfileMetaModel.getType(obj);
            }
            ArrayList<StereotypeType> types = new ArrayList<StereotypeType>(stereotypes.size());
            for (Stereotype st : stereotypes) {
                Type theType = this.getTypeSystem().getTypeForName(this.getFullName((org.eclipse.uml2.uml.Type)st));
                if (theType == null || !(theType instanceof StereotypeType)) continue;
                StereotypeType stType = (StereotypeType)theType;
                types.add(stType);
            }
            switch (types.size()) {
                case 0: {
                    return this.internalProfileMetaModel.getType(obj);
                }
                case 1: {
                    return (Type)types.get(0);
                }
            }
            return new MultipleStereotypeType(this.getTypeSystem(), types);
        }
        return this.internalProfileMetaModel.getType(obj);
    }

    public Set<Type> getKnownTypes() {
        return new HashSet<Type>(this.stereoTypes.values());
    }

    public TypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    public void setTypeSystem(TypeSystem typeSystem) {
        this.typeSystem = typeSystem;
        this.init();
    }

    public String getName() {
        return this.profile.getName();
    }

    public Set<String> getNamespaces() {
        return this.namespaces;
    }

    private class InternaleProfileMetaModel
    extends UML2MetaModelBase {
        private final Cache<String, Type> typeForNameCache = new Cache<String, Type>(){

            protected Type createNew(String typeName) {
                NamedElement ele = InternaleProfileMetaModel.this.getNamedElementRec(new NamedElement[]{((InternaleProfileMetaModel)InternaleProfileMetaModel.this).ProfileMetaModel.this.profile}, typeName);
                if (ele != null) {
                    Type result = InternaleProfileMetaModel.this.getTypeForEClassifier((EClassifier)ele.eClass());
                    return result;
                }
                return null;
            }
        };

        private InternaleProfileMetaModel() {
        }

        public Type getTypeForName(String typeName) {
            Type result = (Type)this.typeForNameCache.get((Object)typeName);
            if (result == null) {
                result = super.getTypeForName(typeName);
            }
            return result;
        }

        private NamedElement getNamedElementRec(NamedElement[] elements, String name) {
            String[] frags = name.split("::");
            String firstFrag = frags[0];
            NamedElement[] namedElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                NamedElement ele = namedElementArray[n2];
                if (ele.getName() != null && ele.getName().equals(firstFrag)) {
                    if (frags.length > 1) {
                        Collection children = EcoreUtil.getObjectsByType((Collection)ele.eContents(), (EClassifier)UMLPackage.eINSTANCE.getNamedElement());
                        return this.getNamedElementRec(children.toArray(new NamedElement[children.size()]), name.substring(name.indexOf("::") + "::".length()));
                    }
                    return ele;
                }
                ++n2;
            }
            return null;
        }
    }
}

