/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.control;

import java.util.StringTokenizer;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.XPathContextExtender;
import org.eclipse.jet.internal.exceptions.MissingRequiredAttributeException;
import org.eclipse.jet.internal.exceptions.NoMatchingNodeException;
import org.eclipse.jet.taglib.AbstractEmptyTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.xpath.inspector.IElementInspector;
import org.eclipse.jet.xpath.inspector.INodeInspector;
import org.eclipse.jet.xpath.inspector.InspectorManager;

public class DumpTag
extends AbstractEmptyTag {
    private static final String NL = System.getProperty("line.separator");
    private String _select = null;
    private Object resolved_node;
    private String _format = null;
    private String _entities = null;

    public void doAction(TagInfo tagInfo, JET2Context context, JET2Writer out) throws JET2TagException {
        XPathContextExtender xpathContext = XPathContextExtender.getInstance(context);
        this._select = this.getAttribute("select");
        if (this._select == null) {
            throw new MissingRequiredAttributeException("select");
        }
        this.resolved_node = xpathContext.resolveSingle(xpathContext.currentXPathContextObject(), this._select);
        if (this.resolved_node == null) {
            throw new NoMatchingNodeException(this._select);
        }
        this._format = this.getAttribute("format");
        this._entities = this.getAttribute("entities");
        boolean format = false;
        if ("true".equalsIgnoreCase(this._format)) {
            format = true;
        }
        if ("yes".equalsIgnoreCase(this._format)) {
            format = true;
        }
        boolean entities = false;
        if ("true".equalsIgnoreCase(this._entities)) {
            entities = true;
        }
        if ("yes".equalsIgnoreCase(this._entities)) {
            entities = true;
        }
        StringBuffer buffer = new StringBuffer();
        this.dump2(this.resolved_node, format, entities, 1, context, buffer);
        out.write(buffer.toString());
    }

    private void dump2(Object node, boolean format, boolean entities, int indent, JET2Context context, StringBuffer out) {
        block13: {
            INodeInspector.NodeKind nodeKind;
            XPathContextExtender xpc;
            block15: {
                block14: {
                    block12: {
                        xpc = XPathContextExtender.getInstance(context);
                        if (node == null) {
                            return;
                        }
                        INodeInspector inspector = InspectorManager.getInstance().getInspector(node);
                        if (inspector == null) {
                            return;
                        }
                        nodeKind = inspector.getNodeKind(node);
                        if (nodeKind != INodeInspector.NodeKind.ELEMENT) break block12;
                        out.append("<");
                        String tagName = inspector.nameOf(node);
                        if (tagName == null) {
                            tagName = "???";
                        }
                        out.append(tagName);
                        Object[] attrs = xpc.resolve(node, "attribute::*");
                        int i = 0;
                        while (attrs != null && i < attrs.length) {
                            out.append(" ");
                            String attrName = xpc.resolveAsString(attrs[i], "name()");
                            if (attrName == null) {
                                attrName = "???";
                            }
                            out.append(attrName);
                            out.append("=");
                            String value = xpc.resolveAsString(attrs[i], "string()");
                            if (value == null) {
                                value = "";
                            }
                            out.append(this.useRightQuotes(value, false));
                            ++i;
                        }
                        Object[] children = xpc.resolve(node, "child::node()");
                        if (children != null && children.length > 0) {
                            out.append(">");
                            this.writeChildren(children, format, entities, indent, context, out);
                            out.append("</");
                            out.append(tagName);
                            out.append(">");
                        } else {
                            out.append("/>");
                        }
                        break block13;
                    }
                    if (nodeKind != INodeInspector.NodeKind.TEXT) break block14;
                    String value = xpc.resolveAsString(node, "string()");
                    if (value == null) {
                        value = "";
                    }
                    if (entities) {
                        value = this.insertEntitiesInContent(value);
                    }
                    out.append(value);
                    break block13;
                }
                if (nodeKind != INodeInspector.NodeKind.COMMENT) break block15;
                out.append("<!--");
                String value = xpc.resolveAsString(node, "string()");
                if (value == null) {
                    value = "";
                }
                out.append(value);
                out.append("-->");
                break block13;
            }
            if (nodeKind != INodeInspector.NodeKind.ROOT) break block13;
            Object[] children = xpc.resolve(node, "child::node()");
            if (children != null) {
                this.writeChildren(children, format, entities, 0, context, out);
            }
        }
    }

    private void writeChildren(Object[] children, boolean format, boolean entities, int indent, JET2Context context, StringBuffer out) {
        boolean textEncountered = false;
        int i = 0;
        while (i < children.length) {
            if (children[i] != null) {
                INodeInspector childInspector = InspectorManager.getInstance().getInspector(children[i]);
                boolean bl = textEncountered = textEncountered || childInspector != null && childInspector.getNodeKind(children[i]) == INodeInspector.NodeKind.TEXT;
                if (!textEncountered && format) {
                    out.append(NL);
                    this.indent(out, indent);
                }
                this.dump2(children[i], format, entities, indent + 1, context, out);
            }
            ++i;
        }
        if (!textEncountered && format) {
            out.append(NL);
            this.indent(out, indent - 1);
        }
    }

    private void indent(StringBuffer out, int indent) {
        int j = 0;
        while (j < indent) {
            out.append("    ");
            ++j;
        }
    }

    public void dump(Object node, boolean format, boolean entities, int indent, JET2Context context, JET2Writer out) {
        IElementInspector elementInspector;
        boolean written = false;
        boolean writeKids = false;
        INodeInspector inspector = InspectorManager.getInstance().getInspector(node);
        if (inspector == null) {
            return;
        }
        if (inspector.getNodeKind(node) == INodeInspector.NodeKind.ELEMENT) {
            elementInspector = (IElementInspector)inspector;
            out.write("<" + inspector.nameOf(node));
            Object[] attr = elementInspector.getAttributes(node);
            int i = 0;
            while (i < attr.length) {
                INodeInspector ei = InspectorManager.getInstance().getInspector(attr[i]);
                String key = ei.nameOf(attr[i]);
                String value = ei.stringValueOf(attr[i]);
                out.write(" " + key + "=" + this.useRightQuotes(value));
                ++i;
            }
            boolean staticEncountered = false;
            Object[] kid = elementInspector.getChildren(node);
            if (kid.length > 0) {
                out.write(">");
                int index = 0;
                while (index < kid.length) {
                    INodeInspector kidInspector = InspectorManager.getInstance().getInspector(kid[index]);
                    if (kidInspector.getNodeKind(kid[index]) == INodeInspector.NodeKind.ELEMENT) {
                        if (!staticEncountered && format) {
                            out.write(NL);
                            int i2 = 0;
                            while (i2 < indent) {
                                out.write("    ");
                                ++i2;
                            }
                            staticEncountered = false;
                        }
                    } else {
                        staticEncountered = true;
                    }
                    this.dump(kid[index], format, entities, indent + 1, context, out);
                    ++index;
                }
                if (!staticEncountered && format) {
                    out.write(NL);
                    int i3 = 1;
                    while (i3 < indent) {
                        out.write("    ");
                        ++i3;
                    }
                    staticEncountered = false;
                }
                out.write("</" + inspector.nameOf(node) + ">");
            } else {
                out.write("/>");
            }
            written = true;
        }
        if (inspector.getNodeKind(node) == INodeInspector.NodeKind.TEXT) {
            String buffer = inspector.stringValueOf(node);
            if (buffer == null) {
                buffer = "";
            }
            if (entities) {
                buffer = this.insertEntitiesInContent(buffer);
            }
            out.write(buffer);
            written = true;
        }
        if (inspector.getNodeKind(node) == INodeInspector.NodeKind.ROOT) {
            written = true;
            writeKids = true;
        }
        if (!written) {
            System.out.println("Did not write type " + inspector.getNodeKind(node));
        }
        if (writeKids) {
            elementInspector = (IElementInspector)inspector;
            Object[] kid = elementInspector.getChildren(node);
            int index = 0;
            while (index < kid.length) {
                this.dump(kid[index], format, entities, indent + 1, context, out);
                ++index;
            }
        }
    }

    private String useRightQuotes(String string) {
        return this.useRightQuotes(string, false);
    }

    private String useRightQuotes(String string, boolean entities) {
        boolean containsDoubleQuote;
        boolean bl = containsDoubleQuote = string.indexOf("\"") > -1;
        if (entities) {
            if (containsDoubleQuote) {
                return "'" + this.insertEntitiesInAttribute(string, '\'') + "'";
            }
            return "\"" + this.insertEntitiesInAttribute(string, '\"') + "\"";
        }
        if (containsDoubleQuote) {
            return "'" + string + "'";
        }
        return "\"" + string + "\"";
    }

    private String insertEntitiesInAttribute(String value, char delimiter) {
        String charsToReplace = delimiter == '\'' ? "<&'" : "<&\"";
        return this.insertEntities(value, charsToReplace);
    }

    private String insertEntitiesInContent(String text) {
        return this.insertEntities(text, "<>&'\"");
    }

    private String insertEntities(String text, String charsToReplace) {
        StringBuffer sb = new StringBuffer(text.length() * 2);
        StringTokenizer st = new StringTokenizer(text, charsToReplace, true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() == 1) {
                switch (token.charAt(0)) {
                    case '<': {
                        sb.append("&lt;");
                        break;
                    }
                    case '>': {
                        sb.append("&gt;");
                        break;
                    }
                    case '&': {
                        sb.append("&amp;");
                        break;
                    }
                    case '\'': {
                        sb.append("&apos;");
                        break;
                    }
                    case '\"': {
                        sb.append("&quot;");
                        break;
                    }
                    default: {
                        sb.append(token);
                        break;
                    }
                }
                continue;
            }
            sb.append(token);
        }
        String buffer = sb.toString();
        return buffer;
    }
}

