/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.extensionpoints;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.extensionpoints.Messages;
import org.eclipse.jet.internal.extensionpoints.StaleXPathFunctionWrapper;
import org.eclipse.jet.internal.extensionpoints.UnableToLoadXPathFunctionWrapper;
import org.eclipse.jet.internal.extensionpoints.XPathFunctionNotImplementedWrapper;
import org.eclipse.jet.internal.extensionpoints.XPathFunctionsManager;
import org.eclipse.jet.xpath.XPathFunction;
import org.eclipse.osgi.util.NLS;

public class XPathFunctionLazyLoadWrapper
implements XPathFunction {
    private final IConfigurationElement configElement;
    private final String classAttributeName;
    private final String name;

    public XPathFunctionLazyLoadWrapper(String name, IConfigurationElement configElement, String classAttributeName) {
        this.name = name;
        this.configElement = configElement;
        this.classAttributeName = classAttributeName;
    }

    public Object evaluate(List args) {
        throw new IllegalStateException();
    }

    public XPathFunction resolveFunction() {
        if (XPathFunctionsManager.DEBUG) {
            System.out.println(NLS.bind((String)"Resolving function {0}", (Object)this.name));
        }
        try {
            Object function = this.configElement.createExecutableExtension(this.classAttributeName);
            if (function instanceof XPathFunction) {
                return (XPathFunction)function;
            }
            InternalJET2Platform.log((IStatus)new Status(4, this.configElement.getContributor().getName(), NLS.bind((String)Messages.XPathFunctionLazyLoadWrapper_XPathFunctionNotImplemented, (Object)function.getClass().getName(), (Object)this.name)));
            return new XPathFunctionNotImplementedWrapper(this.name, this.configElement.getContributor().getName(), function.getClass().getName());
        }
        catch (InvalidRegistryObjectException e) {
            InternalJET2Platform.getDefault().log((Object)e);
            return new StaleXPathFunctionWrapper(this.name);
        }
        catch (CoreException e) {
            InternalJET2Platform.getDefault().log((Object)e);
            return new UnableToLoadXPathFunctionWrapper(this.name, this.configElement);
        }
    }
}

