/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.taglib.workspace;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jet.AbstractContextExtender;
import org.eclipse.jet.CoreJETException;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.workspace.IWorkspaceAction;
import org.eclipse.jet.taglib.workspace.WorkspaceContextExtender;
import org.eclipse.jet.transform.TransformContextExtender;
import org.eclipse.jet.transform.TransformContextListener;

public class WorkspaceContextExtender
extends AbstractContextExtender {
    private static final String RESOURCE_VAR_PREFIX = "org.eclipse.jet.resource.";
    public static final String VAR_RESOURCE_PARENT_PROJECT_RELATIVE_PATH = "org.eclipse.jet.resource.parent.projectRelativePath";
    public static final String VAR_RESOURCE_PARENT_FULL_PATH = "org.eclipse.jet.resource.parent.fullPath";
    public static final String VAR_RESOURCE_PARENT_RAW_LOCATION = "org.eclipse.jet.resource.parent.rawLocation";
    public static final String VAR_RESOURCE_PARENT_LOCATION = "org.eclipse.jet.resource.parent.location";
    public static final String VAR_RESOURCE_PARENT_NAME = "org.eclipse.jet.resource.parent.name";
    public static final String VAR_RESOURCE_FILE_NAME = "org.eclipse.jet.resource.fileName";
    public static final String VAR_RESOURCE_FILE_EXTENSION = "org.eclipse.jet.resource.fileExtension";
    public static final String VAR_RESOURCE_PROJECT_RELATIVE_PATH = "org.eclipse.jet.resource.projectRelativePath";
    public static final String VAR_RESOURCE_FULL_PATH = "org.eclipse.jet.resource.fullPath";
    public static final String VAR_RESOURCE_PROJECT_NAME = "org.eclipse.jet.resource.project.name";
    public static final String VAR_RAW_LOCATION = "org.eclipse.jet.resource.rawLocation";
    public static final String VAR_RESOURCE_LOCATION = "org.eclipse.jet.resource.location";
    public static final String VAR_RESOURCE_TYPE = "org.eclipse.jet.resource.type";
    public static final String VAR_RESOURCE_NAME = "org.eclipse.jet.resource.name";

    public WorkspaceContextExtender(JET2Context context) {
        super(context);
    }

    protected Object createExtendedData(JET2Context context) {
        ContextData contextData = new ContextData();
        TransformContextExtender tce = new TransformContextExtender(context);
        tce.addListener(contextData);
        return contextData;
    }

    private final ContextData getData() {
        return (ContextData)this.getExtendedData();
    }

    public void addAction(IWorkspaceAction action) {
        this.getData().workspaceActions.add(action);
    }

    public void addFinalAction(IWorkspaceAction action) {
        this.getData().finalWorkspaceActions.add(action);
    }

    public void pushContainer(IContainer container) {
        this.getData().containerStack.push(container);
    }

    public void popContainer() throws JET2TagException {
        if (this.getData().containerStack.isEmpty()) {
            throw new JET2TagException(JET2Messages.WorkspaceContextExtender_NoParent);
        }
        this.getData().containerStack.pop();
    }

    public boolean existsContainer() {
        return !this.getData().containerStack.isEmpty();
    }

    public IContainer getContainer() throws JET2TagException {
        if (this.getData().containerStack.isEmpty()) {
            throw new JET2TagException(JET2Messages.WorkspaceContextExtender_NoParent);
        }
        return (IContainer)this.getData().containerStack.peek();
    }

    public static WorkspaceContextExtender getInstance(JET2Context context) {
        return new WorkspaceContextExtender(context);
    }

    public static void loadResourceAsSource(JET2Context context, IResource resource, String resourceLoaderId, String resourceType) throws CoreJETException, IOException {
        URL url = new URL("platform:/resource" + resource.getFullPath());
        Object source = TransformContextExtender.loadModel(url, resourceLoaderId, resourceType);
        context.setSource(source);
        String name = resource.getName();
        try {
            context.setVariable(VAR_RESOURCE_NAME, (Object)name);
            context.setVariable(VAR_RESOURCE_TYPE, (Object)WorkspaceContextExtender.getResourceTypeString(resource.getType()));
            context.setVariable(VAR_RESOURCE_LOCATION, (Object)resource.getLocation().toString());
            context.setVariable(VAR_RAW_LOCATION, (Object)(resource.getRawLocation() != null ? resource.getRawLocation().toString() : resource.getLocation().toString()));
            context.setVariable(VAR_RESOURCE_PROJECT_NAME, (Object)resource.getProject().getName());
            context.setVariable(VAR_RESOURCE_FULL_PATH, (Object)resource.getFullPath().toString());
            context.setVariable(VAR_RESOURCE_PROJECT_RELATIVE_PATH, (Object)resource.getProjectRelativePath().toString());
            String fileExtension = resource.getFileExtension();
            context.setVariable(VAR_RESOURCE_FILE_EXTENSION, (Object)fileExtension);
            context.setVariable(VAR_RESOURCE_FILE_NAME, (Object)(fileExtension == null ? name : name.substring(0, name.length() - fileExtension.length() - 1)));
            switch (resource.getType()) {
                case 1: 
                case 2: {
                    context.setVariable(VAR_RESOURCE_PARENT_NAME, (Object)resource.getParent().getName());
                    context.setVariable(VAR_RESOURCE_PARENT_LOCATION, (Object)resource.getParent().getLocation().toString());
                    context.setVariable(VAR_RESOURCE_PARENT_RAW_LOCATION, (Object)(resource.getParent().getRawLocation() == null ? resource.getParent().getLocation().toString() : resource.getParent().getRawLocation().toString()));
                    context.setVariable(VAR_RESOURCE_PARENT_FULL_PATH, (Object)resource.getParent().getFullPath().toString());
                    context.setVariable(VAR_RESOURCE_PARENT_PROJECT_RELATIVE_PATH, (Object)resource.getParent().getProjectRelativePath().toString());
                    break;
                }
            }
        }
        catch (JET2TagException e) {
            InternalJET2Platform.logError("Invalid variable name", (Exception)((Object)e));
        }
    }

    private static String getResourceTypeString(int type) {
        switch (type) {
            case 1: {
                return "file";
            }
            case 2: {
                return "folder";
            }
            case 4: {
                return "project";
            }
            case 8: {
                return "root";
            }
        }
        return "unknown";
    }

    private static final class ContextData
    implements TransformContextListener {
        private final List workspaceActions = new ArrayList();
        private final Stack containerStack = new Stack();
        private final List finalWorkspaceActions = new ArrayList();

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void commit(JET2Context context, IProgressMonitor monitor) throws JET2TagException {
            int actionsToExecuteCount = this.workspaceActions.size() + this.finalWorkspaceActions.size();
            ArrayList actionsToExecute = new ArrayList(actionsToExecuteCount);
            actionsToExecute.addAll(this.workspaceActions);
            actionsToExecute.addAll(this.finalWorkspaceActions);
            TransformContextExtender tce = TransformContextExtender.getInstance(context);
            monitor.beginTask(JET2Messages.WorkspaceContextExtender_Commiting, 1 + actionsToExecuteCount);
            try {
                try {
                    monitor.subTask(JET2Messages.WorkspaceContextExtender_ConfirmingTeamAccess);
                    ArrayList filesToValidateEdit = new ArrayList(actionsToExecute.size());
                    Iterator i = actionsToExecute.iterator();
                    while (true) {
                        if (!i.hasNext()) {
                            IStatus validateOk = ResourcesPlugin.getWorkspace().validateEdit(filesToValidateEdit.toArray(new IFile[filesToValidateEdit.size()]), tce.getShellContext());
                            if (validateOk.isOK()) break;
                            throw new JET2TagException(validateOk.getMessage());
                        }
                        IWorkspaceAction action = (IWorkspaceAction)i.next();
                        Platform.run((ISafeRunnable)new ISafeRunnable(this, context, action, filesToValidateEdit){
                            final /* synthetic */ ContextData this$1;
                            private final /* synthetic */ JET2Context val$context;
                            private final /* synthetic */ IWorkspaceAction val$action;
                            private final /* synthetic */ List val$filesToValidateEdit;
                            {
                                this.this$1 = contextData;
                                this.val$context = jET2Context;
                                this.val$action = iWorkspaceAction;
                                this.val$filesToValidateEdit = list;
                            }

                            public void handleException(Throwable exception) {
                                this.val$context.logError(this.val$action.getTemplatePath(), this.val$action.getTagInfo(), null, exception);
                            }

                            public void run() throws Exception {
                                try {
                                    if (this.val$action.requiresValidateEdit()) {
                                        this.val$filesToValidateEdit.add(this.val$action.getResource());
                                    }
                                }
                                catch (JET2TagException e) {
                                    this.handleException(e);
                                }
                            }
                        });
                    }
                    monitor.worked(1);
                    monitor.subTask(JET2Messages.WorkspaceContextExtender_WritingFiles);
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(this, actionsToExecute, context){
                        final /* synthetic */ ContextData this$1;
                        private final /* synthetic */ List val$actionsToExecute;
                        private final /* synthetic */ JET2Context val$context;
                        {
                            this.this$1 = contextData;
                            this.val$actionsToExecute = list;
                            this.val$context = jET2Context;
                        }

                        /*
                         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run(IProgressMonitor submon) throws CoreException {
                            submon.beginTask(null, this.val$actionsToExecute.size());
                            try {
                                Iterator<E> i = this.val$actionsToExecute.iterator();
                                while (i.hasNext()) {
                                    IWorkspaceAction action = (IWorkspaceAction)i.next();
                                    Platform.run((ISafeRunnable)new ISafeRunnable(this, this.val$context, action, submon){
                                        final /* synthetic */ 2 this$2;
                                        private final /* synthetic */ JET2Context val$context;
                                        private final /* synthetic */ IWorkspaceAction val$action;
                                        private final /* synthetic */ IProgressMonitor val$submon;
                                        {
                                            this.this$2 = var1_1;
                                            this.val$context = jET2Context;
                                            this.val$action = iWorkspaceAction;
                                            this.val$submon = iProgressMonitor;
                                        }

                                        public void handleException(Throwable exception) {
                                            this.val$context.logError(this.val$action.getTemplatePath(), this.val$action.getTagInfo(), null, exception);
                                        }

                                        public void run() throws Exception {
                                            try {
                                                this.val$action.performAction((IProgressMonitor)new SubProgressMonitor(this.val$submon, 1));
                                            }
                                            catch (JET2TagException e) {
                                                this.handleException(e);
                                            }
                                        }
                                    });
                                    submon.worked(1);
                                }
                            }
                            catch (Throwable throwable) {
                                Object var4_5 = null;
                                submon.done();
                                throw throwable;
                            }
                            {
                                Object var4_6 = null;
                            }
                            submon.done();
                        }
                    }, (IProgressMonitor)new SubProgressMonitor(monitor, actionsToExecute.size()));
                }
                catch (CoreException e) {
                    throw new JET2TagException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var9_12 = null;
            }
            monitor.done();
        }
    }
}

