/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.jet.compiler.Comment;
import org.eclipse.jet.compiler.JET2AST;
import org.eclipse.jet.compiler.JET2CompilationUnit;
import org.eclipse.jet.compiler.JET2Declaration;
import org.eclipse.jet.compiler.JET2Directive;
import org.eclipse.jet.compiler.JET2Expression;
import org.eclipse.jet.compiler.JET2Scriptlet;
import org.eclipse.jet.compiler.TagLibraryUsageManager;
import org.eclipse.jet.compiler.TextElement;
import org.eclipse.jet.compiler.XMLBodyElement;
import org.eclipse.jet.compiler.XMLEmptyElement;
import org.eclipse.jet.internal.compiler.CommentElementDelegate;
import org.eclipse.jet.internal.compiler.DeclarationElementDelegate;
import org.eclipse.jet.internal.compiler.ErrorRedirectingCoreElementDelegate;
import org.eclipse.jet.internal.compiler.XMLElementDelegate;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.parser.JETCoreElement;
import org.eclipse.jet.internal.parser.JETMark;
import org.eclipse.jet.internal.parser.JETParseEventListener2;
import org.eclipse.jet.internal.parser.JETParser;
import org.eclipse.jet.internal.parser.JETReader;
import org.eclipse.jet.internal.parser.ParseProblemSeverity;
import org.eclipse.jet.taglib.TagDefinition;
import org.eclipse.jet.taglib.TagLibraryManager;
import org.eclipse.jet.taglib.TagLibraryReference;

class ASTCompilerParseListener
implements JETParseEventListener2 {
    private static final String ID__ATTR = "id";
    private static final String PREFIX__ATTR = "prefix";
    private static final String TAGLIB__DIRECTIVE = "taglib";
    private static final String JET__DIRECTIVE = "jet";
    private final ElementStack elementStack = new ElementStack();
    private JET2CompilationUnit compilationUnit;
    private JET2AST ast;
    private final TagLibraryUsageManager tagLibManager;
    private final JETReader reader;
    private static Set knownJETAttributes = new LinkedHashSet<String>(Arrays.asList("skeleton", "package", "imports", "class", "nlString", "startTag", "endTag", "version"));
    private static Set deprecatedJETAttributes = new LinkedHashSet<String>(Arrays.asList("skeleton", "nlString"));
    private JETParser parser;

    public ASTCompilerParseListener(JET2CompilationUnit unit, JETReader reader) {
        this(unit, reader, Collections.EMPTY_MAP);
    }

    public ASTCompilerParseListener(JET2CompilationUnit unit, JETReader reader, Map predefinedLibraryMap) {
        this.compilationUnit = unit;
        this.ast = this.compilationUnit.getAst();
        this.reader = reader;
        this.tagLibManager = new TagLibraryUsageManager(predefinedLibraryMap);
    }

    public void beginPageProcessing() {
    }

    public void handleDirective(String directive, JETMark start, JETMark stop, Map attributes) {
        JET2Directive directiveImpl = this.ast.createDirective(start.getLine(), start.getCol(), start.getCursor(), stop.getCursor() + 1, directive, attributes);
        this.compilationUnit.getInternalBodyElements().addBodyElement(directiveImpl);
        if (TAGLIB__DIRECTIVE.equalsIgnoreCase(directive)) {
            this.handleTagLibDirective(start, stop, attributes);
        } else if (JET__DIRECTIVE.equalsIgnoreCase(directive)) {
            this.handleJetDirective(start, stop, attributes);
        } else {
            this.recordProblem(ParseProblemSeverity.WARNING, 15, JET2Messages.ASTCompilerParseListener_UnsupportedDirective, new Object[]{directive}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
        }
    }

    private void handleJetDirective(JETMark start, JETMark stop, Map attributes) {
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String attrName = (String)i.next();
            if (!knownJETAttributes.contains(attrName)) {
                this.recordProblem(ParseProblemSeverity.ERROR, 6, JET2Messages.JET2Compiler_UnknownAttribute, new Object[]{attrName}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
            }
            if (!deprecatedJETAttributes.contains(attrName)) continue;
            this.recordProblem(ParseProblemSeverity.WARNING, 11, JET2Messages.JET2Compiler_DeprecatedAttribute, new Object[]{attrName}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
        }
        String pkg = (String)attributes.get("package");
        String cls = (String)attributes.get("class");
        String importStr = (String)attributes.get("imports");
        String startTag = (String)attributes.get("startTag");
        String endTag = (String)attributes.get("endTag");
        if (pkg != null) {
            this.compilationUnit.setOutputJavaPackage(pkg);
        }
        if (cls != null) {
            this.compilationUnit.setOutputJavaClassName(cls);
        }
        if (importStr != null) {
            String[] imports = importStr.split("\\s+");
            this.compilationUnit.addImports(Arrays.asList(imports));
        }
        if (startTag != null) {
            this.parser.setStartTag(startTag);
        }
        if (endTag != null) {
            this.parser.setEndTag(endTag);
        }
    }

    private void handleTagLibDirective(JETMark start, JETMark stop, Map attributes) {
        String prefix = ((String)attributes.get(PREFIX__ATTR)).trim().toLowerCase();
        String id = (String)attributes.get(ID__ATTR);
        if (id == null) {
            this.compilationUnit.createProblem(ParseProblemSeverity.ERROR, 3, JET2Messages.JET2Compiler_MissingDirectiveAttribute, new Object[]{TAGLIB__DIRECTIVE, ID__ATTR}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
        } else if (prefix == null) {
            this.compilationUnit.createProblem(ParseProblemSeverity.ERROR, 3, JET2Messages.JET2Compiler_MissingDirectiveAttribute, new Object[]{TAGLIB__DIRECTIVE, PREFIX__ATTR}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
        } else if (!this.tagLibManager.canDefinePrefix(prefix, id)) {
            this.compilationUnit.createProblem(ParseProblemSeverity.ERROR, 4, JET2Messages.JET2Compiler_PrefixAlreadyAssigned, new Object[]{prefix, this.tagLibManager.getLibraryIdFromPrefix(prefix)}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
        } else if (TagLibraryManager.getInstance().getTagLibrary(id) == null) {
            this.compilationUnit.createProblem(ParseProblemSeverity.ERROR, 5, JET2Messages.JET2Compiler_UnknownTagLibrary, new Object[]{id}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
        } else {
            this.tagLibManager.add(prefix, id);
        }
    }

    public void handleExpression(JETMark start, JETMark stop, Map attributes) {
        JET2Expression expression = this.ast.createExpression(start.getLine(), start.getCol(), start.getCursor() - 3, stop.getCursor() + 2, start.getCursor(), stop.getCursor(), this.reader.getChars(start, stop));
        if (this.elementStack.isEmpty()) {
            this.compilationUnit.getInternalBodyElements().addBodyElement(expression);
        } else {
            XMLBodyElement topElement = this.elementStack.peek();
            topElement.getInternalBodyElements().addBodyElement(expression);
        }
    }

    public void handleCharData(char[] chars) {
        TextElement text = this.ast.createTextElement(chars);
        if (this.elementStack.isEmpty()) {
            this.compilationUnit.getInternalBodyElements().addBodyElement(text);
        } else {
            XMLBodyElement topElement = this.elementStack.peek();
            topElement.getInternalBodyElements().addBodyElement(text);
        }
    }

    public void endPageProcessing() {
        while (!this.elementStack.isEmpty()) {
            XMLBodyElement element = this.elementStack.pop();
            this.compilationUnit.createProblem(ParseProblemSeverity.ERROR, 2, JET2Messages.JET2Compiler_MissingEndTag, new Object[]{element.getName()}, element.getStart(), element.getEnd(), element.getLine(), element.getColumn());
        }
    }

    public void handleScriptlet(JETMark start, JETMark stop, Map attributes) {
        JET2Scriptlet scriplet = this.ast.createScriplet(start.getLine(), start.getCol(), start.getCursor() - 3, stop.getCursor() + 2, start.getCursor(), stop.getCursor(), this.reader.getChars(start, stop));
        if (this.elementStack.isEmpty()) {
            this.compilationUnit.getInternalBodyElements().addBodyElement(scriplet);
        } else {
            XMLBodyElement topElement = this.elementStack.peek();
            topElement.getInternalBodyElements().addBodyElement(scriplet);
        }
    }

    public void handleComment(JETMark start, JETMark stop) {
        Comment comment = this.ast.createComment(start.getLine(), start.getCol(), start.getCursor() - 4, stop.getCursor() + 4, start.getCursor(), stop.getCursor(), this.reader.getChars(start, stop));
        if (this.elementStack.isEmpty()) {
            this.compilationUnit.getInternalBodyElements().addBodyElement(comment);
        } else {
            XMLBodyElement topElement = this.elementStack.peek();
            topElement.getInternalBodyElements().addBodyElement(comment);
        }
    }

    public void handleDeclaration(JETMark start, JETMark stop) {
        JET2Declaration decl = this.ast.createDeclaration(start.getLine(), start.getCol(), start.getCursor() - 3, stop.getCursor() + 2, start.getCursor(), stop.getCursor(), this.reader.getChars(start, stop));
        this.compilationUnit.getInternalBodyElements().addBodyElement(decl);
    }

    /*
     * Unable to fully structure code
     */
    public void handleXMLEndTag(String tagName, JETMark start, JETMark stop) {
        block3: {
            tagIndex = this.elementStack.findElementIndex(tagName);
            endTag = this.ast.createXMLBodyElementEnd(start.getLine(), start.getCol(), start.getCursor(), stop.getCursor(), tagName);
            if (tagIndex != -1) ** GOTO lbl8
            this.compilationUnit.createProblem(ParseProblemSeverity.ERROR, 1, JET2Messages.JET2Compiler_MissingStartTag, new Object[]{tagName}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
            break block3;
lbl-1000:
            // 1 sources

            {
                top = this.elementStack.pop();
                this.compilationUnit.createProblem(ParseProblemSeverity.ERROR, 2, JET2Messages.JET2Compiler_MissingEndTag, new Object[]{top.getName()}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
lbl8:
                // 2 sources

                ** while (!this.elementStack.isAtTop((int)tagIndex))
            }
lbl9:
            // 1 sources

            topElement = this.elementStack.pop();
            endTag.setStartTag(topElement);
            topElement.setEndTag(endTag);
        }
        if (this.elementStack.isEmpty()) {
            this.compilationUnit.getInternalBodyElements().addBodyElement(endTag);
        } else {
            topElement = this.elementStack.peek();
            topElement.getInternalBodyElements().addBodyElement(endTag);
        }
    }

    public void handleXMLEmptyTag(String tagName, JETMark start, JETMark stop, Map attributeMap) {
        TagDefinition td = this.tagLibManager.getTagDefinition(tagName);
        XMLEmptyElement decl = this.ast.createXMLEmptyElement(start.getLine(), start.getCol(), start.getCursor(), stop.getCursor(), tagName, attributeMap, td);
        if (this.elementStack.isEmpty()) {
            this.compilationUnit.getInternalBodyElements().addBodyElement(decl);
        } else {
            XMLBodyElement topElement = this.elementStack.peek();
            topElement.getInternalBodyElements().addBodyElement(decl);
        }
    }

    public void handleXMLStartTag(String tagName, JETMark start, JETMark stop, Map attributeMap) {
        TagDefinition td = this.tagLibManager.getTagDefinition(tagName);
        if (!td.isContentAllowed() && tagName.indexOf(58) == -1) {
            this.recordProblem(ParseProblemSeverity.WARNING, 17, JET2Messages.JET2Compiler_TagShouldBeEmptyFormat, new Object[]{"<" + tagName + "/>"}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
            this.handleXMLEmptyTag(tagName, start, stop, attributeMap);
        } else {
            XMLBodyElement decl = this.ast.createXMLBodyElement(start.getLine(), start.getCol(), start.getCursor(), stop.getCursor(), tagName, attributeMap, td);
            if (this.elementStack.isEmpty()) {
                this.compilationUnit.getInternalBodyElements().addBodyElement(decl);
            } else {
                XMLBodyElement topElement = this.elementStack.peek();
                topElement.getInternalBodyElements().addBodyElement(decl);
            }
            this.elementStack.push(decl);
        }
    }

    public boolean isKnownTag(String tagName) {
        return this.tagLibManager.isKnownTag(tagName);
    }

    public JET2CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public void recordProblem(ParseProblemSeverity severity, int problemId, String message, Object[] msgArgs, int start, int end, int line, int colOffset) {
        this.compilationUnit.createProblem(severity, problemId, message, msgArgs, start, end, line, colOffset);
    }

    public TagLibraryReference[] getTagLibraryReferences() {
        TagLibraryReference[] result = this.tagLibManager.getTagLibraryReferences();
        return result;
    }

    public void parse(JETReader reader) {
        JETParser.Directive directive = new JETParser.Directive();
        directive.getDirectives().add(JET__DIRECTIVE);
        directive.getDirectives().add(TAGLIB__DIRECTIVE);
        directive.getDirectives().add("include");
        directive.getDirectives().add("start");
        directive.getDirectives().add("end");
        JETCoreElement[] coreElements = new JETCoreElement[]{new ErrorRedirectingCoreElementDelegate(directive), new ErrorRedirectingCoreElementDelegate(new JETParser.Expression()), new ErrorRedirectingCoreElementDelegate(new CommentElementDelegate()), new ErrorRedirectingCoreElementDelegate(new DeclarationElementDelegate()), new ErrorRedirectingCoreElementDelegate(new JETParser.Scriptlet()), new ErrorRedirectingCoreElementDelegate(new XMLElementDelegate())};
        this.parser = new JETParser(reader, this, coreElements);
        this.beginPageProcessing();
        try {
            this.parser.parse();
        }
        catch (JETException e) {
            this.recordProblem(ParseProblemSeverity.ERROR, 9, e.getLocalizedMessage(), null, 0, 0, 1, 1);
        }
        this.endPageProcessing();
    }

    public boolean isKnownInvalidTagName(String tagName) {
        return this.tagLibManager.isKnownInvalidTagName(tagName);
    }

    private static final class ElementStack {
        private final List stack = new ArrayList();

        public void push(XMLBodyElement element) {
            this.stack.add(element);
        }

        public XMLBodyElement pop() {
            if (this.stack.size() == 0) {
                throw new IllegalStateException("stack is empty");
            }
            return (XMLBodyElement)this.stack.remove(this.stack.size() - 1);
        }

        public XMLBodyElement peek() {
            if (this.stack.size() == 0) {
                throw new IllegalStateException("stack is empty");
            }
            return (XMLBodyElement)this.stack.get(this.stack.size() - 1);
        }

        public boolean isEmpty() {
            return this.stack.size() == 0;
        }

        public int findElementIndex(String name) {
            int i = this.stack.size() - 1;
            while (i >= 0) {
                XMLBodyElement element = this.get(i);
                if (element.getName().equalsIgnoreCase(name)) {
                    return i;
                }
                --i;
            }
            return -1;
        }

        public boolean isAtTop(int index) {
            if (index < 0 || index >= this.stack.size()) {
                throw new IllegalArgumentException();
            }
            return index == this.stack.size() - 1;
        }

        public XMLBodyElement get(int index) {
            if (index < 0 || index >= this.stack.size()) {
                throw new IllegalArgumentException();
            }
            return (XMLBodyElement)this.stack.get(index);
        }
    }
}

