/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ide.ui.resources;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoProject {
    private IProject project;
    private List<IPath> sourceFolders;
    private List<URI> outputFilesWithManifest;
    private long manifestModificationStamp = -1L;

    public AcceleoProject(IProject project) {
        IClasspathEntry[] entries;
        this.project = project;
        this.sourceFolders = new ArrayList<IPath>();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            entries = javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException javaModelException) {
            entries = new IClasspathEntry[]{};
        }
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 3) {
                this.sourceFolders.add(entry.getPath());
            }
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof AcceleoProject) {
            return ((AcceleoProject)obj).project.equals((Object)this.project);
        }
        return false;
    }

    public int hashCode() {
        return this.project.getName().hashCode();
    }

    public List<IFile> getInputFiles() throws CoreException {
        ArrayList<IFile> filesInput = new ArrayList<IFile>();
        for (IPath sourceFolderPath : this.sourceFolders) {
            IFolder sourceFolder;
            if (sourceFolderPath.segmentCount() <= 1 || (sourceFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(sourceFolderPath)) == null || !sourceFolder.isAccessible()) continue;
            this.computeInputFiles(filesInput, (IContainer)sourceFolder);
        }
        return filesInput;
    }

    private void computeInputFiles(List<IFile> filesInput, IContainer container) throws CoreException {
        IResource[] children;
        if (container != null && (children = container.members()) != null) {
            int i = 0;
            while (i < children.length) {
                IResource resource = children[i];
                if (resource instanceof IFile && "mtl".equals(((IFile)resource).getFileExtension())) {
                    filesInput.add((IFile)resource);
                } else if (resource instanceof IContainer) {
                    this.computeInputFiles(filesInput, (IContainer)resource);
                }
                ++i;
            }
        }
    }

    public IPath getOutputFilePath(IFile fileAcceleo) {
        IPath filePath = fileAcceleo.getFullPath();
        IFolder folder = this.getOutputFolder(this.project);
        if (folder != null) {
            for (IPath sourcePath : this.sourceFolders) {
                if (!sourcePath.isPrefixOf(filePath)) continue;
                IPath relativePath = filePath.removeFirstSegments(sourcePath.segmentCount());
                return folder.getFullPath().append(relativePath.removeFileExtension().addFileExtension("emtl"));
            }
        }
        return null;
    }

    public IPath getInputFilePath(IPath fileEMTL) {
        IFolder folder = this.getOutputFolder(this.project);
        if (folder != null && folder.getFullPath().isPrefixOf(fileEMTL)) {
            IPath relativePath = fileEMTL.removeFileExtension().addFileExtension("mtl").removeFirstSegments(folder.getFullPath().segmentCount());
            Iterator<IPath> itSourceFolders = this.sourceFolders.iterator();
            while (itSourceFolders.hasNext()) {
                IPath sourcePath = itSourceFolders.next().append(relativePath);
                if (!ResourcesPlugin.getWorkspace().getRoot().exists(sourcePath)) continue;
                return sourcePath;
            }
        }
        return null;
    }

    public List<IPath> getResolvedClasspath() {
        IClasspathEntry[] entries;
        ArrayList<IPath> result = new ArrayList<IPath>();
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        try {
            entries = javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException javaModelException) {
            entries = new IClasspathEntry[]{};
        }
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            result.add(entry.getPath());
            ++i;
        }
        return result;
    }

    public String getPackageName(IFile fileAcceleo) {
        IPath filePath = fileAcceleo.getFullPath();
        for (IPath sourcePath : this.sourceFolders) {
            if (!sourcePath.isPrefixOf(filePath)) continue;
            StringBuffer name = new StringBuffer();
            String[] segments = filePath.removeFirstSegments(sourcePath.segmentCount()).removeLastSegments(1).segments();
            int i = 0;
            while (i < segments.length) {
                if (i > 0) {
                    name.append(".");
                }
                name.append(segments[i]);
                ++i;
            }
            return name.toString();
        }
        return "";
    }

    private IFolder getOutputFolder(IProject aProject) {
        IJavaProject javaProject = JavaCore.create((IProject)aProject);
        try {
            IFolder folder;
            IPath output = javaProject.getOutputLocation();
            if (output != null && output.segmentCount() > 1 && (folder = aProject.getWorkspace().getRoot().getFolder(output)).isAccessible()) {
                return folder;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public List<URI> getOutputFiles() {
        ArrayList<URI> outputURIs = new ArrayList<URI>();
        this.computeAccessibleOutputFilesInFolder(outputURIs, (IContainer)this.getOutputFolder(this.project));
        return outputURIs;
    }

    public List<URI> getAccessibleOutputFiles() {
        ArrayList<URI> outputURIs = new ArrayList<URI>();
        this.computeAccessibleOutputFilesInFolder(outputURIs, (IContainer)this.getOutputFolder(this.project));
        this.computeAccessibleOutputFilesWithPluginXML(outputURIs, this.project);
        this.computeAccessibleOutputFilesWithProjectDependencies(outputURIs, this.project);
        return outputURIs;
    }

    private void computeAccessibleOutputFilesInFolder(List<URI> outputURIs, IContainer folder) {
        if (folder != null) {
            try {
                IResource[] members = folder.members();
                int i = 0;
                while (i < members.length) {
                    IResource member = members[i];
                    if (member instanceof IFile) {
                        if ("emtl".equals(((IFile)member).getFileExtension())) {
                            outputURIs.add(URI.createPlatformResourceURI((String)((IFile)member).getFullPath().toString(), (boolean)false));
                        }
                    } else if (member instanceof IContainer) {
                        this.computeAccessibleOutputFilesInFolder(outputURIs, (IContainer)member);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
            }
        }
    }

    private void computeAccessibleOutputFilesWithPluginXML(List<URI> outputURIs, IProject aProject) {
        IFile manifest = aProject.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        if (this.outputFilesWithManifest == null || manifest.isAccessible() && manifest.getModificationStamp() != this.manifestModificationStamp) {
            this.outputFilesWithManifest = new ArrayList<URI>();
            this.manifestModificationStamp = manifest.getModificationStamp();
            IPluginModelBase plugin = PluginRegistry.findModel((IProject)aProject);
            if (plugin != null) {
                BundleDescription[] requiredPlugins = plugin.getBundleDescription().getResolvedRequires();
                int i = 0;
                while (i < requiredPlugins.length) {
                    String requiredSymbolicName = requiredPlugins[i].getSymbolicName();
                    IProject requiredProject = ResourcesPlugin.getWorkspace().getRoot().getProject(requiredSymbolicName);
                    if (requiredProject != null && requiredProject.isAccessible()) {
                        this.computeAccessibleOutputFilesInFolder(this.outputFilesWithManifest, (IContainer)this.getOutputFolder(requiredProject));
                    } else if (Platform.getBundle((String)requiredSymbolicName) != null) {
                        this.computeAccessibleOutputFilesWithBundle(this.outputFilesWithManifest, Platform.getBundle((String)requiredSymbolicName));
                    }
                    ++i;
                }
            }
        }
        outputURIs.addAll(this.outputFilesWithManifest);
    }

    private void computeAccessibleOutputFilesWithBundle(List<URI> outputURIs, Bundle bundle) {
        Enumeration entries = bundle.findEntries("/", "*.emtl", true);
        if (entries != null) {
            while (entries.hasMoreElements()) {
                Path path;
                URL entry = (URL)entries.nextElement();
                if (entry == null || (path = new Path(entry.getPath())).segmentCount() <= 0) continue;
                outputURIs.add(URI.createPlatformPluginURI((String)path.toString(), (boolean)false));
            }
        }
    }

    private void computeAccessibleOutputFilesWithProjectDependencies(List<URI> outputURIs, IProject aProject) {
        IClasspathEntry[] entries;
        IJavaProject javaProject = JavaCore.create((IProject)aProject);
        try {
            entries = javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException javaModelException) {
            entries = new IClasspathEntry[]{};
        }
        int i = 0;
        while (i < entries.length) {
            IProject requiredProject;
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 2 && (requiredProject = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().toString())) != null && requiredProject.exists()) {
                this.computeAccessibleOutputFilesInFolder(outputURIs, (IContainer)this.getOutputFolder(requiredProject));
            }
            ++i;
        }
    }

    public List<AcceleoProject> getRecursivelyAccessibleAcceleoProjects() {
        ArrayList<AcceleoProject> result = new ArrayList<AcceleoProject>();
        this.computeAccessibleAcceleoProjects(result, this);
        return result;
    }

    private void computeAccessibleAcceleoProjects(List<AcceleoProject> accessibleAcceleoProjects, AcceleoProject current) {
        if (!accessibleAcceleoProjects.contains(current)) {
            IClasspathEntry[] entries;
            accessibleAcceleoProjects.add(current);
            IPluginModelBase plugin = PluginRegistry.findModel((IProject)current.project);
            if (plugin != null) {
                BundleDescription[] requiredPlugins = plugin.getBundleDescription().getResolvedRequires();
                int i = 0;
                while (i < requiredPlugins.length) {
                    String requiredSymbolicName = requiredPlugins[i].getSymbolicName();
                    IProject requiredProject = ResourcesPlugin.getWorkspace().getRoot().getProject(requiredSymbolicName);
                    if (requiredProject != null && requiredProject.isAccessible()) {
                        AcceleoProject requiredAcceleoProject = new AcceleoProject(requiredProject);
                        this.computeAccessibleAcceleoProjects(accessibleAcceleoProjects, requiredAcceleoProject);
                    }
                    ++i;
                }
            }
            IJavaProject javaProject = JavaCore.create((IProject)current.project);
            try {
                entries = javaProject.getResolvedClasspath(true);
            }
            catch (JavaModelException javaModelException) {
                entries = new IClasspathEntry[]{};
            }
            int i = 0;
            while (i < entries.length) {
                IProject requiredProject;
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 2 && (requiredProject = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().toString())) != null && requiredProject.exists()) {
                    AcceleoProject requiredAcceleoProject = new AcceleoProject(requiredProject);
                    this.computeAccessibleAcceleoProjects(accessibleAcceleoProjects, requiredAcceleoProject);
                }
                ++i;
            }
        }
    }

    public ResourceSet loadAccessibleOutputFiles() {
        ResourceSetImpl oResourceSet = new ResourceSetImpl();
        List<URI> outputURIs = this.getAccessibleOutputFiles();
        for (URI oURI : outputURIs) {
            try {
                ModelUtils.load((URI)oURI, (ResourceSet)oResourceSet);
            }
            catch (IOException e) {
                AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
            }
        }
        return oResourceSet;
    }
}

