/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.taglib.workspace;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jet.BufferedJET2Writer;
import org.eclipse.jet.IWriterListener;
import org.eclipse.jet.IWriterListenerExtension;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.taglib.JET2TagException;

public final class ActionsUtil {
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final byte[] BOM_UTF_8 = new byte[]{-17, -69, -65};

    private ActionsUtil() {
    }

    public static boolean writeTextFileFromWriter(IFile file, boolean replace, String encoding, boolean derived, JET2Writer writer, IProgressMonitor monitor) throws JET2TagException {
        ActionsUtil.finalizeContent(writer, file, null);
        boolean written = ActionsUtil.writeTextFile(file, replace, encoding, derived, writer.toString(), monitor);
        if (written) {
            ActionsUtil.contentCommitted(writer, file);
        }
        return written;
    }

    private static final void finalizeContent(JET2Writer writer, Object committedObject, String existingContent) throws JET2TagException {
        IWriterListener[] eventListeners = writer.getEventListeners();
        int i = 0;
        while (i < eventListeners.length) {
            if (existingContent != null && eventListeners[i] instanceof IWriterListenerExtension) {
                ((IWriterListenerExtension)eventListeners[i]).finalizeContent(writer, committedObject, existingContent);
            } else {
                eventListeners[i].finalizeContent(writer, committedObject);
            }
            ++i;
        }
    }

    static final void contentCommitted(JET2Writer writer, Object committedObject) throws JET2TagException {
        IWriterListener[] eventListeners = writer.getEventListeners();
        int i = 0;
        while (i < eventListeners.length) {
            eventListeners[i].postCommitContent(writer, committedObject);
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeTextFile(IFile file, boolean replace, String encoding, boolean derived, String contents, IProgressMonitor monitor) throws JET2TagException {
        block17: {
            block16: {
                try {
                    try {
                        boolean requiresBOM;
                        String sourceEncoding;
                        String fileMessage = MessageFormat.format(JET2Messages.WsFileFromWriterAction_WritingFile, file.getFullPath().toString());
                        monitor.beginTask(fileMessage, 5);
                        monitor.setTaskName(fileMessage);
                        if (file.exists() && !replace) {
                            Object var13_9 = null;
                            break block16;
                        }
                        if (!file.exists()) {
                            if (file.getParent() instanceof IFolder) {
                                ActionsUtil.ensureFolderExists((IFolder)file.getParent(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            } else {
                                monitor.worked(1);
                            }
                        }
                        IContentDescription contentDescription = ActionsUtil.getContentDescription(file, contents);
                        String string = encoding != null ? encoding : (sourceEncoding = contentDescription != null ? contentDescription.getCharset() : null);
                        if (sourceEncoding == null) {
                            sourceEncoding = ResourcesPlugin.getWorkspace().getRoot().getDefaultCharset();
                        }
                        InputStream source = new ByteArrayInputStream(contents.getBytes(sourceEncoding));
                        IContentType defaultContentType = Platform.getContentTypeManager().findContentTypeFor(file.getName());
                        IContentDescription defaultDescription = defaultContentType != null ? defaultContentType.getDefaultDescription() : null;
                        boolean bl = requiresBOM = defaultDescription != null && defaultDescription.getProperty(IContentDescription.BYTE_ORDER_MARK) != null;
                        if (requiresBOM && CHARSET_UTF_8.equals(sourceEncoding)) {
                            source = new SequenceInputStream(new ByteArrayInputStream(IContentDescription.BOM_UTF_8), source);
                        }
                        monitor.worked(1);
                        if (!file.exists() && encoding == null) {
                            file.create(source, false, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
                        } else {
                            if (!file.exists()) {
                                file.create((InputStream)new ByteArrayInputStream(new byte[0]), false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                file.setCharset(encoding.length() > 0 ? encoding : null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            } else {
                                monitor.worked(2);
                            }
                            file.setContents(source, false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        file.setDerived(derived);
                        break block17;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new JET2TagException((Throwable)e);
                    }
                    catch (CoreException e) {
                        throw new JET2TagException((Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    Object var13_11 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return false;
        }
        Object var13_10 = null;
        monitor.done();
        return true;
    }

    private static IContentDescription getContentDescription(IFile file, String contents) {
        try {
            return Platform.getContentTypeManager().getDescriptionFor((Reader)new StringReader(contents), file.getName(), new QualifiedName[]{IContentDescription.CHARSET});
        }
        catch (IOException e) {
            InternalJET2Platform.getDefault().getLog().log(InternalJET2Platform.newStatus(4, "IO error determining content type for generated content", e));
            return null;
        }
    }

    public static boolean ensureFolderExists(IFolder folder, IProgressMonitor monitor) throws JET2TagException {
        boolean foldersCreated = false;
        IProject project = folder.getProject();
        IPath relPath = folder.getProjectRelativePath();
        String taskMessage = MessageFormat.format(JET2Messages.WsFolderAction_CreatingFolder, folder.getFullPath().toString());
        monitor.beginTask(taskMessage, relPath.segmentCount());
        monitor.setTaskName(taskMessage);
        int i = 1;
        while (i <= relPath.segmentCount()) {
            IPath subPath = relPath.uptoSegment(i);
            IFolder iFolder = project.getFolder(subPath);
            if (!iFolder.exists()) {
                try {
                    iFolder.create(false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    foldersCreated = true;
                }
                catch (CoreException e) {
                    throw new JET2TagException(e.getMessage(), (Throwable)e);
                }
            } else {
                monitor.worked(1);
            }
            ++i;
        }
        return foldersCreated;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeBinaryFile(IFile file, boolean replace, byte[] contents, IProgressMonitor monitor) throws JET2TagException {
        try {
            try {
                boolean fileExists;
                block15: {
                    block14: {
                        block13: {
                            String fileMessage = MessageFormat.format(JET2Messages.WsCopyBinaryFileAction_WritingFile, file.getFullPath().toString());
                            monitor.beginTask(fileMessage, 2);
                            fileExists = file.exists();
                            if (!fileExists || replace) break block13;
                            break block14;
                        }
                        if (file.getParent() instanceof IFolder) {
                            ActionsUtil.ensureFolderExists((IFolder)file.getParent(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        } else {
                            monitor.worked(1);
                        }
                        if (!fileExists || !contents.equals(ActionsUtil.readBinaryStream(file.getContents()))) break block15;
                    }
                    Object var7_8 = null;
                    monitor.done();
                    return false;
                }
                ByteArrayInputStream input = new ByteArrayInputStream(contents);
                if (fileExists) {
                    file.setContents((InputStream)input, false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else if (!fileExists) {
                    file.create((InputStream)input, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                Object var7_9 = null;
            }
            catch (IOException e) {
                throw new JET2TagException((Throwable)e);
            }
            catch (CoreException e) {
                throw new JET2TagException((Throwable)e);
            }
            monitor.done();
            return true;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            monitor.done();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readTextFile(URL url, String encoding) throws JET2TagException {
        String string;
        InputStream input = null;
        try {
            try {
                input = url.openStream();
                string = ActionsUtil.readTextStream(input, encoding);
                Object var4_4 = null;
                if (input == null) return string;
            }
            catch (IOException e) {
                throw new JET2TagException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (input == null) throw throwable;
            try {
                input.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        input.close();
        return string;
    }

    private static String readTextStream(InputStream input, String encoding) throws IOException {
        String string;
        block14: {
            InputStreamReader reader = null;
            try {
                if (encoding != null) {
                    if (encoding.equals(CHARSET_UTF_8)) {
                        input = ActionsUtil.stripByteOrderMark(input);
                    }
                    reader = new InputStreamReader(input, encoding);
                } else {
                    reader = new InputStreamReader(input);
                }
                StringBuffer inputContents = new StringBuffer();
                char[] readChars = new char[1024];
                int read = reader.read(readChars);
                while (read != -1) {
                    inputContents.append(readChars, 0, read);
                    read = reader.read(readChars);
                }
                string = inputContents.toString();
                Object var6_7 = null;
                if (reader == null) break block14;
            }
            catch (Throwable throwable) {
                block16: {
                    Object var6_8 = null;
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (input == null) break block16;
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((Reader)reader).close();
            }
            catch (IOException iOException) {}
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    private static InputStream stripByteOrderMark(InputStream input) throws IOException {
        int bytes;
        if (!input.markSupported()) {
            input = new BufferedInputStream(input);
        }
        input.mark(BOM_UTF_8.length + 1);
        int bomLength = BOM_UTF_8.length;
        byte[] bomStore = new byte[bomLength];
        int bytesRead = 0;
        do {
            if ((bytes = input.read(bomStore, bytesRead, bomLength - bytesRead)) != -1) continue;
            throw new IOException();
        } while ((bytesRead += bytes) < bomLength);
        if (!Arrays.equals(BOM_UTF_8, bomStore)) {
            input.reset();
        }
        return input;
    }

    public static byte[] readBinaryFile(URL url) throws JET2TagException {
        try {
            return ActionsUtil.readBinaryStream(new BufferedInputStream(url.openStream()));
        }
        catch (IOException e) {
            throw new JET2TagException((Throwable)e);
        }
    }

    public static byte[] readBinaryStream(InputStream input) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream output;
        block11: {
            output = null;
            try {
                output = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int read = input.read(buffer);
                while (read != -1) {
                    output.write(buffer, 0, read);
                    read = input.read(buffer);
                }
                byArray = output.toByteArray();
                Object var4_5 = null;
                if (input == null) break block11;
            }
            catch (Throwable throwable) {
                block13: {
                    Object var4_6 = null;
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (output == null) break block13;
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    public static void createProject(IProject project, IProgressMonitor monitor) throws JET2TagException {
        ActionsUtil.createProject(project, null, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean createProject(IProject project, IProjectDescription description, IProgressMonitor monitor) throws JET2TagException {
        boolean projectCreated = false;
        String createMessage = MessageFormat.format(JET2Messages.WsProjectAction_CreatingProject, project.getName());
        monitor.beginTask(createMessage, 2);
        try {
            try {
                if (!project.exists()) {
                    project.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    projectCreated = true;
                } else {
                    monitor.worked(1);
                }
                if (!project.isOpen()) {
                    project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
            }
            catch (IllegalArgumentException e) {
                throw new JET2TagException((Throwable)e);
            }
            catch (CoreException e) {
                throw new JET2TagException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        monitor.done();
        return projectCreated;
    }

    public static void checkpointWorkspace(boolean build) {
        ActionsUtil.checkpointWorkspace(build, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void checkpointWorkspace(boolean build, IProgressMonitor monitor) {
        ResourcesPlugin.getWorkspace().checkpoint(build);
        if (build) {
            ActionsUtil.waitForBuildToComplete(monitor);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void waitForBuildToComplete(IProgressMonitor monitor) {
        monitor.beginTask(JET2Messages.ProjectTemplateBundleDescriptor_WaitingForBuild, 1);
        try {
            try {
                ResourcesPlugin.getWorkspace().build(10, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            catch (CoreException coreException) {}
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        monitor.done();
    }

    static boolean finalizeAndTestForChange(IFile file, BufferedJET2Writer writer, InputStream existingContents) {
        String existingText = null;
        if (existingContents != null) {
            try {
                existingText = ActionsUtil.readTextStream(existingContents, file.getCharset());
            }
            catch (IOException e) {
                throw new JET2TagException((Throwable)e);
            }
            catch (CoreException e) {
                throw new JET2TagException((Throwable)e);
            }
        }
        ActionsUtil.finalizeContent((JET2Writer)writer, file, existingText);
        if (existingText != null) {
            return !existingText.equals(writer.getContent());
        }
        return true;
    }
}

