/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.control;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jet.internal.taglib.control.AbstrateDeepIterateStrategy;
import org.eclipse.jet.internal.taglib.control.DeepIterateEntry;
import org.eclipse.jet.internal.taglib.control.DeepIteratorStrategyBuilder;
import org.eclipse.jet.internal.taglib.control.IDeepIterateStrategy;
import org.eclipse.jet.internal.taglib.control.Messages;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.osgi.util.NLS;

public class BreadthFirstStrategy
extends AbstrateDeepIterateStrategy
implements IDeepIterateStrategy {
    public BreadthFirstStrategy(DeepIteratorStrategyBuilder builder) {
        super(builder);
    }

    public void checkDeepContentAllowed() throws JET2TagException {
        if (!this.supportsDeepContent()) {
            throw new JET2TagException(NLS.bind((String)Messages.BreadthFirstStrategy_DeepContentNotAllowed, (Object)this.deepIterateTagName, (Object)"breadthFirst"));
        }
    }

    public boolean supportsDeepContent() {
        return false;
    }

    protected void doSearch() {
        LinkedList<DeepIterateEntry> queue = new LinkedList<DeepIterateEntry>();
        DeepIterateEntry initialEntry = new DeepIterateEntry(this.initialContextObject, 0);
        queue.add(initialEntry);
        while (queue.size() > 0) {
            DeepIterateEntry entry = (DeepIterateEntry)queue.removeFirst();
            if (entry.getDepth() > 0) {
                this.entries.add(entry);
            }
            boolean hasChildren = false;
            Object[] nodes = this.selectNodes(entry.getObject(), entry.getDepth() + 1);
            int i = 0;
            while (i < nodes.length) {
                DeepIterateEntry child = new DeepIterateEntry(nodes[i], entry.getDepth() + 1);
                if (!this.isDuplicateEntry(child)) {
                    queue.addLast(child);
                    hasChildren = true;
                }
                ++i;
            }
            entry.setLeaf(!hasChildren);
        }
        Iterator i = this.entries.iterator();
        while (i.hasNext()) {
            DeepIterateEntry entry = (DeepIterateEntry)i.next();
            if (this.satisfiesFilter(entry)) continue;
            i.remove();
        }
    }
}

