/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.newfile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.acceleo.ide.ui.wizards.newfile.example.IAcceleoExampleStrategy;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.AcceleoNewTemplatesWizardController;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.example.AcceleoExampleStrategyUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.presentation.EcoreActionBarContributor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoNewTemplatesDetailsComposite
extends Composite {
    protected static final int TEMPLATE_NAME = 0;
    protected static final int TEMPLATE_PARENT_FOLDER = 1;
    protected static final int TEMPLATE_METAMODEL_URI = 2;
    protected static final int TEMPLATE_METAMODEL_TYPE = 3;
    protected static final int TEMPLATE_IS_FILE = 4;
    protected static final int TEMPLATE_HAS_MAIN = 5;
    protected static final int TEMPLATE_EXAMPLE_STRATEGY = 6;
    protected static final int TEMPLATE_EXAMPLE_PATH = 7;
    protected static final int TEMPLATE_IS_INITIALISED = 8;
    private Text templateContainer;
    private Text templateName;
    private Text templateExamplePath;
    private Combo templateExampleStrategy;
    private Button templateHasFileButtonState;
    private Button templateHasMainButtonState;
    private Button templateIsInitializeButtonState;
    private Text metamodelURI;
    private Combo metamodelType;
    private String[] metamodelTypes;
    private String selectedContainer;
    private Button advancedButton;
    private Composite exampleContainer;
    private Label exampleFileLabel;
    private Button exampleBrowseButton;
    private AcceleoNewTemplatesWizardController controller;

    public AcceleoNewTemplatesDetailsComposite(Composite rootContainer, int style) {
        super(rootContainer, style);
        this.createDetailsComposite();
        this.updateDefaultTypes();
        this.updateStrategies();
    }

    private void createDetailsComposite() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 128;
        gridData = new GridData(1808);
        gridData.heightHint = 420;
        this.setLayoutData(gridData);
        this.createTemplateGroup(this);
    }

    private void createTemplateGroup(Composite rootContainer) {
        final Composite templateGroup = new Composite(rootContainer, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        templateGroup.setLayout((Layout)layout);
        templateGroup.setLayoutData((Object)new GridData(1808));
        this.createTemplateContainerComposite(templateGroup);
        this.createTemplateContainerName(templateGroup);
        this.createMetamodelGroup(templateGroup);
        this.exampleContainer = null;
        new Label(templateGroup, 0);
        this.advancedButton = new Button(templateGroup, 8);
        this.advancedButton.setFont(templateGroup.getFont());
        this.advancedButton.setText(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.AdvanceShowedButton"));
        GridData data = this.setButtonLayoutData(this.advancedButton);
        data.horizontalAlignment = 1;
        data.horizontalSpan = 3;
        this.advancedButton.setLayoutData((Object)data);
        this.advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcceleoNewTemplatesDetailsComposite.this.handleAdvancedButtonSelect(templateGroup);
            }
        });
        this.createAdvancedButtonSelect(templateGroup);
    }

    private GridData setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        button.setLayoutData((Object)data);
        return data;
    }

    private void createAdvancedButtonSelect(Composite templateGroup) {
        this.exampleContainer = new Composite(templateGroup, 0);
        GridLayout exampleContainerLayout = new GridLayout();
        exampleContainerLayout.numColumns = 1;
        this.exampleContainer.setLayout((Layout)exampleContainerLayout);
        GridData exampleContainerGridData = new GridData(768);
        exampleContainerGridData.horizontalSpan = 3;
        this.exampleContainer.setLayout((Layout)exampleContainerLayout);
        this.exampleContainer.setLayoutData((Object)exampleContainerGridData);
        this.createTemplateExample();
        Composite additionalOption = new Composite(this.exampleContainer, 0);
        GridLayout additionalLayout = new GridLayout();
        additionalLayout.numColumns = 1;
        additionalOption.setLayout((Layout)additionalLayout);
        this.createTemplateStatusWidgets(additionalOption);
        templateGroup.layout();
        this.exampleContainer.setVisible(false);
        this.advancedButton.setText(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.AdvanceShowedButton"));
    }

    private void handleAdvancedButtonSelect(Composite templateGroup) {
        if (this.exampleContainer.isVisible()) {
            this.exampleContainer.setVisible(false);
            this.advancedButton.setText(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.AdvanceShowedButton"));
        } else {
            this.exampleContainer.setVisible(true);
            this.advancedButton.setText(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.AdvanceHiddenButton"));
        }
    }

    private void createTemplateExample() {
        Composite initializeTemplate = new Composite(this.exampleContainer, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        initializeTemplate.setLayoutData((Object)gridData);
        initializeTemplate.setLayout((Layout)layout);
        this.templateIsInitializeButtonState = new Button(initializeTemplate, 32);
        this.templateIsInitializeButtonState.setText(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.TemplateOutput"));
        gridData = new GridData();
        gridData.widthHint = 120;
        this.templateIsInitializeButtonState.setLayoutData((Object)gridData);
        this.templateExampleStrategy = new Combo(initializeTemplate, 8);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.templateExampleStrategy.setLayoutData((Object)gridData);
        this.templateExampleStrategy.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AcceleoNewTemplatesDetailsComposite.this.controller.dialogChanged();
                AcceleoNewTemplatesDetailsComposite.this.controller.firePropertiesChanged((EventObject)e, 6);
            }
        });
        this.updateStrategies();
        Composite initializeFileTemplate = new Composite(this.exampleContainer, 0);
        gridData = new GridData(768);
        initializeFileTemplate.setLayoutData((Object)gridData);
        initializeFileTemplate.setLayout((Layout)layout);
        this.exampleFileLabel = new Label(initializeFileTemplate, 0);
        this.exampleFileLabel.setText(String.valueOf(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.TemplateOutputFile")) + ':');
        gridData = new GridData(768);
        gridData.horizontalAlignment = 131072;
        gridData.widthHint = 35;
        this.exampleFileLabel.setLayoutData((Object)gridData);
        this.templateExamplePath = new Text(initializeFileTemplate, 2052);
        gridData = new GridData(768);
        gridData.widthHint = 230;
        this.templateExamplePath.setLayoutData((Object)gridData);
        this.templateExamplePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoNewTemplatesDetailsComposite.this.controller.dialogChanged();
                AcceleoNewTemplatesDetailsComposite.this.controller.firePropertiesChanged((EventObject)e, 7);
            }
        });
        this.exampleBrowseButton = new Button(initializeFileTemplate, 8);
        this.exampleBrowseButton.setText(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.Browse"));
        this.exampleBrowseButton.addSelectionListener((SelectionListener)new ExampleBrowseSelectionAdapter());
        this.initExampleStrategyGroup();
    }

    private void initExampleStrategyGroup() {
        this.templateIsInitializeButtonState.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AcceleoNewTemplatesDetailsComposite.this.controller.dialogChanged();
                AcceleoNewTemplatesDetailsComposite.this.controller.firePropertiesChanged((EventObject)e, 8);
                AcceleoNewTemplatesDetailsComposite.this.setExampleStrategyGroupEnabled(AcceleoNewTemplatesDetailsComposite.this.templateIsInitializeButtonState.getSelection());
            }
        });
        this.templateIsInitializeButtonState.setSelection(false);
        this.templateExampleStrategy.setEnabled(false);
        this.exampleFileLabel.setEnabled(false);
        this.templateExamplePath.setEnabled(false);
        this.exampleBrowseButton.setEnabled(false);
        this.templateExampleStrategy.select(0);
    }

    private void setExampleStrategyGroupEnabled(boolean enabled) {
        this.templateExampleStrategy.setEnabled(enabled);
        this.exampleFileLabel.setEnabled(enabled);
        this.templateExamplePath.setEnabled(enabled);
        this.exampleBrowseButton.setEnabled(enabled);
    }

    public IAcceleoExampleStrategy getTemplateExampleStrategy() {
        if (this.templateExampleStrategy != null && this.templateExampleStrategy.getSelectionIndex() > -1 && this.templateExampleStrategy.getSelectionIndex() < AcceleoExampleStrategyUtils.getExampleStrategies().size()) {
            return AcceleoExampleStrategyUtils.getExampleStrategies().get(this.templateExampleStrategy.getSelectionIndex());
        }
        return null;
    }

    private void createTemplateContainerName(Composite templateGroup) {
        GridData gridData = new GridData(768);
        Label nameLabel = new Label(templateGroup, 0);
        nameLabel.setText(String.valueOf(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.TemplateName")) + ':');
        this.templateName = new Text(templateGroup, 2052);
        gridData = new GridData(768);
        gridData.widthHint = 270;
        gridData.horizontalSpan = 2;
        this.templateName.setLayoutData((Object)gridData);
        this.templateName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoNewTemplatesDetailsComposite.this.controller.dialogChanged();
                AcceleoNewTemplatesDetailsComposite.this.controller.firePropertiesChanged((EventObject)e, 0);
            }
        });
    }

    private void createTemplateContainerComposite(Composite templateGroup) {
        Label label = new Label(templateGroup, 0);
        label.setText(String.valueOf(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.TemplateContainer")) + ':');
        this.templateContainer = new Text(templateGroup, 2052);
        GridData gd = new GridData(768);
        this.templateContainer.setLayoutData((Object)gd);
        this.templateContainer.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoNewTemplatesDetailsComposite.this.controller.dialogChanged();
                AcceleoNewTemplatesDetailsComposite.this.controller.firePropertiesChanged((EventObject)e, 1);
            }
        });
        Button button = new Button(templateGroup, 8);
        button.setText(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.Browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcceleoNewTemplatesDetailsComposite.this.handleBrowseWorkspace();
            }
        });
    }

    private void createTemplateStatusWidgets(Composite statusContainer) {
        this.templateHasFileButtonState = new Button(statusContainer, 32);
        this.templateHasFileButtonState.setText(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.AcceleoHasFileBlock"));
        this.templateHasFileButtonState.setSelection(true);
        this.templateHasFileButtonState.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AcceleoNewTemplatesDetailsComposite.this.controller.dialogChanged();
                AcceleoNewTemplatesDetailsComposite.this.controller.firePropertiesChanged((EventObject)e, 4);
            }
        });
        this.templateHasMainButtonState = new Button(statusContainer, 32);
        this.templateHasMainButtonState.setText(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.AcceleoHasMain"));
        this.templateHasMainButtonState.setSelection(true);
        this.templateHasMainButtonState.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AcceleoNewTemplatesDetailsComposite.this.controller.dialogChanged();
                AcceleoNewTemplatesDetailsComposite.this.controller.firePropertiesChanged((EventObject)e, 5);
            }
        });
        if (this.controller != null) {
            this.controller.dialogChanged();
        }
    }

    private void createMetamodelGroup(Composite rootContainer) {
        GridData gridData = new GridData(768);
        Label uriLabel = new Label(rootContainer, 0);
        uriLabel.setText(String.valueOf(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.MetamodelURI")) + ':');
        this.metamodelURI = new Text(rootContainer, 2052);
        gridData = new GridData(768);
        this.metamodelURI.setLayoutData((Object)gridData);
        this.metamodelURI.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoNewTemplatesDetailsComposite.this.controller.firePropertiesChanged((EventObject)e, 2);
                AcceleoNewTemplatesDetailsComposite.this.controller.dialogChanged();
                AcceleoNewTemplatesDetailsComposite.this.updateTypes();
            }
        });
        Button button = new Button(rootContainer, 8);
        button.setText(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.Browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcceleoNewTemplatesDetailsComposite.this.handleSelectMetamodelURI();
            }
        });
        Label typeLabel = new Label(rootContainer, 0);
        typeLabel.setText(String.valueOf(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.TemplateType")) + ':');
        this.metamodelType = new Combo(rootContainer, 8);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.metamodelType.setLayoutData((Object)gridData);
        this.metamodelType.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AcceleoNewTemplatesDetailsComposite.this.controller.dialogChanged();
                AcceleoNewTemplatesDetailsComposite.this.controller.firePropertiesChanged((EventObject)e, 3);
            }
        });
        this.metamodelType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoNewTemplatesDetailsComposite.this.controller.dialogChanged();
                AcceleoNewTemplatesDetailsComposite.this.controller.firePropertiesChanged((EventObject)e, 3);
            }
        });
    }

    private void handleSelectMetamodelURI() {
        EcoreActionBarContributor.ExtendedLoadResourceAction.RegisteredPackageDialog registeredPackageDialog = new EcoreActionBarContributor.ExtendedLoadResourceAction.RegisteredPackageDialog(this.getShell());
        registeredPackageDialog.open();
        Object[] result = registeredPackageDialog.getResult();
        if (result != null) {
            List<Object> nsURIs = Arrays.asList(result);
            if (registeredPackageDialog.isDevelopmentTimeVersion()) {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
                StringBuffer uris = new StringBuffer();
                Map ePackageNsURItoGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
                int i = 0;
                while (i < result.length) {
                    URI location = (URI)ePackageNsURItoGenModelLocationMap.get(result[i]);
                    Resource resource = resourceSet.getResource(location, true);
                    EcoreUtil.resolveAll((Resource)resource);
                    ++i;
                }
                block1: for (Resource resource : resourceSet.getResources()) {
                    for (EPackage ePackage : this.getAllPackages(resource)) {
                        if (!nsURIs.contains(ePackage.getNsURI())) continue;
                        uris.append(ePackage.getNsURI());
                        uris.append("  ");
                        continue block1;
                    }
                }
                this.metamodelURI.setText(uris.toString().trim());
            } else {
                StringBuffer uris = new StringBuffer();
                int i = 0;
                while (i < result.length) {
                    uris.append(result[i]);
                    uris.append("  ");
                    ++i;
                }
                this.metamodelURI.setText(uris.toString().trim());
            }
        }
    }

    private Collection<EPackage> getAllPackages(Resource resource) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        EcoreUtil.ContentTreeIterator<Object> iterator = new EcoreUtil.ContentTreeIterator<Object>((Collection)resource.getContents()){
            private static final long serialVersionUID = 1L;

            protected Iterator<? extends EObject> getEObjectChildren(EObject eObject) {
                if (eObject instanceof EPackage) {
                    return ((EPackage)eObject).getESubpackages().iterator();
                }
                return Collections.emptyList().iterator();
            }
        };
        while (iterator.hasNext()) {
            Object content = iterator.next();
            if (!(content instanceof EPackage)) continue;
            result.add((EPackage)content);
        }
        return result;
    }

    private void handleBrowseWorkspace() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.ContainerSelection"));
        IResource current = null;
        Path path = new Path(this.getTemplateContainer());
        while (current == null && path.segmentCount() > 0) {
            current = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (current != null) continue;
            path = path.removeLastSegments(1);
        }
        if (current != null) {
            dialog.setInitialSelections(new Object[]{current});
        }
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.templateContainer.setText(((Path)result[0]).toString());
        }
    }

    public void initializeContainer() {
        if (this.selectedContainer != null) {
            this.templateContainer.setText(this.selectedContainer.toString());
        }
    }

    private void updateStrategies() {
        if (this.templateExampleStrategy != null) {
            ArrayList<String> descriptions = new ArrayList<String>();
            Iterator<IAcceleoExampleStrategy> iterator = AcceleoExampleStrategyUtils.getExampleStrategies().iterator();
            while (iterator.hasNext()) {
                descriptions.add(iterator.next().getDescription());
            }
            this.templateExampleStrategy.setItems(descriptions.toArray(new String[descriptions.size()]));
            if (descriptions.size() < 15) {
                this.templateExampleStrategy.setVisibleItemCount(descriptions.size());
            } else {
                this.templateExampleStrategy.setVisibleItemCount(15);
            }
        }
    }

    private void updateTypes() {
        if (this.metamodelType != null) {
            String oldSelection = this.metamodelType.getText();
            TreeSet<String> typeValues = new TreeSet<String>();
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(this.getMetamodelURI());
            if (ePackage != null) {
                ArrayList<EClassifier> eClassifiers = new ArrayList<EClassifier>();
                AcceleoNewTemplatesDetailsComposite.computeClassifiers(eClassifiers, ePackage);
                int i = 0;
                while (i < eClassifiers.size()) {
                    EClassifier eClassifier = (EClassifier)eClassifiers.get(i);
                    typeValues.add(eClassifier.getName());
                    ++i;
                }
            }
            this.metamodelTypes = typeValues.toArray(new String[typeValues.size()]);
            this.metamodelType.setItems(this.metamodelTypes);
            if (this.metamodelTypes.length < 15) {
                this.metamodelType.setVisibleItemCount(this.metamodelTypes.length);
            } else {
                this.metamodelType.setVisibleItemCount(15);
            }
            this.metamodelType.setText(oldSelection);
            if (this.metamodelType.getText().length() == 0) {
                this.updateDefaultTypes();
            }
        }
    }

    private static void computeClassifiers(List<EClassifier> eClassifiers, EPackage ePackage) {
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            eClassifiers.add(eClassifier);
        }
        Iterator packages = ePackage.getESubpackages().iterator();
        while (packages.hasNext()) {
            AcceleoNewTemplatesDetailsComposite.computeClassifiers(eClassifiers, (EPackage)packages.next());
        }
    }

    private void updateDefaultTypes() {
        this.metamodelType.setText("Element");
        this.metamodelType.setText("Model");
        this.metamodelType.setText("File");
        this.metamodelType.setText("Type");
        this.metamodelType.setText("EClass");
        this.metamodelType.setText("Class");
    }

    public String getTemplateContainer() {
        return this.templateContainer.getText();
    }

    public String getTemplateName() {
        return this.templateName.getText();
    }

    public String getTemplateExample() {
        return this.templateExamplePath.getText();
    }

    public boolean getTemplateHasFileBlock() {
        return this.templateHasFileButtonState.getSelection();
    }

    public boolean getTemplateIsMain() {
        return this.templateHasMainButtonState.getSelection();
    }

    public String getMetamodelURI() {
        return this.metamodelURI.getText();
    }

    public String getMetamodelType() {
        if (this.metamodelType != null && this.metamodelTypes != null && this.metamodelType.getSelectionIndex() > -1 && this.metamodelType.getSelectionIndex() < this.metamodelTypes.length) {
            return this.metamodelTypes[this.metamodelType.getSelectionIndex()];
        }
        return "";
    }

    public String getContainer() {
        return this.selectedContainer;
    }

    public void setContainer(String container) {
        this.selectedContainer = container;
        this.setTemplateContainer(container);
    }

    public void setController(AcceleoNewTemplatesWizardController controller) {
        this.controller = controller;
    }

    public void setTemplateHasFileButtonState(boolean templateHasFileButtonState) {
        this.templateHasFileButtonState.setSelection(templateHasFileButtonState);
    }

    public void setTemplateHasMainButtonState(boolean templateHasMainButtonState) {
        this.templateHasMainButtonState.setSelection(templateHasMainButtonState);
    }

    public void setTemplateIsInitializeButtonState(boolean templateIsInitializeButtonState) {
        this.templateIsInitializeButtonState.setSelection(templateIsInitializeButtonState);
        this.setExampleStrategyGroupEnabled(templateIsInitializeButtonState);
    }

    public void setTemplateContainer(String templateContainer) {
        this.templateContainer.setText(templateContainer);
    }

    public void setTemplateName(String templateName) {
        this.templateName.setText(templateName);
    }

    public void setMetamodelURI(String metamodelURI) {
        this.metamodelURI.setText(metamodelURI);
    }

    public void setMetamodelType(String metamodelType) {
        List<String> asList;
        if (metamodelType != null && metamodelType.length() > 0 && (asList = Arrays.asList(this.metamodelType.getItems())).contains(metamodelType)) {
            this.metamodelType.select(asList.indexOf(metamodelType));
        }
    }

    public void setTemplateExamplePath(String templateExamplePath) {
        this.templateExamplePath.setText(templateExamplePath);
    }

    public void setTemplateExampleStrategy(String templateExampleStrategy) {
        if (templateExampleStrategy != null && templateExampleStrategy.length() > 0) {
            List<String> asList = Arrays.asList(this.templateExampleStrategy.getItems());
            if (asList.contains(templateExampleStrategy)) {
                this.templateExampleStrategy.select(asList.indexOf(templateExampleStrategy));
            }
        } else {
            this.templateExampleStrategy.select(0);
        }
    }

    class ExampleBrowseSelectionAdapter
    extends SelectionAdapter {
        ExampleBrowseSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(AcceleoNewTemplatesDetailsComposite.this.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
            dialog.setTitle(AcceleoUIMessages.getString("AcceleoNewTemplateWizardPage.TemplateExample"));
            String path = AcceleoNewTemplatesDetailsComposite.this.templateExamplePath.getText();
            if (path != null && path.length() > 0 && new Path(path).lastSegment().length() > 0) {
                dialog.setInitialPattern("*." + new Path(path).getFileExtension());
            } else {
                IAcceleoExampleStrategy strategy = AcceleoNewTemplatesDetailsComposite.this.getTemplateExampleStrategy();
                if (strategy != null) {
                    dialog.setInitialPattern(strategy.getInitialFileNameFilter());
                } else {
                    dialog.setInitialPattern("*.java");
                }
            }
            dialog.open();
            if (dialog.getResult() != null && dialog.getResult().length > 0 && dialog.getResult()[0] instanceof IFile) {
                AcceleoNewTemplatesDetailsComposite.this.templateExamplePath.setText(((IFile)dialog.getResult()[0]).getFullPath().toString());
                AcceleoNewTemplatesDetailsComposite.this.templateName.setText(((IFile)dialog.getResult()[0]).getFullPath().removeFileExtension().lastSegment().toLowerCase().replace('-', '_'));
            }
        }
    }
}

