/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.views.result;

import java.util.ArrayList;
import org.eclipse.acceleo.engine.event.AcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.service.AcceleoService;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.views.result.AcceleoResultContent;
import org.eclipse.acceleo.internal.ide.ui.views.result.AcceleoResultFilesFilter;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityElement;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityModel;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityRegion;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityTargetFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.navigator.ResourceNavigator;

public class AcceleoResultView
extends ResourceNavigator {
    private AcceleoResultContent content;
    private IResourceChangeListener resourceChangeListener;
    private UIJob refreshUIJob;
    private AcceleoResultFilesFilter previewFilesFilter = new AcceleoResultFilesFilter(this);

    public AcceleoResultContent getContent() {
        return this.content;
    }

    protected void initContentProvider(TreeViewer viewer) {
        viewer.setContentProvider((IContentProvider)new AcceleoPreviewContentProvider());
    }

    protected void initLabelProvider(TreeViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new AcceleoPreviewLabelProvider());
    }

    private AdapterFactory createAdapterFactory() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        return new ComposedAdapterFactory(factories);
    }

    protected void initFilters(TreeViewer viewer) {
        viewer.addFilter((ViewerFilter)this.previewFilesFilter);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.content != null) {
            AcceleoService.removeListener((AcceleoTextGenerationListener)this.content);
        }
        this.content = new AcceleoResultContent();
        AcceleoService.addListener((AcceleoTextGenerationListener)this.content);
        this.resourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                AcceleoResultView.this.refresh();
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    private void refresh() {
        if (this.refreshUIJob != null) {
            this.refreshUIJob.cancel();
        }
        this.refreshUIJob = new UIJob("Acceleo"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                AcceleoResultView.this.getViewer().refresh();
                return new Status(0, "org.eclipse.acceleo.ide.ui", "OK");
            }
        };
        this.refreshUIJob.setPriority(50);
        this.refreshUIJob.schedule(2000L);
        this.refreshUIJob = null;
    }

    public void dispose() {
        super.dispose();
        if (this.content != null) {
            AcceleoService.removeListener((AcceleoTextGenerationListener)this.content);
            this.content = null;
        }
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
            this.resourceChangeListener = null;
        }
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        if (event.getSelection() instanceof TreeSelection && ((TreeSelection)event.getSelection()).getFirstElement() instanceof TraceabilityElement) {
            TraceabilityElement element;
            TraceabilityElement fileElement = element = (TraceabilityElement)((TreeSelection)event.getSelection()).getFirstElement();
            while (fileElement != null && !(fileElement instanceof TraceabilityTargetFile)) {
                fileElement = fileElement.getParent();
            }
            IEditorPart part = null;
            if (fileElement instanceof TraceabilityTargetFile) {
                IFile file = ((TraceabilityTargetFile)fileElement).getTargetFile();
                try {
                    part = IDE.openEditor((IWorkbenchPage)this.getSite().getPage(), (IFile)file);
                }
                catch (PartInitException e) {
                    AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
                }
            }
            if (part instanceof ITextEditor) {
                ITextEditor editor = (ITextEditor)part;
                if (element instanceof TraceabilityRegion) {
                    TraceabilityRegion region = (TraceabilityRegion)element;
                    editor.selectAndReveal(region.getTargetFileOffset(), region.getTargetFileLength());
                } else if (element instanceof TraceabilityModel && ((TraceabilityModel)element).getRegions().size() > 0) {
                    TraceabilityRegion first = ((TraceabilityModel)element).getRegions().get(0);
                    TraceabilityRegion last = ((TraceabilityModel)element).getRegions().get(((TraceabilityModel)element).getRegions().size() - 1);
                    int b = first.getTargetFileOffset();
                    int e = last.getTargetFileOffset() + last.getTargetFileLength();
                    editor.selectAndReveal(b, e - b);
                }
            }
        } else {
            super.handleDoubleClick(event);
        }
    }

    private class AcceleoPreviewContentProvider
    extends WorkbenchContentProvider {
        private AcceleoPreviewContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof String) {
                return new Object[]{(String)element};
            }
            return super.getElements(element);
        }

        public Object[] getChildren(Object element) {
            Object[] result;
            if (element instanceof IFile) {
                IPath path = ((IFile)element).getFullPath();
                ArrayList<TraceabilityModel> children = new ArrayList<TraceabilityModel>();
                if (AcceleoResultView.this.content != null) {
                    TraceabilityTargetFile[] traceabilityTargetFileArray = AcceleoResultView.this.content.getTargetFiles();
                    int n = traceabilityTargetFileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TraceabilityTargetFile targetFile = traceabilityTargetFileArray[n2];
                        if (path.isPrefixOf(targetFile.getTargetFileFullPath())) {
                            children.addAll(targetFile.getChildren());
                        }
                        ++n2;
                    }
                }
                result = children.toArray();
            } else if (element instanceof TraceabilityModel) {
                ArrayList<TraceabilityElement> children = new ArrayList<TraceabilityElement>();
                children.addAll(((TraceabilityModel)element).getChildren());
                children.addAll(((TraceabilityModel)element).getRegions());
                result = children.toArray();
            } else {
                result = element instanceof TraceabilityRegion ? new Object[]{} : super.getChildren(element);
            }
            return result;
        }
    }

    private class AcceleoPreviewLabelProvider
    extends DecoratingLabelProvider {
        private WorkbenchLabelProvider resourcesLabelProvider;

        public AcceleoPreviewLabelProvider() {
            super((ILabelProvider)new AdapterFactoryLabelProvider(AcceleoResultView.this.createAdapterFactory()), AcceleoResultView.this.getPlugin().getWorkbench().getDecoratorManager().getLabelDecorator());
            this.resourcesLabelProvider = new WorkbenchLabelProvider();
        }

        public void dispose() {
            super.dispose();
            this.resourcesLabelProvider.dispose();
        }

        public String getText(Object element) {
            String text = this.resourcesLabelProvider.getText(element);
            if (text != null && text.length() > 0) {
                return text;
            }
            String result = element instanceof String ? (String)element : (element instanceof TraceabilityModel ? this.getText(((TraceabilityModel)element).getEObject()) : (element instanceof TraceabilityRegion ? ((TraceabilityRegion)element).toString() : super.getText(element)));
            return result;
        }

        public Image getImage(Object element) {
            Image image = this.resourcesLabelProvider.getImage(element);
            if (image == null) {
                image = element instanceof String ? AcceleoUIActivator.getDefault().getImage("icons/AcceleoPreview.gif") : (element instanceof TraceabilityModel ? this.getImage(((TraceabilityModel)element).getEObject()) : (element instanceof TraceabilityRegion ? AcceleoUIActivator.getDefault().getImage("icons/AcceleoRegion.gif") : super.getImage(element)));
            }
            return image;
        }
    }
}

