/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.acceleo.common.internal.utils.AcceleoServicesEclipseUtil;
import org.eclipse.emf.common.EMFPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoServicesRegistry {
    public static final AcceleoServicesRegistry INSTANCE = new AcceleoServicesRegistry();
    private final Set<Object> registeredServices = new LinkedHashSet<Object>();

    private AcceleoServicesRegistry() {
    }

    public boolean addService(Object service) {
        boolean registered = false;
        if (service instanceof Class) {
            try {
                registered = this.registeredServices.add(((Class)service).newInstance());
            }
            catch (InstantiationException e) {
                AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("AcceleoServicesRegistry.ClassInstantiationFailure", ((Class)service).getName()), e, false);
            }
            catch (IllegalAccessException e) {
                AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("AcceleoServicesRegistry.ClassConstructorFailure", ((Class)service).getName()), e, false);
            }
        } else {
            registered = this.registeredServices.add(service);
        }
        return registered;
    }

    public Set<Object> getAllRegisteredServiceInstances() {
        LinkedHashSet<Object> compound = new LinkedHashSet<Object>();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            compound.addAll(AcceleoServicesEclipseUtil.getRegisteredServices());
        }
        compound.addAll(this.registeredServices);
        return compound;
    }

    public Set<Method> getAllRegisteredServices() {
        Set<Object> serviceInstances = this.getAllRegisteredServiceInstances();
        LinkedHashSet<Method> services = new LinkedHashSet<Method>(serviceInstances.size());
        for (Object serviceInstance : serviceInstances) {
            Method[] methodArray = serviceInstance.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                services.add(method);
                ++n2;
            }
        }
        return services;
    }

    public Set<Method> getRegisteredServices(Class<?> receiverType) {
        Set<Method> allServices = this.getAllRegisteredServices();
        LinkedHashSet<Method> applicableServices = new LinkedHashSet<Method>(allServices.size());
        for (Method method : allServices) {
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length <= 0 || !parameters[0].equals(receiverType)) continue;
            applicableServices.add(method);
        }
        return applicableServices;
    }

    public boolean addService(String bundleName, String qualifiedName) {
        Object serviceInstance = null;
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            serviceInstance = AcceleoServicesEclipseUtil.registerService(bundleName, qualifiedName);
        } else {
            try {
                Class<?> clazz = Class.forName(qualifiedName);
                serviceInstance = clazz.newInstance();
                if (serviceInstance != null) {
                    this.registeredServices.add(serviceInstance);
                }
            }
            catch (ClassNotFoundException e) {
                AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("AcceleoServicesRegistry.ClassLookupFailure", qualifiedName), e, true);
            }
            catch (IllegalAccessException e) {
                AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("AcceleoServicesRegistry.ClassConstructorFailure", qualifiedName), e, false);
            }
            catch (InstantiationException e) {
                AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("AcceleoServicesRegistry.ClassInstantiationFailure", qualifiedName), e, false);
            }
        }
        return serviceInstance != null;
    }

    public boolean removeService(Object service) {
        return this.registeredServices.remove(service);
    }

    public void clearRegistry() {
        this.registeredServices.clear();
    }
}

