/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ui.wizards.project;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2m.internal.qvt.oml.builder.QvtBuilderConfig;
import org.eclipse.m2m.internal.qvt.oml.ui.IStatusChangeListener;
import org.eclipse.m2m.internal.qvt.oml.ui.QVTUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.ChooseProjectFolderDialog;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.Messages;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.SourceContainerUpdater;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class SourceContainerConfigBlock {
    private QvtBuilderConfig fBuilderConfig;
    private IProject fProject;
    private IContainer fSourceContainer;
    private IStatus fStatus;
    private IStatusChangeListener fStatusListener;
    private Shell fShell;
    private Button fBrowseButton;
    private Button fMoveExistingButton;
    private Text fSourceField;
    private Label fSourceContainerLabel;

    public SourceContainerConfigBlock(Shell shell, IProject project, IStatusChangeListener statusChangeListener) {
        if (shell == null || project == null || statusChangeListener == null) {
            throw new IllegalArgumentException();
        }
        this.fShell = shell;
        this.fStatus = Status.OK_STATUS;
        this.fProject = project;
        this.fStatusListener = statusChangeListener;
        if (this.fProject.exists()) {
            this.loadBuilderConfig();
        }
    }

    public IContainer getSourceContainer() {
        return this.fSourceContainer;
    }

    public Control createContents(Composite parent) {
        return this.createControl(parent);
    }

    protected Composite createControl(Composite parent) {
        Composite containerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        containerGroup.setLayout((Layout)layout);
        containerGroup.setLayoutData((Object)new GridData(768));
        this.fSourceContainerLabel = new Label(containerGroup, 32);
        this.fSourceContainerLabel.setText(Messages.QvtSettingsPropertyPage_SourceContainerLabel);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.fSourceContainerLabel.setLayoutData((Object)data);
        this.fSourceField = new Text(containerGroup, 2048);
        this.fSourceField.setLayoutData((Object)new GridData(768));
        IProject container = this.fBuilderConfig != null ? this.fBuilderConfig.getSourceContainer() : this.fProject;
        this.fSourceField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SourceContainerConfigBlock.this.containerChanged();
                SourceContainerConfigBlock.this.fStatusListener.statusChanged(SourceContainerConfigBlock.this.fStatus);
                if (SourceContainerConfigBlock.this.fMoveExistingButton != null) {
                    SourceContainerConfigBlock.this.fMoveExistingButton.setEnabled(SourceContainerConfigBlock.this.isContainerChanged());
                }
            }
        });
        this.fSourceField.setText(SourceContainerConfigBlock.getContainerPathString((IResource)container));
        if (this.fProject.exists()) {
            this.fBrowseButton = new Button(containerGroup, 8);
            this.fBrowseButton.setText(Messages.QvtSettingsPropertyPage_BrowseLabel);
            this.fBrowseButton.setLayoutData((Object)new GridData(1));
            this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IContainer container = SourceContainerConfigBlock.this.chooseOutputLocation();
                    if (container != null) {
                        SourceContainerConfigBlock.this.fSourceField.setText(SourceContainerConfigBlock.getContainerPathString((IResource)container));
                    }
                }
            });
            this.fMoveExistingButton = new Button(parent, 32);
            this.fMoveExistingButton.setText(Messages.SourceContainerConfigBlock_MoveExistingSources);
            this.fMoveExistingButton.setEnabled(false);
        }
        return containerGroup;
    }

    public boolean isValid() {
        return this.fStatus.isOK();
    }

    public boolean performApply() {
        if (!this.fProject.exists()) {
            throw new IllegalStateException("Containing project must exist");
        }
        if (this.fSourceContainer == null) {
            throw new IllegalStateException("No valid source container selected");
        }
        if (this.fBuilderConfig == null && !this.loadBuilderConfig()) {
            return false;
        }
        IContainer newSourceContainer = this.getNewContainer();
        IContainer oldSourceContainer = this.getConfiguredContainer();
        if (newSourceContainer != null && newSourceContainer.equals((Object)oldSourceContainer)) {
            return true;
        }
        boolean shouldMoveSources = this.fMoveExistingButton != null && this.fMoveExistingButton.getSelection();
        SourceContainerUpdater containerHelper = new SourceContainerUpdater(oldSourceContainer);
        IStatus updateStatus = containerHelper.setContainer(newSourceContainer, shouldMoveSources, null, this.fShell);
        updateStatus.isOK();
        if (this.fSourceContainer != null) {
            this.fBuilderConfig.setSourceContainer(newSourceContainer);
        }
        try {
            this.fSourceContainer.exists();
            this.fBuilderConfig.save();
        }
        catch (CoreException e) {
            this.setError(Messages.SourceContainerConfigBlock_saveBuilderConfigError, e, true);
            return false;
        }
        return true;
    }

    public void performDefaults() {
        this.fSourceField.setText("");
    }

    private void containerChanged() {
        this.fStatus = Status.OK_STATUS;
        this.fSourceContainer = null;
        String containerPath = this.fSourceField.getText();
        if (containerPath == null || containerPath.length() == 0) {
            this.fSourceContainer = this.fProject;
            return;
        }
        IPath absPath = this.fProject.getFullPath().append((IPath)new Path(containerPath));
        IStatus pathStatus = ResourcesPlugin.getWorkspace().validatePath(absPath.toString(), 6);
        if (!pathStatus.isOK()) {
            this.fStatus = pathStatus;
            return;
        }
        if (this.fProject.exists()) {
            IResource container = this.fProject.getWorkspace().getRoot().findMember(absPath);
            if (container == null || !container.exists()) {
                this.setErrorMessage(NLS.bind((String)Messages.QvtSettingsPropertyPage_InvalidContainer, (Object)absPath));
            } else if (!(container instanceof IContainer)) {
                this.setErrorMessage(NLS.bind((String)Messages.QvtSettingsPropertyPage_ContainerIsNotFolder, (Object)absPath));
            }
            if (this.fStatus.isOK()) {
                this.fSourceContainer = (IContainer)container;
            }
        } else {
            this.fSourceContainer = this.fProject.getFolder(absPath.removeFirstSegments(1));
        }
    }

    private IContainer chooseOutputLocation() {
        String title = Messages.QvtSettingsPropertyPage_SourceContainerSelection;
        String message = Messages.QvtSettingsPropertyPage_SelectSourceContainerFolder;
        ChooseProjectFolderDialog dialog = new ChooseProjectFolderDialog(this.fProject, this.fSourceContainer, this.fShell, title, message);
        if (dialog.open() == 0) {
            return (IContainer)dialog.getFirstResult();
        }
        return null;
    }

    private boolean loadBuilderConfig() {
        try {
            this.fBuilderConfig = QvtBuilderConfig.getConfig((IProject)this.fProject);
        }
        catch (CoreException e) {
            this.setError(Messages.SourceContainerConfigBlock_loadBuilderConfigError, e, true);
            return false;
        }
        return true;
    }

    private void setErrorMessage(String message) {
        this.fStatus = QVTUIPlugin.createStatus(4, message, null);
    }

    private void setError(String message, CoreException coreException, boolean notifyListener) {
        IStatus status = QVTUIPlugin.createStatus(4, message, coreException);
        QVTUIPlugin.log(status);
        this.fStatus = status;
        if (notifyListener) {
            this.fStatusListener.statusChanged(this.fStatus);
        }
    }

    private static String getContainerPathString(IResource resource) {
        return resource.getProjectRelativePath().toString();
    }

    private IContainer getNewContainer() {
        return this.fSourceContainer;
    }

    private IContainer getConfiguredContainer() {
        return this.fBuilderConfig != null ? this.fBuilderConfig.getSourceContainer() : this.fProject;
    }

    private boolean isContainerChanged() {
        return !this.getConfiguredContainer().equals((Object)this.getNewContainer());
    }
}

