/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtConfiguration;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtEditor;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.QVTColorManager;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.SemanticHighlightingPresenter;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.SemanticHighlightingReconciler;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.ui.texteditor.ITextEditor;

public class SemanticHighlightingManager
implements IPropertyChangeListener,
QVTColorManager.IHighlightingChanged {
    private SemanticHighlightingPresenter fPresenter;
    private SemanticHighlightingReconciler fReconciler;
    private QVTColorManager.ColorDescriptor[] fSemanticHighlightings;
    private QvtEditor fEditor;
    private QvtEditor.SrcViewer fSourceViewer;
    private QVTColorManager fColorManager;
    private IPreferenceStore fPreferenceStore;
    private SourceViewerConfiguration fConfiguration;
    private QvtConfiguration.QVTPresentationReconciler fPresentationReconciler;

    public void install(QvtEditor editor, QvtEditor.SrcViewer sourceViewer, QVTColorManager colorManager, IPreferenceStore preferenceStore) {
        this.fEditor = editor;
        this.fSourceViewer = sourceViewer;
        this.fColorManager = colorManager;
        this.fPreferenceStore = preferenceStore;
        this.fSemanticHighlightings = colorManager.getSemanticHighlightings();
        if (this.fEditor != null) {
            this.fConfiguration = new QvtConfiguration((ITextEditor)this.fEditor, colorManager, preferenceStore);
            this.fPresentationReconciler = (QvtConfiguration.QVTPresentationReconciler)this.fConfiguration.getPresentationReconciler((ISourceViewer)this.fSourceViewer);
        } else {
            this.fConfiguration = new QvtConfiguration(colorManager, preferenceStore);
            this.fPresentationReconciler = (QvtConfiguration.QVTPresentationReconciler)this.fConfiguration.getPresentationReconciler((ISourceViewer)this.fSourceViewer);
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        }
        colorManager.addHighlightingChangedListener(this);
        if (this.isSemanticHighlightingEnabled()) {
            this.enable();
        }
    }

    public void install(QvtEditor.SrcViewer sourceViewer, QVTColorManager colorManager, IPreferenceStore preferenceStore) {
        this.install(null, sourceViewer, colorManager, preferenceStore);
    }

    private void enable() {
        int i = 0;
        while (i < this.fSemanticHighlightings.length) {
            this.fSemanticHighlightings[i].createHighlighting();
            ++i;
        }
        this.fPresenter = new SemanticHighlightingPresenter();
        this.fPresenter.install(this.fSourceViewer, this.fPresentationReconciler);
        this.fReconciler = this.createReconciler();
        this.fReconciler.install(this.fEditor, (SourceViewer)this.fSourceViewer, this.fPresenter, this.fSemanticHighlightings);
    }

    protected SemanticHighlightingReconciler createReconciler() {
        return new SemanticHighlightingReconciler();
    }

    public void uninstall() {
        this.disable();
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fPreferenceStore = null;
        }
        if (this.fColorManager != null) {
            this.fColorManager.removeHighlightingChangedListener(this);
        }
        this.fEditor = null;
        this.fSourceViewer = null;
        this.fColorManager = null;
        this.fConfiguration = null;
        this.fPresentationReconciler = null;
    }

    private void disable() {
        if (this.fReconciler != null) {
            this.fReconciler.uninstall();
            this.fReconciler = null;
        }
        if (this.fPresenter != null) {
            this.fPresenter.uninstall();
            this.fPresenter = null;
        }
    }

    private boolean isSemanticHighlightingEnabled() {
        int i = 0;
        while (i < this.fSemanticHighlightings.length) {
            String enabledKey = this.fSemanticHighlightings[i].getEnabledKey();
            if (this.fPreferenceStore != null && enabledKey != null && this.fPreferenceStore.getBoolean(enabledKey)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.handlePropertyChangeEvent(event);
    }

    private void handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fPreferenceStore == null) {
            return;
        }
        if (this.affectsEnablement(this.fPreferenceStore, event)) {
            if (this.isSemanticHighlightingEnabled()) {
                this.enable();
                if (this.fReconciler != null) {
                    this.fReconciler.refresh();
                }
            } else {
                this.disable();
            }
        }
    }

    public boolean affectsEnablement(IPreferenceStore store, PropertyChangeEvent event) {
        String relevantKey = null;
        QVTColorManager.ColorDescriptor[] highlightings = this.fSemanticHighlightings;
        int i = 0;
        while (i < highlightings.length) {
            if (event.getProperty().equals(highlightings[i].getEnabledKey())) {
                relevantKey = event.getProperty();
                break;
            }
            ++i;
        }
        if (relevantKey == null) {
            return false;
        }
        i = 0;
        while (i < highlightings.length) {
            String key = highlightings[i].getEnabledKey();
            if ((key == null || !key.equals(relevantKey)) && key != null && store.getBoolean(key)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void highlightingChanged(QVTColorManager.ColorDescriptor cd) {
        if (this.fPresenter != null && cd.getHighlighting() != null) {
            this.fPresenter.highlightingStyleChanged(cd.getHighlighting());
        }
        if (this.fReconciler != null) {
            this.fReconciler.refresh();
        }
    }

    public SemanticHighlightingReconciler getReconciler() {
        return this.fReconciler;
    }

    static class HighlightedPosition
    extends Position {
        private QVTColorManager.Highlighting fStyle;
        private Object fLock;

        public HighlightedPosition(int offset, int length, QVTColorManager.Highlighting highlighting, Object lock) {
            super(offset, length);
            this.fStyle = highlighting;
            this.fLock = lock;
        }

        public StyleRange createStyleRange() {
            int len = 0;
            if (this.fStyle.isEnabled()) {
                len = this.getLength();
            }
            TextAttribute textAttribute = this.fStyle.getTextAttribute();
            int style = textAttribute.getStyle();
            int fontStyle = style & 3;
            StyleRange styleRange = new StyleRange(this.getOffset(), len, textAttribute.getForeground(), textAttribute.getBackground(), fontStyle);
            styleRange.strikeout = (style & 0x20000000) != 0;
            styleRange.underline = (style & 0x40000000) != 0;
            return styleRange;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEqual(int off, int len, QVTColorManager.Highlighting highlighting) {
            Object object = this.fLock;
            synchronized (object) {
                return !this.isDeleted() && this.getOffset() == off && this.getLength() == len && this.fStyle == highlighting;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isContained(int off, int len) {
            Object object = this.fLock;
            synchronized (object) {
                return !this.isDeleted() && off <= this.getOffset() && off + len >= this.getOffset() + this.getLength();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(int off, int len) {
            Object object = this.fLock;
            synchronized (object) {
                super.setOffset(off);
                super.setLength(len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLength(int length) {
            Object object = this.fLock;
            synchronized (object) {
                super.setLength(length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setOffset(int offset) {
            Object object = this.fLock;
            synchronized (object) {
                super.setOffset(offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() {
            Object object = this.fLock;
            synchronized (object) {
                super.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undelete() {
            Object object = this.fLock;
            synchronized (object) {
                super.undelete();
            }
        }

        public QVTColorManager.Highlighting getHighlighting() {
            return this.fStyle;
        }
    }

    public static class HighlightedRange
    extends Region {
        private String fKey;

        public HighlightedRange(int offset, int length, String key) {
            super(offset, length);
            this.fKey = key;
        }

        public String getKey() {
            return this.fKey;
        }

        public boolean equals(Object o) {
            return super.equals(o) && o instanceof HighlightedRange && this.fKey.equals(((HighlightedRange)((Object)o)).getKey());
        }

        public int hashCode() {
            return super.hashCode() | this.fKey.hashCode();
        }
    }
}

