/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.m2m.atl.engine.extractors.Extractor;
import org.eclipse.m2m.atl.engine.extractors.xml.XMLExtractor;
import org.eclipse.m2m.atl.engine.injectors.Injector;
import org.eclipse.m2m.atl.engine.injectors.xml.XMLInjector;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;

public abstract class ModelLoader {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    protected static Map loadedModels = new HashMap();
    private Map injectors = new HashMap();
    private Map extractors;

    public ModelLoader() {
        this.injectors.put("xml", XMLInjector.class);
        this.extractors = new HashMap();
        this.extractors.put("xml", XMLExtractor.class);
    }

    public void addInjector(String prefix, Class inj) {
        this.injectors.put(prefix, inj);
    }

    public void addExtractor(String prefix, Class ext) {
        this.extractors.put(prefix, ext);
    }

    public abstract ASMModel loadModel(String var1, ASMModel var2, InputStream var3);

    protected abstract ASMModel realLoadModel(String var1, ASMModel var2, String var3);

    public ASMModel loadModel(String name, ASMModel metamodel, String href) {
        ASMModel ret = null;
        href = href.replaceAll("\\\\:", "<colon>");
        String[] ss = href.split(":");
        int i = 0;
        while (i < ss.length) {
            ss[i] = ss[i].replaceAll("<colon>", ":");
            ++i;
        }
        if (ss.length == 1) {
            ret = this.realLoadModel(name, metamodel, ss[0]);
        } else if (ss[0].equals("xmi")) {
            String url = ss[ss.length - 1];
            ret = this.realLoadModel(name, metamodel, url);
        } else {
            ret = this.newModel(name, ss[ss.length - 1], metamodel);
            this.inject(ret, ss[0], ss.length == 3 ? ss[1] : null, ss[ss.length - 1], null);
        }
        loadedModels.put(name, ret);
        return ret;
    }

    public ASMModelElement inject(ASMModel ret, String kind, String params, String uri, InputStream in) {
        ASMModelElement root = null;
        try {
            Class injectorClass;
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            if (uri != null) {
                try {
                    in = new FileInputStream(uri);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    in = new URL(uri).openStream();
                }
            }
            if ((injectorClass = (Class)this.injectors.get(kind)) != null) {
                Injector inj = (Injector)injectorClass.newInstance();
                if (params != null) {
                    String[] sparams = params.split(",");
                    HashMap<String, String> args = new HashMap<String, String>();
                    int i = 0;
                    while (i < sparams.length) {
                        String p = sparams[i];
                        String[] pair = p.split("=");
                        if (pair.length == 1) {
                            if (p.indexOf("=") == -1) {
                                args.put("name", pair[0]);
                            } else {
                                args.put(pair[0], "");
                            }
                        } else {
                            args.put(pair[0], pair[1]);
                        }
                        ++i;
                    }
                    Map types = inj.getParameterTypes();
                    for (String pname : types.keySet()) {
                        String type = (String)types.get(pname);
                        if (type.equals("String")) {
                            String val = (String)args.get(pname);
                            if (val != null) {
                                paramsMap.put(pname, val);
                                continue;
                            }
                            logger.warning("could not find value for parameter \"" + pname + "\" : " + type + ".");
                            continue;
                        }
                        if (type.startsWith("Model:")) {
                            paramsMap.put(pname, loadedModels.get(args.get(pname)));
                            continue;
                        }
                        if (type.equals("RandomAccessFile") && uri != null) {
                            paramsMap.put(pname, new RandomAccessFile(uri, "r"));
                            continue;
                        }
                        logger.warning("unknown parameter type \"" + type + "\" of \"" + pname + "\".");
                    }
                }
                root = inj.inject(ret, in, paramsMap);
                ret.setIsTarget(false);
            } else {
                logger.severe("ERROR: could not find injector for \"" + kind + "\"");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return root;
    }

    public abstract ASMModel newModel(String var1, ASMModel var2);

    public abstract ASMModel newModel(String var1, String var2, ASMModel var3);

    protected abstract void setParameter(String var1, Object var2);

    protected abstract void realSave(ASMModel var1, String var2);

    public void save(ASMModel model, String href) {
        String[] ss = href.split(":");
        if (ss.length == 1) {
            this.realSave(model, href);
        } else if (ss[0].equals("xmi")) {
            String url = ss[ss.length - 1];
            this.setParameter("useIDs", "false");
            this.setParameter("removeIDs", "false");
            this.setParameter("encoding", "ISO-8859-1");
            this.setParameter("xmiVersion", null);
            if (ss.length == 3) {
                String[] sparams = ss[1].split(",");
                int i = 0;
                while (i < sparams.length) {
                    String p = sparams[i];
                    String[] pair = p.split("=");
                    if (pair.length == 2) {
                        this.setParameter(pair[0], pair[1]);
                    }
                    ++i;
                }
            }
            this.realSave(model, url);
        } else {
            this.extract(model, ss[0], ss.length == 3 ? ss[1] : null, ss[ss.length - 1], null);
        }
    }

    public void extract(ASMModel model, String kind, String params, String uri, OutputStream out) {
        try {
            Class extractorClass;
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            if (uri != null) {
                out = new FileOutputStream(uri);
            }
            if ((extractorClass = (Class)this.extractors.get(kind)) != null) {
                Extractor ext = (Extractor)extractorClass.newInstance();
                if (params != null) {
                    String[] sparams = params.split(",");
                    HashMap<String, String> args = new HashMap<String, String>();
                    int i = 0;
                    while (i < sparams.length) {
                        String p = sparams[i];
                        String[] pair = p.split("=");
                        if (pair.length == 1) {
                            if (p.indexOf("=") == -1) {
                                args.put("name", pair[0]);
                            } else {
                                args.put(pair[0], "");
                            }
                        } else {
                            args.put(pair[0], pair[1]);
                        }
                        ++i;
                    }
                    Map types = ext.getParameterTypes();
                    for (String pname : types.keySet()) {
                        String type = (String)types.get(pname);
                        if (type.equals("String")) {
                            String val = (String)args.get(pname);
                            if (val != null) {
                                paramsMap.put(pname, val);
                                continue;
                            }
                            logger.warning("could not find value for parameter \"" + pname + "\" : " + type + ".");
                            continue;
                        }
                        if (type.startsWith("Model:")) {
                            paramsMap.put(pname, (String)loadedModels.get(args.get(pname)));
                            continue;
                        }
                        logger.warning("unknown parameter type \"" + type + "\" of \"" + pname + "\".");
                    }
                }
                ext.extract(model, out, paramsMap);
            } else {
                logger.severe("ERROR: could not find extractor for \"" + kind + "\"");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public abstract ASMModel getMOF();
}

