/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.perspective.compatibility;

import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.m2m.atl.adt.perspective.AtlPerspectiveMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CompatibilityUtils {
    public static final String oldNatureId = "org.atl.eclipse.adt.builder.atlNature";
    public static final String newNatureId = "org.eclipse.m2m.atl.adt.builder.atlNature";
    public static final String oldBuilderId = "org.atl.eclipse.adt.builder.atlBuilder";
    public static final String newBuilderId = "org.eclipse.m2m.atl.adt.builder.atlBuilder";
    public static final String oldConfigId = "org.atl.eclipse.adt.launching.atlTransformation";
    public static final String newConfigId = "org.eclipse.m2m.atl.adt.launching.atlTransformation";

    public static IProject[] getProjects() throws CoreException {
        ArrayList<IProject> res = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            Object[] ids;
            IProject project = projects[i];
            if (project.isOpen() && CompatibilityUtils.arrayContains(ids = project.getDescription().getNatureIds(), oldNatureId) && !CompatibilityUtils.arrayContains(ids, newNatureId)) {
                res.add(project);
            }
            ++i;
        }
        return res.toArray(new IProject[res.size()]);
    }

    private static boolean arrayContains(Object[] array, Object o) {
        int i = 0;
        while (i < array.length) {
            if (o.equals(array[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static ILaunchConfiguration[] getConfigurations() throws CoreException {
        ArrayList<ILaunchConfiguration> res = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
        int i = 0;
        while (i < configs.length) {
            ILaunchConfiguration config = configs[i];
            if (config.getType().getIdentifier().equals(oldConfigId)) {
                res.add(config);
            }
            ++i;
        }
        return res.toArray(new ILaunchConfiguration[res.size()]);
    }

    public static void convertProjects(Object[] projects) throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.beginTask(AtlPerspectiveMessages.getString("CompatibilityUtils.0"), -1);
        int i = 0;
        while (i < projects.length) {
            IProject project = (IProject)projects[i];
            monitor.subTask(String.valueOf(AtlPerspectiveMessages.getString("CompatibilityUtils.1")) + project.getName());
            IProjectDescription desc = project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            String[] natures = desc.getNatureIds();
            ICommand[] newCommands = new ICommand[commands.length];
            int j = 0;
            while (j < commands.length) {
                ICommand command = commands[j];
                if (command.getBuilderName().equals(oldBuilderId)) {
                    command.setBuilderName(newBuilderId);
                    monitor.subTask(AtlPerspectiveMessages.getString("CompatibilityUtils.2"));
                }
                newCommands[j] = command;
                ++j;
            }
            desc.setBuildSpec(newCommands);
            String[] newNatures = new String[natures.length];
            int j2 = 0;
            while (j2 < natures.length) {
                String nature = natures[j2];
                if (nature.equals(oldNatureId)) {
                    nature = newNatureId;
                    monitor.subTask(AtlPerspectiveMessages.getString("CompatibilityUtils.3"));
                }
                newNatures[j2] = nature;
                ++j2;
            }
            desc.setNatureIds(newNatures);
            project.setDescription(desc, 64, null);
            project.refreshLocal(2, null);
            monitor.done();
            ++i;
        }
    }

    public static boolean convertConfigurations(Object[] configurations) throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.beginTask(AtlPerspectiveMessages.getString("CompatibilityUtils.4"), -1);
        boolean needToRestart = false;
        int i = 0;
        while (i < configurations.length) {
            ILaunchConfiguration conf = (ILaunchConfiguration)configurations[i];
            monitor.subTask(String.valueOf(AtlPerspectiveMessages.getString("CompatibilityUtils.5")) + conf.getName());
            if (conf.getType().getIdentifier().equals(oldConfigId)) {
                IFile ifile = conf.getFile();
                File file = conf.getLocation().toFile();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    DocumentBuilder docBuilder = factory.newDocumentBuilder();
                    Document document = docBuilder.parse(file);
                    Element root = (Element)document.getFirstChild();
                    if (root.getAttribute("type").equals(oldConfigId)) {
                        root.setAttribute("type", newConfigId);
                        monitor.subTask(String.valueOf(AtlPerspectiveMessages.getString("CompatibilityUtils.8")) + conf.getName());
                    }
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    StreamResult result = new StreamResult(file);
                    DOMSource source = new DOMSource(document);
                    transformer.transform(source, result);
                }
                catch (ParserConfigurationException e1) {
                    e1.printStackTrace();
                }
                catch (Throwable throwable) {}
                if (ifile != null) {
                    ifile.refreshLocal(2, (IProgressMonitor)monitor);
                } else {
                    needToRestart = true;
                }
            }
            monitor.done();
            ++i;
        }
        return needToRestart;
    }
}

