/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.m2m.atl.adt.ui.editor.AtlEditor;
import org.eclipse.m2m.atl.adt.ui.editor.IOccurrencesFinder;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlModelAnalyser;
import org.eclipse.m2m.atl.adt.ui.text.atl.OpenDeclarationUtils;

public class AtlOccurrencesFinder
implements IOccurrencesFinder {
    private List<IOccurrencesFinder.OccurrenceLocation> fResult;
    private IDocument document;
    private AtlEditor editor;
    private AtlModelAnalyser analyser;
    private IRegion selection;
    private String fDescription;
    private int fFlag = 8;
    private boolean fQuit = false;

    public AtlOccurrencesFinder(AtlEditor editor, IDocument document) {
        this.editor = editor;
        this.document = document;
        this.fResult = new ArrayList<IOccurrencesFinder.OccurrenceLocation>();
    }

    public String initialize(IRegion selection) {
        this.selection = selection;
        return null;
    }

    public String getJobLabel() {
        return null;
    }

    public String getUnformattedPluralLabel() {
        return null;
    }

    public String getUnformattedSingularLabel() {
        return null;
    }

    public String getElementName() {
        return null;
    }

    public IOccurrencesFinder.OccurrenceLocation[] getOccurrences() {
        try {
            this.performSearch();
        }
        catch (BadLocationException badLocationException) {}
        if (this.fResult.isEmpty()) {
            return null;
        }
        return this.fResult.toArray(new IOccurrencesFinder.OccurrenceLocation[this.fResult.size()]);
    }

    private void performSearch() throws BadLocationException {
        this.analyser = this.editor.getModelAnalyser();
        if (this.selection != null) {
            EObject selectedObject = this.analyser.getLocatedElement(this.selection.getOffset());
            if (AtlOccurrencesFinder.oclIsKindOf(selectedObject, "VariableExp")) {
                this.variableExpSearch(selectedObject);
            } else if (AtlOccurrencesFinder.oclIsKindOf(selectedObject, "OclModelElement")) {
                this.oclModelElementSearch(selectedObject);
            } else if (AtlOccurrencesFinder.oclIsKindOf(selectedObject, "Binding")) {
                this.bindingSearch(selectedObject);
            } else if (AtlOccurrencesFinder.oclIsKindOf(selectedObject, "NavigationOrAttributeCallExp")) {
                this.navigationOrAttributeCallExpSearch(selectedObject);
            } else if (AtlOccurrencesFinder.oclIsKindOf(selectedObject, "OperationCallExp")) {
                this.operationCallExpSearch(selectedObject);
            } else if (AtlOccurrencesFinder.oclIsKindOf(selectedObject, "VariableDeclaration")) {
                this.variableDeclarationSearch(selectedObject);
            } else if (AtlOccurrencesFinder.oclIsKindOf(selectedObject, "OclModel")) {
                this.oclModelSearch(selectedObject);
            } else if (AtlOccurrencesFinder.oclIsKindOf(selectedObject, "EnumLiteralExp")) {
                this.enumLiteralExpSearch(selectedObject);
            } else if (AtlOccurrencesFinder.oclIsKindOf(selectedObject, "Operation")) {
                this.operationSearch(selectedObject);
            } else if (AtlOccurrencesFinder.oclIsKindOf(selectedObject, "Attribute")) {
                this.attributeSearch(selectedObject);
            } else if (AtlOccurrencesFinder.oclIsKindOf(selectedObject, "IteratorExp")) {
                this.iteratorExpSearch(selectedObject);
            } else if (AtlOccurrencesFinder.oclIsKindOf(selectedObject, "IterateExp")) {
                this.iterateExpSearch(selectedObject);
            } else if (AtlOccurrencesFinder.oclIsKindOf(selectedObject, "Query")) {
                this.querySearch(selectedObject);
            } else if (AtlOccurrencesFinder.oclIsKindOf(selectedObject, "OclType")) {
                this.oclTypeSearch(selectedObject);
            } else {
                this.selection = null;
                this.fResult = new ArrayList<IOccurrencesFinder.OccurrenceLocation>();
                return;
            }
            if (!this.fQuit) {
                this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(this.selection.getOffset(), this.selection.getLength(), this.fFlag, this.fDescription));
            }
            this.fQuit = false;
        }
    }

    public static Object eGet(EObject self, String featureName) {
        EStructuralFeature feature = self.eClass().getEStructuralFeature(featureName);
        if (feature != null) {
            return self.eGet(feature);
        }
        return null;
    }

    public static boolean oclIsKindOf(EObject element, String testedElementName) {
        if (element != null) {
            if (element.eClass().getName().equals(testedElementName)) {
                return true;
            }
            EList types = element.eClass().getEAllSuperTypes();
            for (EClass object : types) {
                if (!object.getName().equals(testedElementName)) continue;
                return true;
            }
        }
        return false;
    }

    public IRegion getRegionFromElement(EObject element) throws BadLocationException {
        if (element == null) {
            return null;
        }
        String text = this.analyser.getHelper().getText(element, 0);
        int[] offsets = this.analyser.getHelper().getElementOffsets(element, 0);
        if (offsets == null) {
            return null;
        }
        int offset = offsets[0];
        if (AtlOccurrencesFinder.oclIsKindOf(element, "IteratorExp") || AtlOccurrencesFinder.oclIsKindOf(element, "NavigationOrAttributeCallExp") || AtlOccurrencesFinder.oclIsKindOf(element, "OclModelElement")) {
            String name = (String)AtlOccurrencesFinder.eGet(element, "name");
            offset = offsets[0] + text.lastIndexOf(name);
        } else if (AtlOccurrencesFinder.oclIsKindOf(element, "CollectionOperationCallExp") || AtlOccurrencesFinder.oclIsKindOf(element, "OperationCallExp")) {
            String name = (String)AtlOccurrencesFinder.eGet(element, "operationName");
            offset = offsets[0] + text.lastIndexOf(name);
        } else if (AtlOccurrencesFinder.oclIsKindOf(element, "IterateExp")) {
            offset = offsets[0] + text.lastIndexOf("iterate");
        }
        return OpenDeclarationUtils.findWord(this.document, offset);
    }

    public void browseModel(EObject element, String name, String featureName, String declarationType, String useType, String displayType) throws BadLocationException {
        IRegion varRegion = null;
        for (EObject obj : element.eContents()) {
            String subName = (String)AtlOccurrencesFinder.eGet(obj, featureName);
            if (subName == null && !featureName.equals("name")) {
                subName = (String)AtlOccurrencesFinder.eGet(obj, "name");
            }
            if (useType.equals("IterateExp") && AtlOccurrencesFinder.oclIsKindOf(obj, "IterateExp")) {
                subName = name;
            }
            if (subName != null && subName.equals(name)) {
                varRegion = this.getRegionFromElement(obj);
                if (AtlOccurrencesFinder.oclIsKindOf(obj, declarationType)) {
                    this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(varRegion.getOffset(), varRegion.getLength(), 1, "Declaration of " + displayType + " '" + name + "'"));
                } else if (AtlOccurrencesFinder.oclIsKindOf(obj, useType)) {
                    this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(varRegion.getOffset(), varRegion.getLength(), 8, "Occurrence of " + displayType + " '" + name + "'"));
                }
            }
            if (obj.eContents() == null || obj.eContents().size() <= 0) continue;
            this.browseModel(obj, name, featureName, declarationType, useType, displayType);
        }
    }

    public void browseModelForType(EObject element, String name) throws BadLocationException {
        IRegion varRegion = null;
        for (EObject obj : element.eContents()) {
            String subName = this.analyser.getHelper().getText(obj, 0);
            if (subName != null && subName.equals(name)) {
                varRegion = this.getRegionFromElement(obj);
                this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(varRegion.getOffset(), varRegion.getLength(), 8, "Occurrence of type '" + name + "'"));
            }
            if (obj.eContents() == null || obj.eContents().size() <= 0) continue;
            this.browseModelForType(obj, name);
        }
    }

    private void variableExpSearch(EObject element) throws BadLocationException {
        EObject referredVariable = (EObject)AtlOccurrencesFinder.eGet(element, "referredVariable");
        String name = (String)AtlOccurrencesFinder.eGet(referredVariable, "varName");
        IRegion varRegion = this.getRegionFromElement(referredVariable);
        this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(varRegion.getOffset(), varRegion.getLength(), 1, "Declaration of variable '" + name + "'"));
        for (EObject obj : referredVariable.eCrossReferences()) {
            varRegion = this.getRegionFromElement(obj);
            if (obj == element) continue;
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(varRegion.getOffset(), varRegion.getLength(), 8, "Occurrence of variable '" + name + "'"));
        }
        this.fDescription = "Occurrence of variable '" + name + "'";
        this.fFlag = 8;
    }

    private void oclModelElementSearch(EObject element) throws BadLocationException {
        String name = (String)AtlOccurrencesFinder.eGet(element, "name");
        this.browseModel(this.analyser.getRoot(), name, "name", "", "OclModelElement", "model element");
        this.fDescription = "Occurrence of model element '" + name + "'";
        this.fFlag = 8;
    }

    private void bindingSearch(EObject element) throws BadLocationException {
        String name = (String)AtlOccurrencesFinder.eGet(element, "propertyName");
        this.browseModel(element.eContainer(), name, "propertyName", "", "Binding", "binding");
        this.fDescription = "Occurrence of binding '" + name + "'";
        this.fFlag = 8;
    }

    private void navigationOrAttributeCallExpSearch(EObject element) throws BadLocationException {
        String name = (String)AtlOccurrencesFinder.eGet(element, "name");
        this.browseModel(this.analyser.getRoot(), name, "name", "Attribute", "NavigationOrAttributeCallExp", "attribute");
        this.fDescription = "Occurrence of attribute '" + name + "'";
        this.fFlag = 8;
    }

    private void operationCallExpSearch(EObject element) throws BadLocationException {
        String name = (String)AtlOccurrencesFinder.eGet(element, "operationName");
        if (name.equals("and") || name.equals("or")) {
            this.fQuit = true;
            return;
        }
        this.browseModel(this.analyser.getRoot(), name, "operationName", "Operation", "OperationCallExp", "operation");
        this.fDescription = "Occurrence of operation '" + name + "'";
        this.fFlag = 8;
    }

    private void variableDeclarationSearch(EObject element) throws BadLocationException {
        String name = (String)AtlOccurrencesFinder.eGet(element, "varName");
        if (name.equals("self") || name.equals("thisModule")) {
            this.fQuit = true;
            return;
        }
        IRegion varRegion = null;
        for (EObject obj : element.eCrossReferences()) {
            varRegion = this.getRegionFromElement(obj);
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(varRegion.getOffset(), varRegion.getLength(), 8, "Occurrence of variable '" + name + "'"));
        }
        this.fDescription = "Declaration of variable '" + name + "'";
        this.fFlag = 1;
    }

    private void oclModelSearch(EObject element) throws BadLocationException {
        String name = (String)AtlOccurrencesFinder.eGet(element, "name");
        if (name.equals("OUT") || name.equals("IN")) {
            this.fQuit = true;
            return;
        }
        IRegion varRegion = null;
        for (EObject model : this.analyser.getRoot().eResource().getContents()) {
            String subName;
            varRegion = this.getRegionFromElement(model);
            if (!AtlOccurrencesFinder.oclIsKindOf(model, "OclModel") || !(subName = (String)AtlOccurrencesFinder.eGet(model, "name")).equals(name)) continue;
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(varRegion.getOffset(), varRegion.getLength(), 8, "Occurrence of model '" + name + "'"));
        }
        this.fDescription = "Occurrence of model '" + name + "'";
        this.fFlag = 8;
    }

    private void enumLiteralExpSearch(EObject element) throws BadLocationException {
        String name = (String)AtlOccurrencesFinder.eGet(element, "name");
        this.browseModel(this.analyser.getRoot(), name, "name", "", "EnumLiteralExp", "literal");
        this.fDescription = "Occurrence of literal '" + name + "'";
        this.fFlag = 8;
    }

    private void operationSearch(EObject element) throws BadLocationException {
        String name = (String)AtlOccurrencesFinder.eGet(element, "name");
        this.browseModel(this.analyser.getRoot(), name, "operationName", "Operation", "OperationCallExp", "operation");
        this.fDescription = "Declaration of operation '" + name + "'";
        this.fFlag = 1;
    }

    private void attributeSearch(EObject element) throws BadLocationException {
        String name = (String)AtlOccurrencesFinder.eGet(element, "name");
        this.browseModel(this.analyser.getRoot(), name, "name", "Attribute", "NavigationOrAttributeCallExp", "attribute");
        this.fDescription = "Declaration of attribute '" + name + "'";
        this.fFlag = 1;
    }

    private void iteratorExpSearch(EObject element) throws BadLocationException {
        String name = (String)AtlOccurrencesFinder.eGet(element, "name");
        this.browseModel(this.analyser.getRoot(), name, "name", "", "IteratorExp", "iterator");
        this.fDescription = "Occurrence of iterator '" + name + "'";
        this.fFlag = 8;
    }

    private void iterateExpSearch(EObject element) throws BadLocationException {
        this.browseModel(this.analyser.getRoot(), "iterate", "name", "", "IterateExp", "iterator");
        this.fDescription = "Occurrence of iterator 'iterate'";
        this.fFlag = 8;
    }

    private void querySearch(EObject element) throws BadLocationException {
        this.fQuit = true;
    }

    private void oclTypeSearch(EObject element) throws BadLocationException {
        String name = this.analyser.getHelper().getText(element, 0);
        this.browseModelForType(this.analyser.getRoot(), name);
        this.fDescription = "Occurrence of type '" + name + "'";
        this.fFlag = 8;
    }

    public int getSearchKind() {
        return 0;
    }

    public String getID() {
        return null;
    }
}

