/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTSyntheticNode;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTSyntheticNodeAccess;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtEnvironmentBase;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalTypesUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ValidationMessages;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.cst.ImportCS;
import org.eclipse.m2m.internal.qvt.oml.cst.LibraryCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingDeclarationCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingMethodCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ModelTypeCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ModulePropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.TransformationHeaderCS;
import org.eclipse.m2m.internal.qvt.oml.cst.UnitCS;
import org.eclipse.m2m.internal.qvt.oml.cst.temp.ScopedNameCS;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImportKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ReturnExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.Typedef;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.CollectionTypeCS;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.PrimitiveTypeCS;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.cst.TupleTypeCS;
import org.eclipse.ocl.cst.TypeCS;
import org.eclipse.ocl.cst.VariableCS;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.types.BagType;
import org.eclipse.ocl.types.OrderedSetType;
import org.eclipse.ocl.types.PrimitiveType;
import org.eclipse.ocl.types.SequenceType;
import org.eclipse.ocl.types.SetType;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalParserUtil {
    private static final String NAMESPACE_SEPARATOR = ".";
    private static final String QVT_NAMESPACE_URI = "http://www.eclipse.org/m2m/1.0.0/QVT";
    private static final String QVT_IS_ABSTACT = "abstract";
    private static final String QVT_IS_STATIC = "static";
    private static final String QVT_INIT_EXPRESSION_URI = "http://www.eclipse.org/m2m/1.0.0/QVT/initExp";
    private static final String QVT_DEPRECATED = "deprecated";
    private static final String QVT_UNSUPPORTED = "unsupported";

    private QvtOperationalParserUtil() {
    }

    public static EClassifier getContextualType(ImperativeOperation operation) {
        VarParameter context = operation.getContext();
        return context != null ? context.getEType() : null;
    }

    public static boolean isContextual(ImperativeOperation operation) {
        return QvtOperationalParserUtil.getContextualType(operation) != null;
    }

    public static String getMappingStringRepresentation(MappingMethodCS operationCS) {
        MappingDeclarationCS mappingDeclarationCS = operationCS.getMappingDeclarationCS();
        if (mappingDeclarationCS != null) {
            StringBuilder buf = new StringBuilder();
            if (mappingDeclarationCS.getContextType() != null) {
                buf.append(QvtOperationalParserUtil.getStringRepresentation(mappingDeclarationCS.getContextType()));
                buf.append("::");
            }
            if (mappingDeclarationCS.getSimpleNameCS() != null) {
                buf.append(mappingDeclarationCS.getSimpleNameCS().getValue());
            }
            return buf.toString();
        }
        return "";
    }

    public static String getStringRepresentation(PathNameCS pathName, String pathSeparator) {
        return QvtOperationalParserUtil.getStringRepresentation((List<String>)pathName.getSequenceOfNames(), pathSeparator);
    }

    public static String getStringRepresentation(PathNameCS pathName) {
        return QvtOperationalParserUtil.getStringRepresentation((List<String>)pathName.getSequenceOfNames(), "::");
    }

    public static String getStringRepresentation(List<String> pathName, String pathSeparator) {
        StringBuffer buffer = null;
        for (String element : pathName) {
            if (buffer != null) {
                buffer.append(pathSeparator);
            } else {
                buffer = new StringBuffer();
            }
            buffer.append(element);
        }
        return buffer == null ? "" : buffer.toString();
    }

    public static String getStringRepresentation(ScopedNameCS scopedNameCS) {
        StringBuilder buf = new StringBuilder();
        if (scopedNameCS.getTypeCS() != null) {
            buf.append(QvtOperationalParserUtil.getStringRepresentation(scopedNameCS.getTypeCS()));
            buf.append("::");
        }
        if (scopedNameCS.getName() != null) {
            buf.append(scopedNameCS.getName());
        }
        return buf.toString();
    }

    public static String getStringRepresentation(TypeCS typeCS) {
        if (typeCS instanceof PrimitiveTypeCS) {
            return ((PrimitiveTypeCS)typeCS).getValue();
        }
        if (typeCS instanceof PathNameCS) {
            return QvtOperationalParserUtil.getStringRepresentation((PathNameCS)typeCS, "::");
        }
        if (typeCS instanceof CollectionTypeCS) {
            return String.valueOf(((CollectionTypeCS)typeCS).getCollectionTypeIdentifier().getName()) + "(" + QvtOperationalParserUtil.getStringRepresentation(((CollectionTypeCS)typeCS).getTypeCS()) + ")";
        }
        if (typeCS instanceof TupleTypeCS) {
            String name = "Tuple(";
            for (VariableCS var : ((TupleTypeCS)typeCS).getVariables()) {
                name = String.valueOf(name) + var.getName();
                name = String.valueOf(name) + ",";
            }
            name = String.valueOf(name) + ")";
            return name;
        }
        return "";
    }

    public static void setInitExpression(EStructuralFeature moduleFeature, OCLExpression<EClassifier> expression) {
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource(QVT_INIT_EXPRESSION_URI);
        annotation.getContents().add(expression);
        moduleFeature.getEAnnotations().add((Object)annotation);
    }

    public static OCLExpression<EClassifier> getInitExpression(EStructuralFeature feature) {
        EAnnotation annotation = feature.getEAnnotation(QVT_INIT_EXPRESSION_URI);
        if (annotation != null) {
            for (EObject referredObj : annotation.getContents()) {
                if (!(referredObj instanceof OCLExpression)) continue;
                return (OCLExpression)referredObj;
            }
        }
        return null;
    }

    public static Module getOwningModule(ImperativeOperation operation) {
        if (operation.getEContainingClass() instanceof Module) {
            return (Module)operation.getEContainingClass();
        }
        return null;
    }

    public static Module getOwningModule(EOperation operation) {
        EClass owner = operation.getEContainingClass();
        if (owner == null) {
            return null;
        }
        if (owner instanceof Module) {
            return (Module)owner;
        }
        EPackage owningPackage = owner.getEPackage();
        if (owningPackage == null) {
            return null;
        }
        if (owner instanceof Typedef) {
            if (owningPackage instanceof Module) {
                return (Module)owningPackage;
            }
            EPackage superOwner = owningPackage.getESuperPackage();
            if (superOwner instanceof Module) {
                return (Module)superOwner;
            }
        }
        if (owningPackage instanceof Module) {
            return (Module)owningPackage;
        }
        return null;
    }

    public static List<EOperation> getOwnedOperations(Module module) {
        ArrayList<EOperation> result = new ArrayList<EOperation>(module.getEOperations().size());
        for (EOperation operation : module.getEOperations()) {
            if (!(operation instanceof ImperativeOperation)) continue;
            result.add(operation);
        }
        return result;
    }

    public static void collectAllImports(CompiledUnit unit, Set<CompiledUnit> result) {
        for (CompiledUnit importedUnit : unit.getCompiledImports()) {
            if (!result.contains(importedUnit)) {
                QvtOperationalParserUtil.collectAllImports(importedUnit, result);
            }
            result.add(importedUnit);
        }
    }

    public static void collectAllImports(Module module, Set<Module> result) {
        QvtOperationalParserUtil.collectAllImportsByKind(module, result, null);
    }

    public static Set<Module> collectAllImportsByKind(Module module, Set<Module> result, ImportKind importKind) {
        if (result == null) {
            result = new HashSet<Module>();
        }
        for (ModuleImport imp : module.getModuleImport()) {
            if (imp == null || imp.getImportedModule() == null || importKind != null && imp.getKind() != importKind) continue;
            if (!result.contains(imp.getImportedModule())) {
                QvtOperationalParserUtil.collectAllImportsByKind(imp.getImportedModule(), result, importKind);
            }
            result.add(imp.getImportedModule());
        }
        return result;
    }

    public static boolean isAssignableToFrom(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, EClassifier variableType, EClassifier initialiserType) {
        if (variableType == null) {
            return false;
        }
        if (initialiserType == null) {
            return false;
        }
        if (variableType == env.getOCLStandardLibrary().getUnlimitedNatural() && initialiserType == env.getOCLStandardLibrary().getInteger()) {
            return true;
        }
        if (variableType instanceof EDataType && initialiserType instanceof EDataType && ((EDataType)variableType).getInstanceClass() == ((EDataType)initialiserType).getInstanceClass()) {
            return true;
        }
        return (TypeUtil.getRelationship(env, (Object)variableType, (Object)initialiserType) & 5) != 0;
    }

    public static boolean isAssignableElementToFrom(EClassifier variableType, EClassifier initialiserType) {
        if (variableType == null) {
            return false;
        }
        if (initialiserType == null) {
            return false;
        }
        if (variableType == initialiserType) {
            return true;
        }
        return initialiserType instanceof EClass && variableType instanceof EClass && ((EClass)variableType).isSuperTypeOf((EClass)initialiserType);
    }

    public static String getMappingModuleSimpleName(TransformationHeaderCS headerCS) {
        EList moduleName = headerCS.getPathNameCS().getSequenceOfNames();
        if (moduleName.isEmpty()) {
            return "";
        }
        return (String)moduleName.get(moduleName.size() - 1);
    }

    public static boolean hasSimpleName(TransformationHeaderCS headerCS) {
        if (headerCS.getPathNameCS() != null) {
            return headerCS.getPathNameCS().getSequenceOfNames().size() <= 1;
        }
        return false;
    }

    public static String getMappingModuleQualifiedName(TransformationHeaderCS headerCS) {
        String namespace = QvtOperationalParserUtil.getMappingModuleNamespace(headerCS);
        if (namespace == null || namespace.length() == 0) {
            return QvtOperationalParserUtil.getMappingModuleSimpleName(headerCS);
        }
        return String.valueOf(namespace) + NAMESPACE_SEPARATOR + QvtOperationalParserUtil.getMappingModuleSimpleName(headerCS);
    }

    public static String getMappingModuleNamespace(TransformationHeaderCS headerCS) {
        StringBuilder unitNamespace = new StringBuilder();
        EList moduleName = headerCS.getPathNameCS().getSequenceOfNames();
        if (moduleName.size() > 1) {
            int i = 0;
            int sz = moduleName.size();
            while (i < sz - 1) {
                if (i > 0) {
                    unitNamespace.append(NAMESPACE_SEPARATOR);
                }
                unitNamespace.append((String)moduleName.get(i));
                ++i;
            }
        }
        return unitNamespace.toString();
    }

    public static boolean isTypeCast(EOperation operation) {
        if (operation != null) {
            return "oclAsType".equals(operation.getName());
        }
        return false;
    }

    public static boolean isIncorrectCast(EClassifier sourceType, EClassifier targetType) {
        if (sourceType == null || targetType == null) {
            return false;
        }
        if (sourceType instanceof PrimitiveType && "Real".equals(((PrimitiveType)sourceType).getName())) {
            return targetType instanceof PrimitiveType && "Integer".equals(((PrimitiveType)targetType).getName());
        }
        if (sourceType instanceof SetType) {
            return !(targetType instanceof SetType);
        }
        if (sourceType instanceof BagType) {
            return !(targetType instanceof BagType);
        }
        if (sourceType instanceof SequenceType) {
            return !(targetType instanceof SequenceType);
        }
        if (sourceType instanceof OrderedSetType) {
            return !(targetType instanceof OrderedSetType) && !(targetType instanceof SetType);
        }
        return false;
    }

    public static boolean validateAssignment(boolean isProperty, String leftName, EClassifier leftType, EClassifier rightType, boolean isIncremental, CSTNode cstNode, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env) {
        if (isIncremental) {
            if (!(leftType instanceof CollectionType)) {
                QvtOperationalUtil.reportError(env, NLS.bind((String)ValidationMessages.SemanticUtil_3, (Object[])new Object[]{leftName}), cstNode);
                return false;
            }
            EClassifier baseType = (EClassifier)((CollectionType)leftType).getElementType();
            EClassifier actualType = rightType;
            if (actualType instanceof CollectionType) {
                actualType = (EClassifier)((CollectionType)actualType).getElementType();
            }
            if (!QvtOperationalParserUtil.isAssignableToFrom(env, baseType, actualType)) {
                QvtOperationalUtil.reportError(env, NLS.bind((String)ValidationMessages.SemanticUtil_5, (Object[])new Object[]{leftName, QvtOperationalTypesUtil.getTypeFullName(baseType), QvtOperationalTypesUtil.getTypeFullName(actualType)}), cstNode);
                return false;
            }
        } else if (isProperty && leftType instanceof CollectionType) {
            EClassifier baseType = (EClassifier)((CollectionType)leftType).getElementType();
            EClassifier actualType = rightType;
            if (actualType instanceof CollectionType) {
                actualType = (EClassifier)((CollectionType)actualType).getElementType();
            }
            if (!QvtOperationalParserUtil.isAssignableToFrom(env, baseType, actualType)) {
                QvtOperationalUtil.reportError(env, NLS.bind((String)ValidationMessages.SemanticUtil_5, (Object[])new Object[]{leftName, QvtOperationalTypesUtil.getTypeFullName(baseType), QvtOperationalTypesUtil.getTypeFullName(actualType)}), cstNode);
                return false;
            }
        } else if (!QvtOperationalParserUtil.isAssignableToFrom(env, leftType, rightType)) {
            QvtOperationalUtil.reportError(env, NLS.bind((String)ValidationMessages.SemanticUtil_8, (Object[])new Object[]{leftName, QvtOperationalTypesUtil.getTypeFullName(leftType), QvtOperationalTypesUtil.getTypeFullName(rightType)}), cstNode);
            return false;
        }
        return true;
    }

    public static boolean validateVariableModification(Variable<EClassifier, EParameter> variable, CSTNode varNodeCS, EStructuralFeature varPathNamePropertyASTopt, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, boolean isDirectModification) {
        EParameter representedParameter = (EParameter)variable.getRepresentedParameter();
        if (representedParameter instanceof VarParameter) {
            VarParameter parameter = (VarParameter)representedParameter;
            boolean isDirectInoutModification = parameter.getKind() == DirectionKind.INOUT && isDirectModification;
            boolean isContextualPropertyAccessed = varPathNamePropertyASTopt instanceof ContextualProperty;
            if (isDirectInoutModification) {
                QvtOperationalUtil.reportError(env, NLS.bind((String)ValidationMessages.QvtOperationalParserUtil_inoutParamAssignmentError, (Object)parameter.getName()), varNodeCS);
                return false;
            }
            if (parameter.getKind() != DirectionKind.OUT && parameter.getKind() != DirectionKind.INOUT && !isContextualPropertyAccessed) {
                QvtOperationalUtil.reportError(env, NLS.bind((String)ValidationMessages.inputParameterModificationError, (Object)variable.getName()), varNodeCS);
                return false;
            }
        }
        return true;
    }

    public static ImperativeOperation getMainOperation(Module module) {
        if (module.getEntry() != null) {
            return module.getEntry();
        }
        for (EOperation nextOperation : module.getEOperations()) {
            if (!"main".equals(nextOperation.getName()) || !(nextOperation instanceof ImperativeOperation)) continue;
            return (ImperativeOperation)nextOperation;
        }
        return null;
    }

    public static boolean isOverloadableMapping(EOperation op, QvtOperationalEnv env) {
        EObject context = op.eContainer();
        if (env.getUMLReflection().getOwningClassifier((Object)op) instanceof Module) {
            return false;
        }
        return context instanceof EClass;
    }

    public static String safeGetMappingQualifiedName(QvtOperationalEnv env, MappingOperation mappingOperation) {
        if (mappingOperation != null) {
            StringBuilder buf = new StringBuilder();
            EClassifier ctxType = QvtOperationalParserUtil.getContextualType(mappingOperation);
            if (ctxType != null) {
                buf.append(QvtOperationalParserUtil.safeGetQualifiedName(env, ctxType));
                buf.append("::");
            }
            if (mappingOperation.getName() != null) {
                buf.append(mappingOperation.getName());
            }
            return buf.toString();
        }
        return "";
    }

    public static String safeGetQualifiedName(QvtOperationalEnv env, EClassifier type, String defaultValue) {
        if (type == null) {
            return defaultValue;
        }
        String result = defaultValue;
        if (type.getEPackage() == null) {
            result = env.getUMLReflection().getName((Object)type);
        } else {
            try {
                result = env.getUMLReflection().getQualifiedName((Object)type);
            }
            catch (RuntimeException runtimeException) {
                result = env.getUMLReflection().getName((Object)type);
            }
        }
        return result != null ? result : defaultValue;
    }

    public static String safeGetQualifiedName(QvtOperationalEnv env, EClassifier type) {
        return QvtOperationalParserUtil.safeGetQualifiedName(env, type, "");
    }

    public static <T> T findParentElement(ReturnExp returnExp, Class<T> type) {
        T result = null;
        EObject parent = returnExp.eContainer();
        while (parent != null) {
            if (type.isInstance(parent)) {
                result = type.cast(parent);
                break;
            }
            parent = parent.eContainer();
        }
        return result;
    }

    public static void markAsUnsupported(EModelElement element) {
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource(QVT_NAMESPACE_URI);
        annotation.getDetails().put((Object)QVT_UNSUPPORTED, null);
        element.getEAnnotations().add((Object)annotation);
    }

    public static boolean isUnsupported(EModelElement element) {
        EAnnotation annotation = element.getEAnnotation(QVT_NAMESPACE_URI);
        if (annotation != null) {
            return annotation.getDetails().containsKey((Object)QVT_UNSUPPORTED);
        }
        return false;
    }

    public static void markAsDeprecated(EModelElement element) {
        QvtOperationalParserUtil.markAsDeprecated(element, null);
    }

    public static void markAsDeprecated(EModelElement element, String replacingReferenceOpt) {
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource(QVT_NAMESPACE_URI);
        annotation.getDetails().put((Object)QVT_DEPRECATED, (Object)replacingReferenceOpt);
        element.getEAnnotations().add((Object)annotation);
    }

    public static boolean isDeprecated(EModelElement element) {
        EAnnotation annotation = element.getEAnnotation(QVT_NAMESPACE_URI);
        return annotation != null && annotation.getDetails().containsKey((Object)QVT_DEPRECATED);
    }

    public static String getDeprecatedBy(EModelElement element) {
        EAnnotation annotation = element.getEAnnotation(QVT_NAMESPACE_URI);
        if (annotation != null) {
            return (String)annotation.getDetails().get((Object)QVT_DEPRECATED);
        }
        return null;
    }

    public static void markAsAbstractMappingOperation(MappingOperation mappingOperation) {
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource(QVT_NAMESPACE_URI);
        annotation.getDetails().put((Object)QVT_IS_ABSTACT, (Object)Boolean.toString(true));
        mappingOperation.getEAnnotations().add((Object)annotation);
    }

    public static boolean isAbstractMappingOperation(MappingOperation mappingOperation) {
        EAnnotation annotation = mappingOperation.getEAnnotation(QVT_NAMESPACE_URI);
        if (annotation != null) {
            String value = (String)annotation.getDetails().get((Object)QVT_IS_ABSTACT);
            return Boolean.valueOf(value);
        }
        return false;
    }

    public static void markAsStaticOperation(EOperation operation) {
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource(QVT_NAMESPACE_URI);
        annotation.getDetails().put((Object)QVT_IS_STATIC, (Object)Boolean.toString(true));
        operation.getEAnnotations().add((Object)annotation);
    }

    public static boolean isStaticOperation(EOperation operation) {
        EAnnotation annotation = operation.getEAnnotation(QVT_NAMESPACE_URI);
        if (annotation != null) {
            String value = (String)annotation.getDetails().get((Object)QVT_IS_STATIC);
            return Boolean.valueOf(value);
        }
        return false;
    }

    public static CSTNode getPropertyProblemNode(EStructuralFeature feature, QvtOperationalEnv env) {
        SimpleNameCS nameCS;
        CSTNode cstNode = env.getASTMapping(feature);
        if (cstNode instanceof ModulePropertyCS && (nameCS = ((ModulePropertyCS)cstNode).getSimpleNameCS()) != null) {
            cstNode = nameCS;
        }
        return cstNode;
    }

    public static CSTNode getImperativeOperationProblemNode(MappingMethodCS methodCS) {
        MappingDeclarationCS mappingDeclCS = methodCS.getMappingDeclarationCS();
        if (mappingDeclCS != null) {
            if (mappingDeclCS.getSimpleNameCS() != null) {
                return mappingDeclCS.getSimpleNameCS();
            }
            if (mappingDeclCS.getContextType() != null) {
                return mappingDeclCS.getContextType();
            }
        }
        return methodCS;
    }

    public static <T> Collection<T> selectDuplicateQualifiers(List<T> elements) {
        Set result = null;
        for (T nextQualifier : elements) {
            if (Collections.frequency(elements, nextQualifier) <= 1) continue;
            if (result == null) {
                result = new HashSet(2);
            }
            result.add(nextQualifier);
        }
        return result != null ? result : Collections.emptySet();
    }

    public static Module createModule(MappingModuleCS moduleCS) {
        EList sequenceOfNames;
        String name = null;
        TransformationHeaderCS headerCS = moduleCS.getHeaderCS();
        if (headerCS != null && headerCS.getPathNameCS() != null && !(sequenceOfNames = headerCS.getPathNameCS().getSequenceOfNames()).isEmpty()) {
            name = (String)sequenceOfNames.get(0);
        }
        Module module = moduleCS instanceof LibraryCS ? QvtOperationalStdLibrary.createLibrary(name) : QvtOperationalStdLibrary.INSTANCE.createTransformation(name);
        moduleCS.setAst((Object)module);
        if (headerCS != null) {
            ASTSyntheticNode astNode = ASTSyntheticNodeAccess.createASTNode((EObject)module);
            astNode.setStartPosition(headerCS.getStartOffset());
            astNode.setEndPosition(headerCS.getEndOffset());
        }
        return module;
    }

    public static List<ImportCS> getImports(UnitCS unitCS) {
        ArrayList<ImportCS> allImports = new ArrayList<ImportCS>();
        allImports.addAll((Collection<ImportCS>)unitCS.getImports());
        for (MappingModuleCS nextModule : unitCS.getModules()) {
            allImports.addAll((Collection<ImportCS>)nextModule.getImports());
        }
        return allImports;
    }

    public static List<ModelTypeCS> getModelTypes(UnitCS unitCS) {
        ArrayList<ModelTypeCS> modelTypes = new ArrayList<ModelTypeCS>();
        modelTypes.addAll((Collection<ModelTypeCS>)unitCS.getModelTypes());
        for (MappingModuleCS nextModule : unitCS.getModules()) {
            modelTypes.addAll((Collection<ModelTypeCS>)nextModule.getMetamodels());
        }
        return modelTypes;
    }

    public static String wrappInSeeErrorLogMessage(String message) {
        return NLS.bind((String)ValidationMessages.QvtOperationalVisitorCS_SeeErrorLogForDetails, (Object)message);
    }

    public static Variable<EClassifier, EParameter> getThisVariable(Module module) {
        for (Variable var : module.getOwnedVariable()) {
            if (!"this".equals(var.getName())) continue;
            return var;
        }
        return null;
    }

    public static boolean isExtendingEnv(QvtEnvironmentBase env, Module extended) {
        if (extended == null) {
            throw new IllegalArgumentException();
        }
        for (QvtEnvironmentBase extEnv : env.getAllExtendedModules()) {
            if (extended != extEnv.getModuleContextType()) continue;
            return true;
        }
        return false;
    }
}

